/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.File;
import java.util.Hashtable;
import java.util.logging.Level;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.Property;
import net.minecraftforge.lex.yunomakegoodmap.VoidWorldType;
import net.minecraftforge.lex.yunomakegoodmap.WorldProviderEndVoid;
import net.minecraftforge.lex.yunomakegoodmap.WorldProviderHellVoid;
import net.minecraftforge.lex.yunomakegoodmap.WorldProviderSurfaceVoid;

@Mod(modid="YUNoMakeGoodMap", name="YUNoMakeGoodMap", version="3.0")
public class YUNoMakeGoodMap {
    @Mod.Instance(value="YUNoMakeGoodMap")
    public static YUNoMakeGoodMap instance;
    private VoidWorldType worldType;
    private boolean overrideDefault = false;
    private String platformType = "grass";

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        Configuration config = null;
        File cfgFile = event.getSuggestedConfigurationFile();
        try {
            config = new Configuration(cfgFile);
        }
        catch (Exception e) {
            FMLLog.severe((String)"[YUNoMakeGoodMap] Error loading config, deleting file and resetting: ", (Object[])new Object[0]);
            e.printStackTrace();
            if (cfgFile.exists()) {
                cfgFile.delete();
            }
            config = new Configuration(cfgFile);
        }
        Property prop = config.get("general", "overrideDefault", this.overrideDefault);
        prop.comment = "Set to true to force the default world types to be void world. Use with caution.";
        this.overrideDefault = prop.getBoolean(this.overrideDefault);
        prop = config.get("general", "platformType", this.platformType);
        prop.comment = "Set the type of platform to create in the overworld, Possible values: 'grass' A single grass block, 'tree' a small oak tree on a grass block.";
        this.platformType = prop.getString();
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        FMLLog.log((Level)Level.INFO, (String)"YUNoMakeGoodMap Initalized", (Object[])new Object[0]);
        LanguageRegistry.instance().addStringLocalization("generator.void", "Void World");
        for (int x = 0; x < WorldType.field_77139_a.length; ++x) {
            if (WorldType.field_77139_a[x] != null) continue;
            FMLLog.log((Level)Level.INFO, (String)"YUNoMakeGoodMap Type ID: %d", (Object[])new Object[]{x});
            this.worldType = new VoidWorldType(x);
            break;
        }
        Hashtable providers = (Hashtable)ReflectionHelper.getPrivateValue(DimensionManager.class, null, (String[])new String[]{"providers"});
        providers.put(-1, WorldProviderHellVoid.class);
        providers.put(0, WorldProviderSurfaceVoid.class);
        providers.put(1, WorldProviderEndVoid.class);
    }

    public boolean shouldBeVoid(World world) {
        return this.overrideDefault || world.func_72912_H().func_76067_t() == this.worldType;
    }

    public String getPlatformType() {
        if (this.platformType == null) {
            this.platformType = "grass";
        }
        if (this.platformType.equalsIgnoreCase("tree")) {
            return "tree";
        }
        return "grass";
    }
}

