package net.minecraftforge.lex.yunomakegoodmap;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeEndDecorator;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderEnd;
import net.minecraft.world.gen.feature.WorldGenSpikes;
import net.minecraft.world.gen.structure.MapGenEndCity;

public class WorldProviderEndVoid extends WorldProviderEnd
{
    public IChunkGenerator func_186060_c()
    {
        if (YUNoMakeGoodMap.instance.shouldBeVoid(field_76579_a))
            return new ChunkProviderEndVoid(field_76579_a, field_76579_a.func_72905_C(), this.getSpawnPoint());
        return new ChunkProviderEnd(field_76579_a, true, field_76579_a.func_72905_C(), this.getSpawnPoint());
    }

    public static class ChunkProviderEndVoid extends ChunkProviderEnd
    {
        private World world;
        private Random endRNG;
        private WorldGenSpikes spikes = new WorldGenSpikes();
        private MapGenEndCity endCityGen = new MapGenEndCity(this);

        public ChunkProviderEndVoid(World world, long seed, BlockPos spawn)
        {
            super(world, false, seed, spawn);
            this.world = world;
            this.endRNG = new Random(seed);
        }

        @Override public void func_185931_b(int x, int z)
        {
            if (YUNoMakeGoodMap.instance.shouldBeVoid(world))
            {
                WorldGenSpikes.EndSpike[] aworldgenspikes$endspike = BiomeEndDecorator.func_185426_a(world);

                for (WorldGenSpikes.EndSpike worldgenspikes$endspike : aworldgenspikes$endspike)
                {
                    if (worldgenspikes$endspike.func_186154_a(new BlockPos(x*16, 0, z*16)))
                    {
                        this.spikes.func_186143_a(worldgenspikes$endspike);
                        this.spikes.func_180709_b(world, endRNG, new BlockPos(worldgenspikes$endspike.func_186151_a(), 45, worldgenspikes$endspike.func_186152_b()));
                    }
                }
            }

            if (YUNoMakeGoodMap.instance.shouldGenerateEndCities(this.world))
            {
                this.endCityGen.func_175794_a(world, endRNG, new ChunkPos(x, z));
            }

            if (x == 0 && z == 0)
            {
                // Allows exit portal to be placed correctly. DragonFightManager will take over from here...
                world.func_175656_a(new BlockPos(0, 45, 0), Blocks.field_150377_bs.func_176223_P());
            }
        }

        @Override public Chunk func_185932_a(int x, int z)
        {
            ChunkPrimer primer = new ChunkPrimer();

            if (YUNoMakeGoodMap.instance.shouldGenerateEndCities(this.world))
                this.endCityGen.func_186125_a(world, x, z, primer);
            else
                this.endCityGen.func_186125_a(world, x, z, null);

            Chunk ret = new Chunk(world, primer, x, z);
            Biome[] biomes = world.func_72959_q().func_76933_b(null, x * 16, z * 16, 16, 16);
            byte[] ids = ret.func_76605_m();

            for (int i = 0; i < ids.length; ++i)
            {
                ids[i] = (byte)Biome.func_185362_a(biomes[i]);
            }

            ret.func_76603_b();
            return ret;
        }
    }
}
