package net.minecraftforge.lex.yunomakegoodmap;

import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkProviderFlat;

public class ChunkProviderFlatVoid extends ChunkProviderFlat
{
    private World world;

    public ChunkProviderFlatVoid(World world)
    {
        super(world, world.func_72905_C(), false, null);
        this.world = world;
        if (this.world.func_175624_G() != WorldType.field_77138_c)
            this.world.func_181544_b(63); //Fixup sea level as they now calculate it in flat worlds.
    }

    @Override public void func_185931_b(int par2, int par3){}

    @Override public Chunk func_185932_a(int x, int z)
    {
        Chunk ret = new Chunk(world, new ChunkPrimer(), x, z);
        Biome[] biomes = world.func_72959_q().func_76933_b(null, x * 16, z * 16, 16, 16);
        byte[] ids = ret.func_76605_m();

        for (int i = 0; i < ids.length; ++i)
        {
            ids[i] = (byte)Biome.func_185362_a(biomes[i]);
        }

        ret.func_76603_b();
        return ret;
    }
}
