/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap.generators;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.lex.yunomakegoodmap.generators.IPlatformGenerator;
import org.apache.commons.compress.utils.IOUtils;

public class StructureLoader
implements IPlatformGenerator {
    private File baseDir;
    private String fileName;

    public StructureLoader(File baseDir, String fileName) {
        this.baseDir = baseDir;
        this.fileName = fileName;
    }

    private Template loadTemplate(ResourceLocation loc, WorldServer world, boolean allowNull) {
        boolean config = "/config/".equals(loc.func_110624_b());
        File file = new File(this.baseDir, loc.func_110623_a() + ".nbt");
        if (config && file.exists()) {
            try {
                return this.loadTemplate(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return allowNull ? null : this.getDefault(world);
            }
        }
        ResourceLocation res = config ? new ResourceLocation("yunomakegoodmap:" + loc.func_110623_a()) : loc;
        Template ret = this.loadTemplate(StructureLoader.class.getResourceAsStream("/assets/" + res.func_110624_b() + "/structures/" + res.func_110623_a() + ".nbt"));
        if (ret != null) {
            return ret;
        }
        new FileNotFoundException(file.toString()).printStackTrace();
        return allowNull ? null : this.getDefault(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template loadTemplate(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)is);
            Template template = new Template();
            template.func_186256_b(nbt);
            Template template2 = template;
            return template2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((Closeable)is);
            }
        }
        return null;
    }

    private Template getDefault(WorldServer world) {
        Template temp = this.loadTemplate(StructureLoader.class.getResourceAsStream("/assets/yunomakegoodmap/structures/SINGLE_GRASS.nbt"));
        if (temp != null) {
            return temp;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("author", "LexManos");
        nbt.func_74768_a("version", 1);
        nbt.func_74782_a("entities", (NBTBase)new NBTTagList());
        nbt.func_74782_a("size", (NBTBase)this.getPosNBT(1, 1, 1));
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)Blocks.field_150349_c.func_176223_P()));
        nbt.func_74782_a("palette", (NBTBase)list);
        list = new NBTTagList();
        NBTTagCompound block = new NBTTagCompound();
        block.func_74782_a("pos", (NBTBase)this.getPosNBT(0, 0, 0));
        block.func_74768_a("state", 0);
        list.func_74742_a((NBTBase)block);
        nbt.func_74782_a("blocks", (NBTBase)list);
        Template ret = new Template();
        ret.func_186256_b(nbt);
        return ret;
    }

    private NBTTagList getPosNBT(int x, int y, int z) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagInt(x));
        list.func_74742_a((NBTBase)new NBTTagInt(y));
        list.func_74742_a((NBTBase)new NBTTagInt(z));
        return list;
    }

    private BlockPos findSpawn(Template temp, PlacementSettings settings) {
        for (Map.Entry e : temp.func_186258_a(new BlockPos(0, 0, 0), settings).entrySet()) {
            if (!"SPAWN_POINT".equals(e.getValue())) continue;
            return (BlockPos)e.getKey();
        }
        return null;
    }

    @Override
    public void generate(World world, BlockPos pos) {
        BlockPos spawn;
        PlacementSettings settings = new PlacementSettings();
        Template temp = null;
        String opts = world.func_72912_H().func_82571_y();
        if (!Strings.isNullOrEmpty((String)opts)) {
            temp = this.loadTemplate(new ResourceLocation(opts), (WorldServer)world, true);
        }
        if (temp == null) {
            temp = this.loadTemplate(new ResourceLocation("/config/", this.fileName), (WorldServer)world, false);
        }
        if ((spawn = this.findSpawn(temp, settings)) != null) {
            pos = pos.func_177973_b((Vec3i)spawn);
            world.func_175652_B(pos);
        }
        temp.func_189962_a(world, pos, settings, 0);
        world.func_175712_a(new StructureBoundingBox((Vec3i)pos, (Vec3i)pos.func_177971_a((Vec3i)temp.func_186259_a())), true);
    }
}

