/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.command.ICommand;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.lex.yunomakegoodmap.PlatformCommand;
import net.minecraftforge.lex.yunomakegoodmap.VoidWorldType;
import net.minecraftforge.lex.yunomakegoodmap.WorldProviderEndVoid;
import net.minecraftforge.lex.yunomakegoodmap.WorldProviderHellVoid;
import net.minecraftforge.lex.yunomakegoodmap.WorldProviderSurfaceVoid;
import net.minecraftforge.lex.yunomakegoodmap.generators.IPlatformGenerator;
import net.minecraftforge.lex.yunomakegoodmap.generators.StructureLoader;
import org.apache.logging.log4j.Level;

@Mod(modid="yunomakegoodmap", name="YUNoMakeGoodMap", version="1.10.2-6.1.0.26", dependencies="after: BiomesOPlenty", acceptedMinecraftVersions="[1.10.2]")
public class YUNoMakeGoodMap {
    public static final String NAME = "YUNoMakeGoodMap";
    public static final String MODID = "yunomakegoodmap";
    @Mod.Instance(value="yunomakegoodmap")
    public static YUNoMakeGoodMap instance;
    private VoidWorldType worldType;
    private boolean overrideDefault = false;
    private String platformType = "grass";
    private boolean generateSpikes = false;
    private boolean generateNetherFortress = false;
    private boolean generateEndCities = false;
    private File configDir = null;
    private File structDir = null;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Configuration config = null;
        this.configDir = new File(event.getModConfigurationDirectory(), NAME);
        this.structDir = new File(this.configDir, "structures");
        if (!this.structDir.exists()) {
            this.structDir.mkdirs();
        }
        File cfgFile = new File(this.configDir, "YUNoMakeGoodMap.cfg");
        if (event.getSuggestedConfigurationFile().exists() && !cfgFile.exists()) {
            event.getSuggestedConfigurationFile().renameTo(cfgFile);
        }
        try {
            config = new Configuration(cfgFile);
        }
        catch (Exception e) {
            FMLLog.severe((String)"[YUNoMakeGoodMap] Error loading config, deleting file and resetting: ", (Object[])new Object[0]);
            e.printStackTrace();
            if (cfgFile.exists()) {
                cfgFile.delete();
            }
            config = new Configuration(cfgFile);
        }
        Property prop = config.get("general", "overrideDefault", this.overrideDefault);
        prop.setComment("Set to true to force the default world types to be void world. Use with caution.");
        this.overrideDefault = prop.getBoolean(this.overrideDefault);
        prop = config.get("general", "platformType", this.platformType);
        prop.setComment("Set the type of platform to create in the overworld, Possible values: \n  'STRUCT_NAME' for custom Structure Files, located in /config/YUNoMakeGoodMap/structures/\n    Example: 'struct:COBBLE_GEN' to use /config/YUNoMakeGoodMap/structures/COBBLE_GEN.nbt\n  \n  Default ones provided with this mod:\n  'SINGLE_GRASS' A single grass block\n  'TREE' a small oak tree on a grass block\n  'SKYBLOCK21' For SkyBlock v2.1 platforms\n  'COBBLE_GEN' Small platform with a pre-built cobble gen\n  \n  Other mods can supply platforms as well just need to specify it by using modid:STRUCT_NAME\n  Which will try and load /assets/modid/structures/STRUCT_NAME.nbt");
        this.platformType = prop.getString();
        prop = config.get("general", "generateSpikes", this.generateSpikes);
        prop.setComment("Set to true to enable generation of the obsidian 'spikes' in the end.");
        this.generateSpikes = prop.getBoolean(this.generateSpikes);
        prop = config.get("general", "generateNetherFortress", this.generateNetherFortress);
        prop.setComment("Set to true to enable generation of the nether fortresses.");
        this.generateNetherFortress = prop.getBoolean(this.generateNetherFortress);
        prop = config.get("general", "generateEndCities", this.generateEndCities);
        prop.setComment("Set to true to enable generation of the end cities.");
        this.generateEndCities = prop.getBoolean(this.generateEndCities);
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        FMLLog.log((Level)Level.INFO, (String)"YUNoMakeGoodMap Initalized", (Object[])new Object[0]);
        this.worldType = new VoidWorldType();
        DimensionManager.unregisterDimension((int)-1);
        DimensionManager.unregisterDimension((int)0);
        DimensionManager.unregisterDimension((int)1);
        DimensionManager.registerDimension((int)-1, (DimensionType)DimensionType.register((String)"Nether", (String)"_nether", (int)-1, WorldProviderHellVoid.class, (boolean)false));
        DimensionManager.registerDimension((int)0, (DimensionType)DimensionType.register((String)"Overworld", (String)"", (int)0, WorldProviderSurfaceVoid.class, (boolean)true));
        DimensionManager.registerDimension((int)1, (DimensionType)DimensionType.register((String)"The End", (String)"_end", (int)1, WorldProviderEndVoid.class, (boolean)false));
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new PlatformCommand());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && event.getWorld() instanceof WorldServer) {
            WorldServer world = (WorldServer)event.getWorld();
            int spawnX = (int)((double)event.getWorld().func_72912_H().func_76079_c() / world.field_73011_w.getMovementFactor() / 16.0);
            int spawnZ = (int)((double)event.getWorld().func_72912_H().func_76074_e() / world.field_73011_w.getMovementFactor() / 16.0);
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    world.func_72863_F().func_186028_c(spawnX + x, spawnZ + z);
                }
            }
        }
    }

    public boolean shouldBeVoid(World world) {
        return this.overrideDefault || world.func_72912_H().func_76067_t() == this.worldType;
    }

    public IPlatformGenerator getPlatformType(World world) {
        if (this.platformType == null) {
            this.platformType = "SINGLE_GRASS";
        }
        if (this.platformType.equals("grass")) {
            this.platformType = "SINGLE_GRASS";
        } else if (this.platformType.equals("tree")) {
            this.platformType = "TREE";
        } else if (this.platformType.equals("skyblock21")) {
            this.platformType = "SKYBLOCK21";
        } else if (this.platformType.startsWith("struct:")) {
            this.platformType = this.platformType.substring(7);
        }
        return new StructureLoader(this.structDir, this.platformType);
    }

    public boolean shouldGenerateSpikes(World world) {
        return this.generateSpikes;
    }

    public boolean shouldGenerateNetherFortress(World world) {
        return this.generateNetherFortress;
    }

    public boolean shouldGenerateEndCities(World world) {
        return this.generateEndCities;
    }

    public File getStructFolder() {
        return this.structDir;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onOpenGui(GuiOpenEvent e) {
        if (e.getGui() instanceof GuiCreateWorld && Minecraft.func_71410_x().field_71462_r instanceof GuiWorldSelection) {
            GuiCreateWorld cw = (GuiCreateWorld)e.getGui();
            ReflectionHelper.setPrivateValue(GuiCreateWorld.class, (Object)cw, (Object)this.worldType.func_82747_f(), (String[])new String[]{"field_146331_K", "selectedIndex"});
        }
    }
}

