/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.lex.yunomakegoodmap.YUNoMakeGoodMap;
import net.minecraftforge.lex.yunomakegoodmap.generators.StructureLoader;
import org.apache.commons.compress.utils.IOUtils;

public class StructureUtil {
    public static Template loadTemplate(ResourceLocation loc, WorldServer world, boolean allowNull) {
        boolean config = "/config/".equals(loc.func_110624_b());
        File file = new File(YUNoMakeGoodMap.instance.getStructFolder(), loc.func_110623_a() + ".nbt");
        if (config && file.exists()) {
            try {
                return StructureUtil.loadTemplate(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return allowNull ? null : StructureUtil.getDefault(world);
            }
        }
        ResourceLocation res = config ? new ResourceLocation("yunomakegoodmap:" + loc.func_110623_a()) : loc;
        Template ret = StructureUtil.loadTemplate(StructureLoader.class.getResourceAsStream("/assets/" + res.func_110624_b() + "/structures/" + res.func_110623_a() + ".nbt"));
        if (ret != null) {
            return ret;
        }
        new FileNotFoundException(file.toString()).printStackTrace();
        return allowNull ? null : StructureUtil.getDefault(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Template loadTemplate(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)is);
            Template template = new Template();
            template.func_186256_b(nbt);
            Template template2 = template;
            return template2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((Closeable)is);
            }
        }
        return null;
    }

    private static Template getDefault(WorldServer world) {
        Template temp = StructureUtil.loadTemplate(StructureLoader.class.getResourceAsStream("/assets/yunomakegoodmap/structures/SINGLE_GRASS.nbt"));
        if (temp != null) {
            return temp;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("author", "LexManos");
        nbt.func_74768_a("version", 1);
        nbt.func_74782_a("entities", (NBTBase)new NBTTagList());
        nbt.func_74782_a("size", (NBTBase)StructureUtil.getPosNBT(1, 1, 1));
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)Blocks.field_150349_c.func_176223_P()));
        nbt.func_74782_a("palette", (NBTBase)list);
        list = new NBTTagList();
        NBTTagCompound block = new NBTTagCompound();
        block.func_74782_a("pos", (NBTBase)StructureUtil.getPosNBT(0, 0, 0));
        block.func_74768_a("state", 0);
        list.func_74742_a((NBTBase)block);
        nbt.func_74782_a("blocks", (NBTBase)list);
        Template ret = new Template();
        ret.func_186256_b(nbt);
        return ret;
    }

    private static NBTTagList getPosNBT(int x, int y, int z) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagInt(x));
        list.func_74742_a((NBTBase)new NBTTagInt(y));
        list.func_74742_a((NBTBase)new NBTTagInt(z));
        return list;
    }

    public static BlockPos findSpawn(Template temp, PlacementSettings settings) {
        for (Map.Entry e : temp.func_186258_a(new BlockPos(0, 0, 0), settings).entrySet()) {
            if (!"SPAWN_POINT".equals(e.getValue())) continue;
            return (BlockPos)e.getKey();
        }
        return null;
    }
}

