package net.minecraftforge.lex.yunomakegoodmap;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class WorldProviderHellVoid extends WorldProviderHell
{
    public IChunkGenerator func_186060_c()
    {
        if (YUNoMakeGoodMap.instance.shouldBeVoid(field_76579_a))
            return new ChunkProviderHellVoid(field_76579_a, YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(field_76579_a), field_76579_a.func_72905_C());

        return new ChunkProviderHell(field_76579_a, YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(field_76579_a), field_76579_a.func_72905_C());
    }

    public static class ChunkProviderHellVoid extends ChunkProviderHell
    {
        private World world;
        private Random hellRNG;
        private MapGenNetherBridge genNetherBridge = new MapGenNetherBridge();

        public ChunkProviderHellVoid(World world, boolean shouldGenNetherFortress, long seed)
        {
            super(world, shouldGenNetherFortress, seed);
            this.world = world;
            this.hellRNG = new Random(seed);
            this.genNetherBridge = (MapGenNetherBridge)TerrainGen.getModdedMapGen(genNetherBridge, InitMapGenEvent.EventType.NETHER_BRIDGE);
        }
        
        @Override
        public void func_185931_b(int x, int z)
        {
            if(YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(world))
                genNetherBridge.func_175794_a(world, hellRNG, new ChunkPos(x, z));

            int spawnX = world.func_72912_H().func_76079_c() / 8;
            int spawnY = world.func_72912_H().func_76075_d();
            int spawnZ = world.func_72912_H().func_76074_e() / 8;
            if (x == spawnX / 16 && z == spawnZ / 16)
            {
                YUNoMakeGoodMap.instance.getPlatformType(world).generate(world, new BlockPos(spawnX, spawnY, spawnZ));
                // Spawn should always be within linking distance of this portal, if not, they need to move closer :/
            }
        }

        @Override
        public Chunk func_185932_a(int x, int z)
        {
            ChunkPrimer data = new ChunkPrimer();

            if(YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(world))
                genNetherBridge.func_186125_a(world, x, z, data);
            //else
                //genNetherBridge.worldObj = world;

            Chunk ret = new Chunk(world, data, x, z);
            Biome[] biomes = world.func_72959_q().func_76933_b(null, x * 16, z * 16, 16, 16);
            byte[] ids = ret.func_76605_m();

            for (int i = 0; i < ids.length; ++i)
            {
                ids[i] = (byte)Biome.func_185362_a(biomes[i]);
            }

            ret.func_76603_b();
            return ret;
        }
    }
}
