package net.minecraftforge.lex.yunomakegoodmap;

import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.lex.yunomakegoodmap.generators.IPlatformGenerator;

public class VoidWorldChunkManager extends BiomeProvider
{
    private World world;
    
    public VoidWorldChunkManager(World world)
    {
        super(world.func_72912_H());
        this.world = world;
    }

    @Override
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random rand)
    {
        BlockPos ret = super.func_180630_a(x, z, range, biomes, rand);
        if (x == 0 && z == 0 && !world.func_72912_H().func_76070_v())
        {
            if (ret == null)
            {
                ret = BlockPos.field_177992_a;
            }

            buildSpawn(world, new BlockPos(ret.func_177958_n(), world.field_73011_w.func_76557_i(), ret.func_177952_p()));
        }
        return ret;
    }

    private void buildSpawn(World world, BlockPos pos)
    {
        FMLLog.info("[YUNoMakeGoodMap] Building spawn platform at: %d, %d, %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        IPlatformGenerator platform = YUNoMakeGoodMap.instance.getPlatformType(world);
        platform.generate(world, pos);
    }
}
