package net.minecraftforge.lex.yunomakegoodmap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

import javax.annotation.Nullable;

import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;

import net.minecraft.block.BlockStructure;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.tileentity.TileEntityStructure.Mode;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class PlatformCommand extends CommandBase
{
    private List<ResourceLocation> platforms = Lists.newArrayList();

    @Override
    public String func_71517_b()
    {
        return "platform";
    }

    @Override
    public int func_82362_a()
    {
        return 3; //Admins?
    }

    @Override
    public String func_71518_a(ICommandSender sender)
    {
        return "command.yunmgm.platform.usage";
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos)
    {
        boolean spawn = "spawn".equalsIgnoreCase(args[0]) || "preview".equalsIgnoreCase(args[0]);

        if (args.length == 1)
            return func_175762_a(args, Lists.newArrayList("list", "spawn", "preview"));
        else if (args.length == 2 && spawn)
            return func_175762_a(args, getPlatforms());
        else if (args.length == 3 && spawn)
            return Lists.newArrayList("0", "90", "180", "270");

        return Collections.<String>emptyList();
    }

    private List<ResourceLocation> getPlatforms()
    {
        if (platforms.size() == 0)
        {
            for (ModContainer mc : Loader.instance().getModList())
            {
                File src = mc.getSource();
                if (src == null)
                    continue;

                InputStream is = getClass().getResourceAsStream("/assets/" + mc.getModId() + "/structures/SkyBlockPlatforms.txt");
                if (is == null)
                    continue;
                try
                {
                    for (String line : CharStreams.readLines(new InputStreamReader(is)))
                    {
                        if (getClass().getResourceAsStream("/assets/" + mc.getModId() + "/structures/" + line + ".nbt") != null)
                            platforms.add(new ResourceLocation(mc.getModId(), line));
                    }
                } catch (IOException e)
                {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }

            for (File f : YUNoMakeGoodMap.instance.getStructFolder().listFiles())
            {
                if (!f.isFile() || !f.getName().endsWith(".nbt"))
                    continue;
                platforms.add(new ResourceLocation("/config/", f.getName().substring(0, f.getName().length() - 4)));
            }
        }

        return platforms;
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException
    {
        if (args.length < 1)
            throw new WrongUsageException(func_71518_a(sender));

        String cmd = args[0].toLowerCase(Locale.ENGLISH);
        if ("list".equals(cmd))
        {
            sender.func_145747_a(new TextComponentString("Known Platforms:"));
            for (ResourceLocation rl : getPlatforms())
            {
                sender.func_145747_a(new TextComponentString("  " + rl.toString()));
            }
        }
        else if ("spawn".equals(cmd) || "preview".equals(cmd))
        {
            if (args.length < 2)
                throw new WrongUsageException(func_71518_a(sender));

            Entity ent = sender.func_174793_f();
            PlacementSettings settings = new PlacementSettings();
            WorldServer world = (WorldServer)sender.func_130014_f_();

            if (args.length >= 3)
            {
                String rot = args[2].toLowerCase(Locale.ENGLISH);
                if ("0".equals(rot) || "none".equals(rot))
                    settings.func_186220_a(Rotation.NONE);
                else if ("90".equals(rot))
                    settings.func_186220_a(Rotation.CLOCKWISE_90);
                else if ("180".equals(rot))
                    settings.func_186220_a(Rotation.CLOCKWISE_180);
                else if ("270".equals(rot))
                    settings.func_186220_a(Rotation.COUNTERCLOCKWISE_90);
                else
                    throw new WrongUsageException("Only rotations none, 0, 90, 180, and 270 allowed.");
            }

            BlockPos pos;
            if (args.length >= 6)
                pos = CommandBase.func_175757_a(sender, args, 2, false);
            else if (ent != null)
                pos = ent.func_180425_c();
            else
                throw new WrongUsageException("Must specify a position if the command sender is not an entity");

            Template temp = StructureUtil.loadTemplate(new ResourceLocation(args[1]), world, true);

            BlockPos spawn = StructureUtil.findSpawn(temp, settings);
            if (spawn != null)
                pos = pos.func_177973_b(spawn);

            if ("spawn".equals(cmd))
            {
                sender.func_145747_a(new TextComponentString("Building \"" + args[1] +"\" at " + pos.toString()));
                temp.func_189962_a(world, pos, settings, 2); //Push to world, with no neighbor notifications!
                world.func_175712_a(new StructureBoundingBox(pos, pos.func_177971_a(temp.func_186259_a())), true); //Remove block updates, so that sand doesn't fall!
            }
            else
            {
                BlockPos tpos = pos.func_177977_b();
                if (spawn != null)
                    tpos = tpos.func_177971_a(spawn);
                sender.func_145747_a(new TextComponentString("Previewing \"" + args[1] +"\" at " + pos.toString()));
                world.func_175656_a(tpos, Blocks.field_185779_df.func_176223_P().func_177226_a(BlockStructure.field_185587_a, TileEntityStructure.Mode.LOAD));
                TileEntityStructure te = (TileEntityStructure)world.func_175625_s(tpos);
                if (spawn != null)
                    te.func_184414_b(te.func_189711_e().func_177973_b(spawn));
                te.func_184409_c(temp.func_186259_a());
                te.func_184405_a(Mode.LOAD);
                te.func_70296_d();
            }
        }
        else
            throw new WrongUsageException(func_71518_a(sender));
    }
}
