/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.mappingtoy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class VersionJson {
    public static final String MOJANG_LIBRARY_URL = "https://libraries.minecraft.net/";
    String id;
    Map<String, Download> downloads;
    AssetIndex assetIndex;
    String assets;
    LibraryInfo[] libraries;
    String mainClass;
    int minimumLauncherVersion;
    Date releaseTime;
    Date time;
    String type;
    String inheritsFrom;
    String key;

    public Map<String, Download> getDownloads() {
        return this.downloads == null ? Collections.emptyMap() : this.downloads;
    }

    public List<DownloadInfo> getLibraries() {
        ArrayList<DownloadInfo> ret = new ArrayList<DownloadInfo>();
        for (LibraryInfo lib : this.libraries) {
            if (lib.downloads == null) {
                String[] pts = lib.name.split(":");
                String path = pts[0].replace('.', '/') + '/' + pts[1] + '/' + pts[2] + '/' + pts[1] + '-' + pts[2] + (pts.length > 3 ? '-' + pts[3] : "") + ".jar";
                ret.add(new DownloadInfo(path, MOJANG_LIBRARY_URL + path));
                continue;
            }
            if (lib.downloads.artifact != null) {
                ret.add(new DownloadInfo(lib.downloads.artifact.path, lib.downloads.artifact));
            }
            if (lib.downloads.classifiers == null) continue;
            for (Artifact art : lib.downloads.classifiers.values()) {
                ret.add(new DownloadInfo(art.path, art));
            }
        }
        return ret;
    }

    public static class DownloadInfo
    extends Download {
        String path;

        DownloadInfo(String path, String url) {
            this.path = path;
            this.url = url;
        }

        DownloadInfo(String path, Download other) {
            this.path = path;
            this.copy(other);
        }

        @Override
        public String toString() {
            return "DownloadInfo{url=" + this.url + ";size=" + this.size + ";sha1=" + this.sha1 + ";path=" + this.path + "}";
        }
    }

    public static class AssetIndex
    extends Download {
        String id;
        long totalSize;

        @Override
        public String toString() {
            return "DownloadInfo{url=" + this.url + ";size=" + this.size + ";sha1=" + this.sha1 + ";id=" + this.id + ";totalSize=" + this.totalSize + "}";
        }
    }

    public static class Artifact
    extends Download {
        String path;

        @Override
        public String toString() {
            return "DownloadInfo{url=" + this.url + ";size=" + this.size + ";sha1=" + this.sha1 + ";path=" + this.path + "}";
        }
    }

    public static class Download {
        int size;
        String sha1;
        String url;

        protected void copy(Download other) {
            this.size = other.size;
            this.sha1 = other.sha1;
            this.url = other.url;
        }

        public String toString() {
            return "DownloadInfo{url=" + this.url + ";size=" + this.size + ";sha1=" + this.sha1 + "}";
        }
    }

    public static class Downloads {
        Map<String, Artifact> classifiers;
        Artifact artifact;
    }

    public static class LibraryInfo {
        String name;
        String url;
        Downloads downloads;
    }
}

