/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.mappingtoy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public enum HashFunction {
    MD5("md5", 32),
    SHA1("SHA-1", 40),
    SHA256("SHA-256", 64);

    private String algo;
    private String pad;

    private HashFunction(String algo, int length) {
        this.algo = algo;
        this.pad = String.format("%0" + length + "d", 0);
    }

    public String getExtension() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public MessageDigest get() {
        try {
            return MessageDigest.getInstance(this.algo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String hash(File file) throws IOException {
        try (FileInputStream fin = new FileInputStream(file);){
            String string = this.hash(fin);
            return string;
        }
    }

    public String hash(Path file) throws IOException {
        try (InputStream fin = Files.newInputStream(file, new OpenOption[0]);){
            String string = this.hash(fin);
            return string;
        }
    }

    public String hashSafe(Path file) {
        try {
            return this.hash(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String hash(String data) {
        return this.hash(data.getBytes(StandardCharsets.UTF_8));
    }

    public String hash(InputStream stream) throws IOException {
        int nRead;
        MessageDigest digest = this.get();
        byte[] data = new byte[5120];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            digest.update(data, 0, nRead);
        }
        String hash = new BigInteger(1, digest.digest()).toString(16);
        return (this.pad + hash).substring(hash.length());
    }

    public String hash(byte[] data) {
        String hash = new BigInteger(1, this.get().digest(data)).toString(16);
        return (this.pad + hash).substring(hash.length());
    }
}

