/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.mappingtoy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import net.minecraftforge.lex.mappingtoy.DateTypeAdapter;
import net.minecraftforge.lex.mappingtoy.HashFunction;
import net.minecraftforge.lex.mappingtoy.MappingToy;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class Utils {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter()).setPrettyPrinting().create();
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static int[] FLAGS = new int[]{1, 2, 4, 8, 16, 32, 32, 64, 64, 128, 128, 256, 512, 1024, 2048, 4096, 8192, 16384};
    private static String[] NAMES = new String[]{"public", "private", "protected", "static", "final", "super", "synchronized", "volitize", "bridge", "varargs", "transient", "native", "interface", "abstract", "strict", "synthetic", "annotation", "enum"};

    public static boolean downloadFileEtag(Path file, String url) {
        return Utils.downloadFileEtag(file, url, false);
    }

    public static boolean downloadFileEtag(Path file, String url, boolean force) {
        return Utils.downloadFileEtag(file, url, force, "  ");
    }

    public static boolean downloadFileEtag(Path file, String url, boolean force, String prefix) {
        return Utils.downloadFileEtag(file, Utils.makeURL(url), force, prefix);
    }

    public static boolean downloadFileEtag(Path file, URL url) {
        return Utils.downloadFileEtag(file, url, false);
    }

    public static boolean downloadFileEtag(Path file, URL url, boolean force) {
        return Utils.downloadFileEtag(file, url, force, "  ");
    }

    public static boolean downloadFileEtag(Path file, URL url, boolean force, String prefix) {
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
            connection.setRequestProperty("Expires", "0");
            connection.setRequestProperty("Pragma", "no-cache");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            if (!force && Files.isRegularFile(file, new LinkOption[0])) {
                connection.setRequestProperty("If-None-Match", '\"' + HashFunction.MD5.hash(file) + '\"');
            }
            connection.connect();
            String etag = connection.getHeaderField("ETag");
            if (etag == null) {
                etag = "-";
            } else if (etag.startsWith("\"") && etag.endsWith("\"")) {
                etag = etag.substring(1, etag.length() - 1);
            }
            int response = connection.getResponseCode();
            if (response == 304) {
                return true;
            }
            MappingToy.log.info(prefix + file.toString() + " From: " + url.toString());
            try (InputStream in = connection.getInputStream();
                 OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                Utils.copy(in, out);
            }
            if (etag.indexOf(45) != -1) {
                return true;
            }
            String md5 = HashFunction.MD5.hash(file);
            if (!etag.equalsIgnoreCase(md5)) {
                MappingToy.log.info(prefix + "  ETag: " + etag);
                MappingToy.log.info(prefix + "  MD5:  " + md5);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            MappingToy.log.log(Level.SEVERE, prefix + "  Error: " + file.toString(), e);
            return false;
        }
    }

    public static boolean downloadFile(Path file, URL url, String prefix) {
        try {
            MappingToy.log.info(prefix + file.toString() + " From: " + url.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setUseCaches(false);
            connection.setDefaultUseCaches(false);
            connection.setRequestProperty("Cache-Control", "no-store,max-age=0,no-cache");
            connection.setRequestProperty("Expires", "0");
            connection.setRequestProperty("Pragma", "no-cache");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.connect();
            try (InputStream in = connection.getInputStream();
                 OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
                Utils.copy(in, out);
            }
            return true;
        }
        catch (Exception e) {
            MappingToy.log.log(Level.SEVERE, prefix + "  Error: " + file.toString(), e);
            return false;
        }
    }

    public static URL makeURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException e) {
            MappingToy.log.log(Level.SEVERE, "Malformed URL: " + string, e);
            return null;
        }
    }

    public static byte[] readStreamFully(Path path) throws IOException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            byte[] byArray = Utils.readStreamFully(in);
            return byArray;
        }
    }

    public static byte[] readStreamFully(InputStream is) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(Math.max(8192, is.available()));
        byte[] buffer = new byte[8192];
        while ((read = is.read(buffer)) >= 0) {
            baos.write(buffer, 0, read);
        }
        return baos.toByteArray();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        int count = 0;
        int c = 0;
        byte[] buf = new byte[5120];
        while ((c = in.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, c);
            count += c;
        }
        return count;
    }

    public static <T> T loadJson(Path target, Class<T> clz) throws IOException {
        try (InputStream in = Files.newInputStream(target, new OpenOption[0]);){
            Object object = GSON.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), clz);
            return (T)object;
        }
    }

    public static void writeJson(Path target, Object obj) throws IOException {
        Files.write(target, GSON.toJson(obj).getBytes(), new OpenOption[0]);
    }

    public static Path findMinecraftHome() {
        String userHomeDir = System.getProperty("user.home", ".");
        String osType = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (osType.contains("win") && System.getenv("APPDATA") != null) {
            return new File(System.getenv("APPDATA"), ".minecraft").toPath();
        }
        if (osType.contains("mac")) {
            return new File(new File(new File(userHomeDir, "Library"), "Application Support"), "minecraft").toPath();
        }
        return new File(userHomeDir, ".minecraft").toPath();
    }

    public static ZipEntry getStableEntry(String name) {
        TimeZone _default = TimeZone.getDefault();
        TimeZone.setDefault(GMT);
        ZipEntry ret = new ZipEntry(name);
        ret.setTime(628041600000L);
        TimeZone.setDefault(_default);
        return ret;
    }

    public static String getAccess(int access) {
        StringBuilder out = new StringBuilder();
        for (int x = 0; x < FLAGS.length; ++x) {
            if ((access & FLAGS[x]) != FLAGS[x]) continue;
            out.append(NAMES[x]).append(" ");
        }
        if (out.length() > 0) {
            return out.toString().trim();
        }
        return "default";
    }

    public static String toString(InsnList lst) {
        Textifier printer = new Textifier();
        lst.accept((MethodVisitor)new TraceMethodVisitor((Printer)printer));
        StringWriter writer = new StringWriter();
        printer.print(new PrintWriter(writer));
        return ((Object)writer).toString();
    }
}

