/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.mappingtoy;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraftforge.lex.mappingtoy.DownloadType;
import net.minecraftforge.lex.mappingtoy.HashFunction;
import net.minecraftforge.lex.mappingtoy.JarMetadata;
import net.minecraftforge.lex.mappingtoy.JarRenamer;
import net.minecraftforge.lex.mappingtoy.ManifestJson;
import net.minecraftforge.lex.mappingtoy.Utils;
import net.minecraftforge.lex.mappingtoy.VersionJson;
import net.minecraftforge.mergetool.AnnotationVersion;
import net.minecraftforge.mergetool.Merger;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.MinecraftVersion;

public class MappingToy {
    public static final Logger log = Logger.getLogger("MappingToy");

    public static void main(String[] args) throws SecurityException, IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec versionO = parser.accepts("version").withRequiredArg();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0])).defaultsTo((Object)Paths.get("output", new String[0]), (Object[])new Path[0]);
        ArgumentAcceptingOptionSpec minecraftO = parser.accepts("mc").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0])).defaultsTo((Object)Utils.findMinecraftHome(), (Object[])new Path[0]);
        OptionSpecBuilder allO = parser.accepts("all");
        OptionSpecBuilder libsO = parser.accepts("libs");
        ArgumentAcceptingOptionSpec logO = parser.accepts("log").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        OptionSpecBuilder forceO = parser.accepts("force", "Force rebuilding of everything even if files already exist, Mainly for debugging");
        OptionSet options = parser.parse(args);
        Set versions = options.valuesOf((OptionSpec)versionO).stream().map(MinecraftVersion::from).collect(Collectors.toCollection(TreeSet::new));
        Path output = (Path)options.valueOf((OptionSpec)outputO);
        Path minecraft = (Path)options.valueOf((OptionSpec)minecraftO);
        boolean all = options.has((OptionSpec)allO);
        boolean libs = all || options.has((OptionSpec)libsO);
        boolean force = options.has((OptionSpec)forceO);
        if (!Files.isDirectory(minecraft, new LinkOption[0])) {
            System.out.println("Specificed --mc directory does not exist: " + minecraft);
            return;
        }
        log.setUseParentHandlers(false);
        log.setLevel(Level.ALL);
        if (options.has((OptionSpec)logO)) {
            FileHandler filehandler = new FileHandler(((Path)options.valueOf((OptionSpec)logO)).toFile().getAbsolutePath());
            filehandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    StringBuffer sb = new StringBuffer();
                    String message = this.formatMessage(record);
                    sb.append(record.getLevel().getName());
                    sb.append(": ");
                    sb.append(message);
                    sb.append("\n");
                    if (record.getThrown() != null) {
                        try {
                            StringWriter sw = new StringWriter();
                            try (PrintWriter pw = new PrintWriter(sw);){
                                record.getThrown().printStackTrace(pw);
                            }
                            sb.append(sw.toString());
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    return sb.toString();
                }
            });
            log.addHandler(filehandler);
        }
        log.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                System.out.println(String.format(record.getMessage(), record.getParameters()));
                if (record.getThrown() != null) {
                    record.getThrown().printStackTrace();
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        log.info("The mappings, and data downloaded by this project is (c) Microsoft Corporation. All rights reserved.");
        log.info("That information is provided \"as-is\" and you bear the risk of using it.");
        log.info("This information does not provide you with any legal rights to any intellectual property in any Microsoft product.");
        log.info("You may copy and use this information for your internal, reference purposes.");
        log.info("Microsoft makes no warranties, express or implied, with respect to the information provided.");
        log.info("==================================================================================================================");
        log.info("This means you can only use this program for reference purposes. Please don't be an ass. -Lex");
        log.info("");
        log.info("Output:    " + output);
        log.info("Minecraft: " + minecraft);
        log.info("All:       " + all);
        log.info("Libs:      " + libs);
        log.info("Versions:  " + (versions.isEmpty() ? "All" : versions));
        log.info("Force:     " + force);
        log.info("");
        Files.createDirectories(output, new FileAttribute[0]);
        ManifestJson manifest_json = MappingToy.downloadLauncherManifest(output);
        if (manifest_json == null) {
            return;
        }
        if (versions.isEmpty()) {
            versions.addAll(manifest_json.getEntries().keySet());
        }
        for (MinecraftVersion ver : versions) {
            IMappingFile serverMap;
            log.log(Level.INFO, "Processing " + ver.toString() + ":");
            ManifestJson.Entry mainEntry = manifest_json.getVersion(ver);
            if (mainEntry == null || mainEntry.url == null) {
                log.log(Level.INFO, "  No entry in Launcher Manifest");
                continue;
            }
            Path root = output.resolve(ver.toString());
            Files.createDirectories(root, new FileAttribute[0]);
            VersionJson manifest = MappingToy.downloadVersionJson(root, mainEntry.url);
            if (manifest == null) continue;
            Set<DownloadType> downloaded = MappingToy.downloadMinecraftFiles(root, manifest.getDownloads());
            IMappingFile clientMap = downloaded.contains((Object)DownloadType.CLIENT_MAPPINGS) ? IMappingFile.load((File)root.resolve(DownloadType.CLIENT_MAPPINGS.getFilename()).toFile()) : null;
            boolean mergeable = MappingToy.canMerge(clientMap, serverMap = downloaded.contains((Object)DownloadType.SERVER_MAPPINGS) ? IMappingFile.load((File)root.resolve(DownloadType.SERVER_MAPPINGS.getFilename()).toFile()) : null);
            if (mergeable) {
                MappingToy.writeMappings(root, clientMap, "joined", all, force);
                MappingToy.makeJoinedJar(root, ver, clientMap, true, force);
                JarRenamer.makeMappedJar(root, "joined_o_to_n.tsrg", "joined_a", force);
                if (all) {
                    MappingToy.makeJoinedJar(root, ver, clientMap, false, force);
                    JarRenamer.makeMappedJar(root, "joined_o_to_n.tsrg", "joined", force);
                }
            }
            if (!mergeable || all) {
                if (clientMap != null) {
                    MappingToy.writeMappings(root, clientMap, "client", all, force);
                    JarRenamer.makeMappedJar(root, "client_o_to_n.tsrg", "client", force);
                }
                if (serverMap != null) {
                    MappingToy.writeMappings(root, serverMap, "server", all, force);
                    JarRenamer.makeMappedJar(root, "server_o_to_n.tsrg", "server", force);
                }
            }
            List<Path> libraries = Collections.emptyList();
            if (libs) {
                libraries = MappingToy.downloadLauncherFiles(root, minecraft, ver, manifest);
            }
            if (!mergeable) continue;
            JarMetadata.makeMetadata(root, libraries, clientMap, "joined_a", true, force);
            if (!all) continue;
            JarMetadata.makeMetadata(root, libraries, clientMap, "joined_a_n", false, force);
        }
        log.info("Finished");
    }

    private static ManifestJson downloadLauncherManifest(Path output) {
        Path manifest = output.resolve("launcher_manifest.json");
        if (!Utils.downloadFileEtag(manifest, "https://launchermeta.mojang.com/mc/game/version_manifest.json", false, "Downloading: ")) {
            log.info("    Failed, Exiting");
            return null;
        }
        log.info("Manifest: " + manifest.toString());
        try {
            return Utils.loadJson(manifest, ManifestJson.class);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "    Failed to read json file: " + e.getMessage(), e);
            return null;
        }
    }

    private static VersionJson downloadVersionJson(Path output, URL url) {
        Path target = output.resolve("version.json");
        if (!Utils.downloadFileEtag(target, url, false, "  ")) {
            log.info("    Failed, Exiting");
            return null;
        }
        try {
            return Utils.loadJson(target, VersionJson.class);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "  Failed to read json file: " + e.getMessage(), e);
            return null;
        }
    }

    private static Set<DownloadType> downloadMinecraftFiles(Path output, Map<String, VersionJson.Download> downloads) {
        HashSet<DownloadType> ret = new HashSet<DownloadType>();
        for (DownloadType type : DownloadType.getValues()) {
            String sha;
            Path target = output.resolve(type.getFilename());
            VersionJson.Download info = downloads.get(type.getKey());
            if (info == null) {
                log.info("  Manifest Missing: " + type.getKey());
                continue;
            }
            if (Files.isRegularFile(target, new LinkOption[0]) && info.sha1 != null && (sha = HashFunction.SHA1.hashSafe(target)) != null && info.sha1.equalsIgnoreCase(sha)) {
                ret.add(type);
                continue;
            }
            if (!Utils.downloadFileEtag(target, info.url, false, "  ")) {
                log.info("    Fialed to download: " + target.getFileName());
                continue;
            }
            ret.add(type);
        }
        return ret;
    }

    private static boolean canMerge(IMappingFile client, IMappingFile server) {
        Function<IMappingFile.IField, String> fldToString = fld -> fld.getOriginal() + " " + fld.getDescriptor() + " -> " + fld.getMapped() + " " + fld.getMappedDescriptor();
        Function<IMappingFile.IMethod, String> mtdToString = mtd -> mtd.getOriginal() + " " + mtd.getDescriptor() + " -> " + mtd.getMapped() + " " + mtd.getMappedDescriptor();
        for (IMappingFile.IClass clsS : server.getClasses()) {
            IMappingFile.IClass clsC = client.getClass(clsS.getOriginal());
            if (clsC == null || !clsS.getMapped().equals(clsC.getMapped())) {
                return false;
            }
            Set fldsS = clsS.getFields().stream().map(fldToString).collect(Collectors.toCollection(HashSet::new));
            Set fldsC = clsC.getFields().stream().map(fldToString).collect(Collectors.toCollection(HashSet::new));
            Set mtdsS = clsS.getMethods().stream().map(mtdToString).collect(Collectors.toCollection(HashSet::new));
            Set mtdsC = clsC.getMethods().stream().map(mtdToString).collect(Collectors.toCollection(HashSet::new));
            fldsS.removeAll(fldsC);
            mtdsS.removeAll(mtdsC);
            if (fldsS.isEmpty() && mtdsS.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static void writeMappings(Path output, IMappingFile mapping, String prefix, boolean all, boolean force) {
        IMappingFile.Format[] formatArray;
        if (all) {
            formatArray = IMappingFile.Format.values();
        } else {
            IMappingFile.Format[] formatArray2 = new IMappingFile.Format[1];
            formatArray = formatArray2;
            formatArray2[0] = IMappingFile.Format.TSRG;
        }
        for (IMappingFile.Format format : formatArray) {
            String ext = format.name().toLowerCase(Locale.ENGLISH);
            Path target = output.resolve(prefix + "_n_to_o." + ext);
            if (force || !Files.isRegularFile(target, new LinkOption[0])) {
                log.info("  " + target.getFileName());
                try {
                    mapping.write(target, format, false);
                }
                catch (IOException e) {
                    log.info("  " + target.getFileName() + " Failed: " + e.getMessage());
                }
            }
            target = output.resolve(prefix + "_o_to_n." + ext);
            if (!force && Files.isRegularFile(target, new LinkOption[0])) continue;
            log.info("  " + target.getFileName());
            try {
                mapping.write(target, format, true);
            }
            catch (IOException e) {
                log.info("  " + target.getFileName() + " Failed: " + e.getMessage());
            }
        }
    }

    private static void makeJoinedJar(Path output, MinecraftVersion version, IMappingFile mappings, boolean annotate, boolean force) {
        Path target = output.resolve(annotate ? "joined_a.jar" : "joined.jar");
        if (!force && Files.isRegularFile(target, new LinkOption[0])) {
            return;
        }
        log.info("  " + target.getFileName());
        AnnotationVersion ann = annotate ? AnnotationVersion.fromVersion((String)version.toString()) : null;
        Path client = output.resolve("client.jar");
        Path server = output.resolve("server.jar");
        if (!Files.isRegularFile(client, new LinkOption[0]) || !Files.isRegularFile(server, new LinkOption[0])) {
            return;
        }
        try {
            Merger merger = new Merger(client.toFile(), server.toFile(), target.toFile());
            mappings.getClasses().forEach(e -> merger.whitelist(e.getMapped()));
            if (ann != null) {
                merger.annotate(ann, true);
            }
            merger.keepData();
            merger.skipMeta();
            merger.process();
        }
        catch (IOException e2) {
            log.info("    Could not make joined jar for: " + version + " " + e2.getMessage());
            e2.printStackTrace();
        }
        System.gc();
    }

    private static List<Path> downloadLauncherFiles(Path output, Path minecraft, MinecraftVersion version, VersionJson json) {
        Path[][] copy;
        String ver = version.toString();
        for (Path[] files : copy = new Path[][]{{output.resolve(DownloadType.CLIENT.getFilename()), minecraft.resolve("versions/" + ver + "/" + ver + ".jar")}, {output.resolve("version.json"), minecraft.resolve("versions/" + ver + "/" + ver + ".json")}}) {
            try {
                String shaM;
                String shaO = HashFunction.SHA1.hash(files[0]);
                String string = shaM = Files.isRegularFile(files[1], new LinkOption[0]) ? HashFunction.SHA1.hash(files[1]) : null;
                if (shaO.equals(shaM)) continue;
                log.info("  Copy " + files[0].getFileName() + " -> " + files[1].getFileName());
                Files.createDirectories(files[1].getParent(), new FileAttribute[0]);
                if (Files.isRegularFile(files[1], new LinkOption[0])) {
                    Files.delete(files[1]);
                }
                Files.copy(files[0], files[1], new CopyOption[0]);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "    Failed: " + e.getMessage(), e);
            }
        }
        Path libs = minecraft.resolve("libraries");
        ArrayList<Path> paths = new ArrayList<Path>();
        List<VersionJson.DownloadInfo> downloads = json.getLibraries();
        for (VersionJson.DownloadInfo dl : downloads) {
            Path target = libs.resolve(dl.path);
            paths.add(target);
            if (Files.isRegularFile(target, new LinkOption[0])) continue;
            try {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Utils.downloadFile(target, Utils.makeURL(dl.url), "  ");
            }
            catch (IOException e) {
                log.log(Level.WARNING, "  Could not download library: " + dl.path, e);
            }
        }
        return paths;
    }
}

