/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.mappingtoy;

import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.srgutils.MinecraftVersion;

public class ManifestJson {
    public static final String MOJANG_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    public Map<String, String> latest;
    public List<Entry> versions;
    private Map<MinecraftVersion, Entry> entry_map;

    public Map<MinecraftVersion, Entry> getEntries() {
        if (this.entry_map == null && this.versions != null) {
            this.entry_map = new HashMap<MinecraftVersion, Entry>();
            for (Entry e : this.versions) {
                if (!"release".equals(e.type) && !"snapshot".equals(e.type)) continue;
                this.entry_map.put(MinecraftVersion.from((String)e.id), e);
            }
        }
        return this.entry_map;
    }

    public Entry getVersion(MinecraftVersion version) {
        return this.getEntries().get(version);
    }

    public static class Entry {
        public String id;
        public String type;
        public Date time;
        public Date releaseTime;
        public URL url;
    }
}

