/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.mappingtoy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.lex.mappingtoy.MappingToy;
import net.minecraftforge.lex.mappingtoy.Utils;
import net.minecraftforge.srgutils.IMappingFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class JarRenamer {
    public static void makeMappedJar(Path root, String mapping, String prefix, boolean force) {
        Path source = root.resolve(prefix + ".jar");
        Path target = root.resolve(prefix + "_n.jar");
        Path srg = root.resolve(mapping);
        if (!force && Files.isRegularFile(target, new LinkOption[0])) {
            return;
        }
        if (!Files.isRegularFile(source, new LinkOption[0]) || !Files.isRegularFile(srg, new LinkOption[0])) {
            return;
        }
        try {
            MappingToy.log.info("  " + target.getFileName());
            try (ZipInputStream jin = new ZipInputStream(Files.newInputStream(source, new OpenOption[0]));
                 ZipOutputStream jout = new ZipOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
                IMappingFile map = IMappingFile.load(srg.toFile());
                SimpleRemapper remapper = new SimpleRemapper(map);
                HashSet<String> dirs = new HashSet<String>();
                ZipEntry entry = null;
                while ((entry = jin.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (entry.isDirectory()) {
                        if (dirs.contains(name)) continue;
                        jout.putNextEntry(Utils.getStableEntry(name));
                        dirs.add(name);
                        continue;
                    }
                    if (name.endsWith("MANIFEST.MF")) {
                        BufferedReader buf = new BufferedReader(new InputStreamReader(jin));
                        ByteArrayOutputStream bao = new ByteArrayOutputStream();
                        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(bao));
                        String line = null;
                        boolean lastSpace = false;
                        while ((line = buf.readLine()) != null) {
                            if (line.isEmpty()) {
                                if (lastSpace) continue;
                                out.write("\r\n");
                                lastSpace = true;
                                continue;
                            }
                            if (line.startsWith("Name:")) {
                                buf.readLine();
                                buf.readLine();
                                continue;
                            }
                            out.write(line);
                            out.write("\r\n");
                            lastSpace = false;
                        }
                        out.flush();
                        JarRenamer.startEntry(jout, name, dirs);
                        jout.write(bao.toByteArray());
                        continue;
                    }
                    if (name.endsWith(".class")) {
                        byte[] data = Utils.readStreamFully(jin);
                        ClassReader reader = new ClassReader(data);
                        ClassWriter writer = new ClassWriter(0);
                        ClassRemapper visitor = new ClassRemapper(writer, remapper);
                        reader.accept(visitor, 0);
                        JarRenamer.startEntry(jout, map.remapClass(name.substring(0, name.length() - 6)) + ".class", dirs);
                        jout.write(writer.toByteArray());
                        continue;
                    }
                    JarRenamer.startEntry(jout, name, dirs);
                    Utils.copy(jin, jout);
                }
            }
        }
        catch (IOException e) {
            MappingToy.log.log(Level.WARNING, "    Failed: " + e.getMessage(), e);
        }
    }

    private static void startEntry(ZipOutputStream jout, String filePath, Set<String> dirs) throws IOException {
        String dir;
        int i = filePath.lastIndexOf(47, filePath.length() - 2);
        if (i != -1 && !dirs.contains(dir = filePath.substring(0, i + 1))) {
            JarRenamer.startEntry(jout, dir, dirs);
            dirs.add(dir);
        }
        jout.putNextEntry(Utils.getStableEntry(filePath));
    }

    private static class SimpleRemapper
    extends Remapper {
        private IMappingFile map;

        private SimpleRemapper(IMappingFile map) {
            this.map = map;
        }

        @Override
        public String mapMethodName(String owner, String name, String descriptor) {
            IMappingFile.IClass cls = this.map.getClass(owner);
            return cls == null ? name : cls.remapMethod(name, descriptor);
        }

        @Override
        public String mapFieldName(String owner, String name, String descriptor) {
            IMappingFile.IClass cls = this.map.getClass(owner);
            return cls == null ? name : cls.remapField(name);
        }

        @Override
        public String mapPackageName(String name) {
            return this.map.remapPackage(name);
        }

        @Override
        public String map(String internalName) {
            return this.map.remapClass(internalName);
        }
    }
}

