/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.mappingtoy;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraftforge.lex.mappingtoy.MappingToy;
import net.minecraftforge.lex.mappingtoy.Utils;
import net.minecraftforge.srgutils.IMappingFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class JarMetadata {
    private static boolean DEBUG = Boolean.parseBoolean(System.getProperty("toy.debugLambdas", "false"));
    private static final Handle LAMBDA_METAFACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
    private static final Handle LAMBDA_ALTMETAFACTORY = new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false);

    public static void makeMetadata(Path output, Collection<Path> libraries, IMappingFile n2o, String type, boolean obfed, boolean force) {
        Path target = output.resolve(type + "_meta.json");
        if (!force && Files.isRegularFile(target, new LinkOption[0])) {
            return;
        }
        MappingToy.log.info("  " + target.getFileName());
        IMappingFile o2n = n2o.reverse();
        Tree tree = new Tree();
        Set<String> classes = tree.load(output.resolve(type + ".jar"), false);
        for (Path path : libraries) {
            tree.load(path, true);
        }
        for (String string : classes) {
            JarMetadata.resolve(tree, string, obfed, o2n, n2o);
        }
        for (String string : classes) {
            JarMetadata.resolveTransitive(tree, tree.getInfo(string));
        }
        TreeMap<String, ClassInfo> data = new TreeMap<String, ClassInfo>();
        for (String cls : classes) {
            data.put(cls, tree.getInfo(cls));
        }
        try {
            Utils.writeJson(target, data);
        }
        catch (IOException iOException) {
            MappingToy.log.log(Level.SEVERE, "    Failed to save meta: " + iOException.toString());
        }
    }

    private static void resolve(Tree tree, String cls, boolean obfed, IMappingFile o2n, IMappingFile n2o) {
        ClassInfo info = tree.getInfo(cls);
        if (info == null || info.resolved) {
            return;
        }
        if (info.getSuper() != null) {
            JarMetadata.resolve(tree, info.getSuper(), obfed, o2n, n2o);
        }
        if (info.interfaces != null) {
            for (String intf : info.interfaces) {
                JarMetadata.resolve(tree, intf, obfed, o2n, n2o);
            }
        }
        if (info.isEnum()) {
            IMappingFile.IClass mcls;
            IMappingFile.IClass iClass = mcls = obfed ? o2n.getClass(cls) : n2o.getClass(cls);
            if (info.fields != null) {
                int FLAG = 16409;
                for (ClassInfo.FieldInfo fld : info.fields.values()) {
                    Object official = obfed ? (mcls == null ? null : mcls.remapField(fld.name)) : fld.name;
                    if (official == null || (fld.getAccess() & 0x4019) != 16409 && !"$VALUES".equals(official)) continue;
                    fld.forceName((String)official);
                }
            }
            if (info.methods != null) {
                for (ClassInfo.MethodInfo mtd : info.methods.values()) {
                    String official;
                    Object object = obfed ? (mcls == null ? null : mcls.remapMethod(mtd.getName(), mtd.getDesc())) : (official = mtd.getName());
                    if ("values".equals(official) && mtd.getDesc().equals("()[L" + info.name + ';')) {
                        mtd.forceName("values");
                        continue;
                    }
                    if (!"valueOf".equals(official) || !mtd.getDesc().equals("(Ljava/lang/String;)L" + info.name + ';')) continue;
                    mtd.forceName("valueOf");
                }
            }
        }
        if (info.methods != null) {
            for (ClassInfo.MethodInfo mtd : info.methods.values()) {
                Method owner;
                if (mtd.bouncer == null || (owner = JarMetadata.walkBouncers(tree, mtd, info.name)) == null || owner.owner.equals(info.name)) continue;
                mtd.bouncer.setOwner(owner);
            }
            for (ClassInfo.MethodInfo mtd : info.methods.values()) {
                mtd.setOverrides(JarMetadata.findOverrides(tree, mtd, info.name, new TreeSet<Method>()));
                mtd.setParent(JarMetadata.findFirstParent(tree, mtd, info.name));
            }
        }
        if (!info.isAbstract()) {
            JarMetadata.resolveAbstract(tree, info);
        }
        info.resolved = true;
    }

    private static Method walkBouncers(Tree tree, ClassInfo.MethodInfo mtd, String owner) {
        Method ret;
        ClassInfo.MethodInfo mine;
        ClassInfo info = tree.getInfo(owner);
        if (info == null) {
            return null;
        }
        if (info.methods != null && (mine = (ClassInfo.MethodInfo)info.methods.get(mtd.getName() + mtd.getDesc())) != null && ((mine.getAccess() & 0x12) == 0 || owner.equals(mtd.getOwnerName()))) {
            if (mine.bouncer == null) {
                Set<Method> owners = JarMetadata.findOverrides(tree, mine, owner, new HashSet<Method>());
                if (owners.isEmpty()) {
                    return new Method(owner, mine.getName(), mine.getDesc());
                }
                if (owners.size() == 1) {
                    return owners.iterator().next();
                }
                return owners.iterator().next();
            }
            for (ClassInfo.MethodInfo m2 : info.methods.values()) {
                Method target = m2.bouncer == null ? null : m2.bouncer.target;
                if (target == null || !mine.getName().equals(target.name) || !mine.getDesc().equals(target.desc)) continue;
                if (m2.bouncer.owner != null) {
                    return m2.bouncer.owner;
                }
                Method ret2 = JarMetadata.walkBouncers(tree, m2, owner);
                if (ret2 != null && !ret2.owner.equals(owner)) {
                    m2.bouncer.setOwner(ret2);
                    return ret2;
                }
                MappingToy.log.warning("    Unable to walk: " + m2.getName() + ' ' + m2.getDesc() + " for " + owner + '/' + mine.getName() + ' ' + mine.getDesc());
            }
        }
        if (info.getSuper() != null && (ret = JarMetadata.walkBouncers(tree, mtd, info.getSuper())) != null) {
            return ret;
        }
        if (info.interfaces != null) {
            for (String intf : info.interfaces) {
                Method ret3 = JarMetadata.walkBouncers(tree, mtd, intf);
                if (ret3 == null) continue;
                return ret3;
            }
        }
        return null;
    }

    private static Set<Method> findOverrides(Tree tree, ClassInfo.MethodInfo mtd, String owner, Set<Method> overrides) {
        if (mtd.isStatic() || mtd.isPrivate() || mtd.getName().startsWith("<")) {
            return overrides;
        }
        ClassInfo info = tree.getInfo(owner);
        if (info == null) {
            return overrides;
        }
        if (info.methods != null) {
            for (ClassInfo.MethodInfo m : info.methods.values()) {
                Method target = m.bouncer == null ? null : m.bouncer.target;
                if (target == null || !mtd.getName().equals(target.name) || !mtd.getDesc().equals(target.desc)) continue;
                JarMetadata.findOverrides(tree, m, info.name, overrides);
            }
            ClassInfo.MethodInfo mine = (ClassInfo.MethodInfo)info.methods.get(mtd.getName() + mtd.getDesc());
            if (mine != null && mine != mtd && (mine.getAccess() & 0x12) == 0) {
                if (mine.getOverrides().isEmpty()) {
                    overrides.add(new Method(info.name, mine.getName(), mine.getDesc()));
                } else {
                    overrides.addAll(mine.getOverrides());
                }
            }
        }
        if (info.getSuper() != null) {
            JarMetadata.findOverrides(tree, mtd, info.getSuper(), overrides);
        }
        if (info.interfaces != null) {
            for (String intf : info.interfaces) {
                JarMetadata.findOverrides(tree, mtd, intf, overrides);
            }
        }
        return overrides;
    }

    private static Method findFirstParent(Tree tree, ClassInfo.MethodInfo mtd, String owner) {
        Method ret;
        if (mtd.isStatic() || mtd.isPrivate() || mtd.getName().startsWith("<")) {
            return null;
        }
        ClassInfo info = tree.getInfo(owner);
        if (info == null) {
            return null;
        }
        if (info.methods != null) {
            ClassInfo.MethodInfo mine = (ClassInfo.MethodInfo)info.methods.get(mtd.getName() + mtd.getDesc());
            if (info.isLocal() && mine != null && mine != mtd && (mine.getAccess() & 0x12) == 0) {
                return new Method(info.name, mine.getName(), mine.getDesc());
            }
            for (ClassInfo.MethodInfo m : info.methods.values()) {
                Method ret2;
                Method target = m.bouncer == null ? null : m.bouncer.target;
                if (target == null || !mtd.getName().equals(target.name) || !mtd.getDesc().equals(target.desc) || (ret2 = JarMetadata.findFirstParent(tree, m, info.name)) == null) continue;
                return ret2;
            }
        }
        if (info.getSuper() != null && (ret = JarMetadata.findFirstParent(tree, mtd, info.getSuper())) != null) {
            return ret;
        }
        if (info.interfaces != null) {
            for (String intf : info.interfaces) {
                Method ret3 = JarMetadata.findFirstParent(tree, mtd, intf);
                if (ret3 == null) continue;
                return ret3;
            }
        }
        return null;
    }

    private static void resolveAbstract(Tree tree, ClassInfo cls) {
        ClassInfo info;
        HashMap<String, String> abs = new HashMap<String, String>();
        TreeSet known = new TreeSet();
        LinkedList que = new LinkedList();
        Consumer<String> add = c -> {
            if (!known.contains(c)) {
                que.add(c);
                known.add(c);
            }
        };
        add.accept(cls.name);
        while (!que.isEmpty()) {
            info = tree.getInfo((String)que.poll());
            if (info == null) continue;
            if (info.methods != null) {
                info.methods.values().stream().filter(IAccessible::isAbstract).filter(mtd -> ((ClassInfo.MethodInfo)mtd).overrides == null).forEach(mtd -> abs.put(mtd.getName() + mtd.getDesc(), info.name));
            }
            if (info.getSuper() != null) {
                add.accept(info.getSuper());
            }
            if (info.interfaces == null) continue;
            info.interfaces.forEach(add);
        }
        known.clear();
        add.accept(cls.name);
        while (!que.isEmpty()) {
            info = tree.getInfo((String)que.poll());
            if (info == null) continue;
            if (info.methods != null) {
                for (ClassInfo.MethodInfo mtd2 : info.methods.values()) {
                    String towner;
                    if (mtd2.isAbstract() || (towner = (String)abs.remove(mtd2.getName() + mtd2.getDesc())) == null) continue;
                    Method target = new Method(towner, mtd2.getName(), mtd2.getDesc());
                    if (mtd2.overrides != null) {
                        mtd2.overrides.add(target);
                        continue;
                    }
                    mtd2.setOverrides(new HashSet<Method>(Arrays.asList(target)));
                }
            }
            if (info.getSuper() != null) {
                add.accept(info.getSuper());
            }
            if (info.interfaces == null) continue;
            info.interfaces.forEach(add);
        }
        if (!abs.isEmpty()) {
            MappingToy.log.log(Level.SEVERE, "    Unresolved abstracts for: " + cls.name);
            abs.forEach((mtd, c) -> MappingToy.log.log(Level.SEVERE, "      " + c + "/" + mtd));
        }
    }

    private static void resolveTransitive(Tree tree, ClassInfo cls) {
        if (!cls.isInterface() || cls.methods == null) {
            return;
        }
        HashSet<ClassInfo> children = new HashSet<ClassInfo>();
        for (ClassInfo info : tree.classes.values()) {
            if (info == cls || !tree.instanceOf(info, cls)) continue;
            children.add(info);
        }
        block1: for (ClassInfo.MethodInfo myMtd : cls.methods.values()) {
            HashSet<ClassInfo.MethodInfo> overrides = new HashSet<ClassInfo.MethodInfo>();
            for (ClassInfo child : children) {
                LinkedList<ClassInfo> que = new LinkedList<ClassInfo>(Arrays.asList(child));
                HashSet<String> seen = new HashSet<String>(Arrays.asList(child.name));
                while (!que.isEmpty()) {
                    ClassInfo c = (ClassInfo)que.poll();
                    if (c.getSuper() != null && !seen.contains(c.getSuper())) {
                        que.add(tree.getInfo(c.getSuper()));
                        seen.add(c.getSuper());
                    }
                    if (c.interfaces != null) {
                        for (String inf : c.interfaces) {
                            if (seen.contains(inf)) continue;
                            que.add(tree.getInfo(inf));
                            seen.add(inf);
                        }
                    }
                    if (c.methods == null) continue;
                    for (ClassInfo.MethodInfo mtd : c.methods.values()) {
                        if (mtd.isStatic() || mtd.isPrivate() || mtd.getName().startsWith("<") || !mtd.getName().equals(myMtd.getName()) || !mtd.getDesc().equals(myMtd.getDesc())) continue;
                        overrides.add(mtd);
                    }
                }
            }
            if (overrides.isEmpty()) continue;
            for (ClassInfo.MethodInfo override : overrides) {
                if (override.getOwner().isLocal()) continue;
                overrides.forEach(m -> {
                    if (m.getOwner() != cls) {
                        TreeSet<Method> ovs = new TreeSet<Method>(m.getOverrides());
                        ovs.add(myMtd.getMethod());
                        m.setOverrides(ovs);
                    }
                    m.forceName(override.getName());
                });
                continue block1;
            }
        }
    }

    private static class Bounce {
        private final Method target;
        private Method owner;

        private Bounce(Method target) {
            this.target = target;
        }

        public void setOwner(Method value) {
            this.owner = value;
        }

        public String toString() {
            return this.target + " -> " + this.owner;
        }
    }

    private static class Method
    implements Comparable<Method> {
        private final String owner;
        private final String name;
        private final String desc;

        private Method(String owner, String name, String desc) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public String toString() {
            return this.owner + '/' + this.name + this.desc;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Method && o.toString().equals(this.toString());
        }

        private int compare(int a, int b) {
            return a != 0 ? a : b;
        }

        @Override
        public int compareTo(Method o) {
            return this.compare(this.owner.compareTo(o.owner), this.compare(this.name.compareTo(o.name), this.desc.compareTo(o.desc)));
        }
    }

    public static class ClassInfo
    implements IAccessible {
        private final transient String name;
        private final transient boolean local;
        private final String superName;
        private final List<String> interfaces;
        private final Integer access;
        private final String signature;
        private final Map<String, FieldInfo> fields;
        private final Map<String, MethodInfo> methods;
        private transient boolean resolved = false;

        private ClassInfo(ClassNode node, boolean local) {
            this.local = local;
            this.name = node.name;
            this.superName = "java/lang/Object".equals(node.superName) ? null : node.superName;
            this.interfaces = node.interfaces != null && !node.interfaces.isEmpty() ? new ArrayList<String>(node.interfaces) : null;
            this.access = node.access == 0 ? null : Integer.valueOf(node.access);
            this.signature = node.signature;
            if (node.fields == null || node.fields.isEmpty()) {
                this.fields = null;
            } else {
                this.fields = new TreeMap<String, FieldInfo>();
                node.fields.stream().forEach(fld -> this.fields.put(fld.name, new FieldInfo((FieldNode)fld)));
            }
            if (node.methods == null || node.methods.isEmpty()) {
                this.methods = null;
            } else {
                HashSet<String> lambdas = new HashSet<String>();
                for (MethodNode mtd : node.methods) {
                    for (AbstractInsnNode asn : () -> mtd.instructions.iterator()) {
                        Handle target;
                        if (!(asn instanceof InvokeDynamicInsnNode) || (target = this.getLambdaTarget((InvokeDynamicInsnNode)asn)) == null) continue;
                        lambdas.add(target.getOwner() + '/' + target.getName() + target.getDesc());
                    }
                }
                this.methods = new TreeMap<String, MethodInfo>();
                for (MethodNode mtd : node.methods) {
                    String key = mtd.name + mtd.desc;
                    this.methods.put(key, new MethodInfo(mtd, lambdas.contains(this.name + '/' + key)));
                    if (!DEBUG || !mtd.name.startsWith("lambda$") || lambdas.contains(this.name + '/' + key)) continue;
                    MappingToy.log.log(Level.INFO, "Bad lambda: " + node.name + '/' + mtd.name + ' ' + mtd.desc);
                    MappingToy.log.log(Level.INFO, Utils.toString(mtd.instructions));
                }
            }
        }

        private Handle getLambdaTarget(InvokeDynamicInsnNode idn) {
            if (LAMBDA_METAFACTORY.equals(idn.bsm) && idn.bsmArgs != null && idn.bsmArgs.length == 3 && idn.bsmArgs[1] instanceof Handle) {
                return (Handle)idn.bsmArgs[1];
            }
            if (LAMBDA_ALTMETAFACTORY.equals(idn.bsm) && idn.bsmArgs != null && idn.bsmArgs.length == 5 && idn.bsmArgs[1] instanceof Handle) {
                return (Handle)idn.bsmArgs[1];
            }
            return null;
        }

        public boolean isLocal() {
            return this.local;
        }

        public String getSuper() {
            return this.superName == null && !"java/lang/Object".equals(this.name) ? "java/lang/Object" : this.superName;
        }

        @Override
        public int getAccess() {
            return this.access == null ? 0 : this.access;
        }

        public String toString() {
            return Utils.getAccess(this.getAccess()) + ' ' + this.name;
        }

        public class MethodInfo
        implements IAccessible {
            private final transient boolean isLambda;
            private final transient Method method;
            private final Integer access;
            private final String signature;
            private final Bounce bouncer;
            private String force;
            private Set<Method> overrides;
            private Method parent;

            private MethodInfo(MethodNode node, boolean lambda) {
                this.method = new Method(ClassInfo.this.name, node.name, node.desc);
                this.access = node.access == 0 ? null : Integer.valueOf(node.access);
                this.signature = node.signature;
                this.isLambda = lambda;
                Bounce bounce = null;
                if (!lambda && (node.access & 0x1040) != 0 && (node.access & 8) == 0) {
                    AbstractInsnNode start = node.instructions.getFirst();
                    if (start instanceof LabelNode && start.getNext() instanceof LineNumberNode) {
                        start = start.getNext().getNext();
                    }
                    if (start instanceof VarInsnNode) {
                        VarInsnNode n = (VarInsnNode)start;
                        if (n.var == 0 && n.getOpcode() == 25) {
                            AbstractInsnNode end = node.instructions.getLast();
                            if (end instanceof LabelNode) {
                                end = end.getPrevious();
                            }
                            if (end.getOpcode() >= 172 && end.getOpcode() <= 177) {
                                end = end.getPrevious();
                            }
                            if (end instanceof MethodInsnNode) {
                                Type[] args = Type.getArgumentTypes(node.desc);
                                int var = 1;
                                int index = 0;
                                for (start = start.getNext(); start != end; start = start.getNext()) {
                                    if (start instanceof VarInsnNode) {
                                        if (((VarInsnNode)start).var != var || index + 1 > args.length) {
                                            end = null;
                                            break;
                                        }
                                        var += args[index++].getSize();
                                        continue;
                                    }
                                    if (start.getOpcode() == 193 || start.getOpcode() == 192) continue;
                                    end = null;
                                    break;
                                }
                                MethodInsnNode mtd = (MethodInsnNode)end;
                                if (end != null && mtd.owner.equals(ClassInfo.this.name) && Type.getArgumentsAndReturnSizes(node.desc) == Type.getArgumentsAndReturnSizes(mtd.desc)) {
                                    bounce = new Bounce(new Method(mtd.owner, mtd.name, mtd.desc));
                                }
                            }
                        }
                    }
                }
                this.bouncer = bounce;
            }

            @Override
            public int getAccess() {
                return this.access == null ? 0 : this.access;
            }

            public void forceName(String value) {
                this.force = value;
            }

            public void setOverrides(Set<Method> value) {
                this.overrides = value.isEmpty() ? null : value;
            }

            public Set<Method> getOverrides() {
                return this.overrides == null ? Collections.emptySet() : this.overrides;
            }

            public Method getParent() {
                return this.parent;
            }

            public void setParent(Method value) {
                this.parent = value;
            }

            public ClassInfo getOwner() {
                return ClassInfo.this;
            }

            public String getOwnerName() {
                return ClassInfo.this.name;
            }

            public Method getMethod() {
                return this.method;
            }

            public String getName() {
                return this.method.getName();
            }

            public String getDesc() {
                return this.method.getDesc();
            }

            public String toString() {
                return Utils.getAccess(this.getAccess()) + ' ' + this.method.toString();
            }
        }

        public class FieldInfo
        implements IAccessible {
            private final transient String name;
            private final String desc;
            private final Integer access;
            private final String signature;
            private String force;

            private FieldInfo(FieldNode node) {
                this.name = node.name;
                this.desc = node.desc;
                this.access = node.access == 0 ? null : Integer.valueOf(node.access);
                this.signature = node.signature;
            }

            public void forceName(String name) {
                this.force = name;
            }

            @Override
            public int getAccess() {
                return this.access == null ? 0 : this.access;
            }

            public String toString() {
                return Utils.getAccess(this.getAccess()) + ' ' + this.desc + ' ' + this.name;
            }
        }
    }

    private static interface IAccessible {
        public int getAccess();

        default public boolean isInterface() {
            return (this.getAccess() & 0x200) != 0;
        }

        default public boolean isAbstract() {
            return (this.getAccess() & 0x400) != 0;
        }

        default public boolean isSynthetic() {
            return (this.getAccess() & 0x1000) != 0;
        }

        default public boolean isAnnotation() {
            return (this.getAccess() & 0x2000) != 0;
        }

        default public boolean isEnum() {
            return (this.getAccess() & 0x4000) != 0;
        }

        default public boolean isPackagePrivate() {
            return (this.getAccess() & 7) == 0;
        }

        default public boolean isPublic() {
            return (this.getAccess() & 1) != 0;
        }

        default public boolean isPrivate() {
            return (this.getAccess() & 2) != 0;
        }

        default public boolean isProtected() {
            return (this.getAccess() & 4) != 0;
        }

        default public boolean isStatic() {
            return (this.getAccess() & 8) != 0;
        }

        default public boolean isFinal() {
            return (this.getAccess() & 0x10) != 0;
        }
    }

    private static class Tree {
        private Map<String, ClassInfo> classes = new HashMap<String, ClassInfo>();
        private Set<String> negative = new HashSet<String>();
        private Map<String, byte[]> sources = new HashMap<String, byte[]>();
        private Set<String> local = new HashSet<String>();

        private Tree() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Set<String> load(Path path, boolean library) {
            try (ZipInputStream jin = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));){
                TreeSet<String> classes = new TreeSet<String>();
                ZipEntry entry = null;
                while ((entry = jin.getNextEntry()) != null) {
                    String cls;
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.endsWith(".class") || this.sources.containsKey(cls = name.substring(0, name.length() - 6))) continue;
                    byte[] data = Utils.readStreamFully(jin);
                    this.sources.put(cls, data);
                    classes.add(cls);
                    if (library) continue;
                    this.local.add(cls);
                }
                TreeSet<String> treeSet = classes;
                return treeSet;
            }
            catch (IOException e) {
                MappingToy.log.log(Level.SEVERE, "Failed to load: " + path.toString(), e);
                return Collections.emptySet();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ClassInfo getInfo(String cls) {
            if (this.negative.contains(cls)) {
                return null;
            }
            ClassInfo ret = this.classes.get(cls);
            if (ret != null) return ret;
            byte[] data = this.sources.remove(cls);
            if (data == null) {
                try (InputStream in = JarMetadata.class.getClassLoader().getResourceAsStream(cls + ".class");){
                    if (in == null) {
                        MappingToy.log.info("    Failed to find class: " + cls);
                        this.negative.add(cls);
                        ClassInfo classInfo = null;
                        return classInfo;
                    }
                    data = Utils.readStreamFully(in);
                }
                catch (Throwable e) {
                    MappingToy.log.info("    Failed to find class: " + cls);
                    this.negative.add(cls);
                    return null;
                }
            }
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(data);
            classReader.accept(classNode, 0);
            ret = new ClassInfo(classNode, this.local.contains(cls));
            this.classes.put(cls, ret);
            return ret;
        }

        public boolean instanceOf(ClassInfo child, ClassInfo target) {
            LinkedList<ClassInfo> que = new LinkedList<ClassInfo>();
            HashSet<String> seen = new HashSet<String>();
            que.add(child);
            seen.add(child.name);
            while (!que.isEmpty()) {
                ClassInfo info = (ClassInfo)que.poll();
                if (info == target) {
                    return true;
                }
                String sup = info.getSuper();
                if (sup != null && !seen.contains(sup)) {
                    que.add(this.getInfo(sup));
                    seen.add(sup);
                }
                if (info.interfaces == null) continue;
                for (String inf : info.interfaces) {
                    if (seen.contains(inf)) continue;
                    que.add(this.getInfo(inf));
                    seen.add(inf);
                }
            }
            return false;
        }
    }
}

