/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.mappingtoy;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateTypeAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private static final DateFormat US_FORMAT = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private static final DateFormat ISO8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonPrimitive() || !((JsonPrimitive)json).isString()) {
            throw new JsonParseException("Date needs to be a string: " + json.getAsString());
        }
        if (typeOfT != Date.class) {
            throw new JsonParseException(this.getClass() + " can only deserialze to Date, not " + typeOfT.getTypeName());
        }
        String data = json.getAsString();
        try {
            return US_FORMAT.parse(data);
        }
        catch (ParseException parseException) {
            try {
                return ISO8601_FORMAT.parse(data);
            }
            catch (ParseException parseException2) {
                try {
                    String tmp = data.replaceAll("Z", "+00:00");
                    tmp = tmp.substring(0, 22) + tmp.substring(23);
                    return ISO8601_FORMAT.parse(tmp);
                }
                catch (ParseException e) {
                    throw new JsonSyntaxException("Invalid date: " + data, e);
                }
            }
        }
    }

    @Override
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        String ret = ISO8601_FORMAT.format(src);
        return new JsonPrimitive(ret.substring(0, 22) + ':' + ret.substring(22));
    }
}

