/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.cfd;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.lex.cfd.CobbleForDays;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="cobblefordays", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataCreator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            gen.m_123914_((DataProvider)new Recipes(gen));
            gen.m_123914_((DataProvider)new Loots(gen));
        }
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new Language(gen));
            gen.m_123914_((DataProvider)new BlockStates(gen, helper));
            gen.m_123914_((DataProvider)new ItemModels(gen, helper));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void m_176531_(Consumer<FinishedRecipe> consumer) {
            this.getTier((ItemLike)CobbleForDays.TIER1_BLOCK.get(), (TagKey<Item>)ItemTags.f_13182_).m_176498_(consumer);
            this.getTier((ItemLike)CobbleForDays.TIER2_BLOCK.get(), (TagKey<Item>)Tags.Items.COBBLESTONE).m_176498_(consumer);
            this.getTier((ItemLike)CobbleForDays.TIER3_BLOCK.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON).m_176498_(consumer);
            this.getTier((ItemLike)CobbleForDays.TIER4_BLOCK.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD).m_176498_(consumer);
            this.getTier((ItemLike)CobbleForDays.TIER5_BLOCK.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND).m_176498_(consumer);
        }

        private ShapedRecipeBuilder getTier(ItemLike item, TagKey<Item> resource) {
            return ShapedRecipeBuilder.m_126116_((ItemLike)item).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42447_).m_126127_(Character.valueOf('L'), (ItemLike)Items.f_42448_).m_126127_(Character.valueOf('G'), (ItemLike)Blocks.f_50058_).m_206416_(Character.valueOf('R'), resource).m_126130_("RRR").m_126130_("WGL").m_126130_("RRR").m_142284_("has_lava", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42448_)).m_142284_("has_water", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)Items.f_42447_));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationResults) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationResults, (ResourceLocation)name, (LootTable)table));
        }

        private class Blocks
        extends BlockLoot {
            private Blocks() {
            }

            protected void addTables() {
                this.m_124288_((Block)CobbleForDays.TIER1_BLOCK.get());
                this.m_124288_((Block)CobbleForDays.TIER2_BLOCK.get());
                this.m_124288_((Block)CobbleForDays.TIER3_BLOCK.get());
                this.m_124288_((Block)CobbleForDays.TIER4_BLOCK.get());
                this.m_124288_((Block)CobbleForDays.TIER5_BLOCK.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return CobbleForDays.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "cobblefordays", "en_us");
        }

        protected void addTranslations() {
            this.add((Block)CobbleForDays.TIER1_BLOCK.get(), "Cobble Gen Tier1");
            this.add((Block)CobbleForDays.TIER2_BLOCK.get(), "Cobble Gen Tier2");
            this.add((Block)CobbleForDays.TIER3_BLOCK.get(), "Cobble Gen Tier3");
            this.add((Block)CobbleForDays.TIER4_BLOCK.get(), "Cobble Gen Tier4");
            this.add((Block)CobbleForDays.TIER5_BLOCK.get(), "Cobble Gen Tier5");
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "cobblefordays", helper);
        }

        protected void registerStatesAndModels() {
            this.makeTier((Block)CobbleForDays.TIER1_BLOCK.get(), this.mcLoc("block/acacia_log"));
            this.makeTier((Block)CobbleForDays.TIER2_BLOCK.get(), this.mcLoc("block/cobblestone"));
            this.makeTier((Block)CobbleForDays.TIER3_BLOCK.get(), this.mcLoc("block/iron_block"));
            this.makeTier((Block)CobbleForDays.TIER4_BLOCK.get(), this.mcLoc("block/gold_block"));
            this.makeTier((Block)CobbleForDays.TIER5_BLOCK.get(), this.mcLoc("block/diamond_block"));
        }

        private void makeTier(Block block, ResourceLocation texture) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(block.getRegistryName().m_135815_())).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/generator")))).texture("material", texture);
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$makeTier$0((ModelFile)model, arg_0));
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeTier$0(ModelFile model, BlockState state) {
            return ConfiguredModel.builder().modelFile(model).build();
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "cobblefordays", helper);
        }

        protected void registerModels() {
            this.makeTier((Block)CobbleForDays.TIER1_BLOCK.get());
            this.makeTier((Block)CobbleForDays.TIER2_BLOCK.get());
            this.makeTier((Block)CobbleForDays.TIER3_BLOCK.get());
            this.makeTier((Block)CobbleForDays.TIER4_BLOCK.get());
            this.makeTier((Block)CobbleForDays.TIER5_BLOCK.get());
        }

        private void makeTier(Block block) {
            String path = block.getRegistryName().m_135815_();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        public String m_6055_() {
            return "Item Models";
        }
    }
}

