/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.cngbb;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.lex.cngbb.ChunkNoGoByeBye;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="chunknogobyebye", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataCreator {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new Recipes(gen));
            gen.func_200390_a((IDataProvider)new Loots(gen));
        }
        if (event.includeClient()) {
            gen.func_200390_a((IDataProvider)new Language(gen, "chunknogobyebye"));
        }
    }

    private static void save(DirectoryCache cache, Object object, Path target) throws IOException {
        String data = GSON.toJson(object);
        String hash = IDataProvider.field_208307_a.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.func_208323_a(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
            }
        }
        cache.func_208316_a(target, hash);
    }

    private static class Language
    implements IDataProvider {
        private final DataGenerator gen;
        private final String modid;
        private final Map<String, String> data = new TreeMap<String, String>();

        public Language(DataGenerator gen, String modid) {
            this.gen = gen;
            this.modid = modid;
        }

        private void addTranslations() {
            this.add((Block)ChunkNoGoByeBye.LOADER_BLOCK.get(), "Single Chunk Loader");
        }

        public String func_200397_b() {
            return "Languages";
        }

        public void func_200398_a(DirectoryCache cache) throws IOException {
            this.addTranslations();
            if (!this.data.isEmpty()) {
                DataCreator.save(cache, this.data, this.gen.func_200391_b().resolve("assets/" + this.modid + "/lang/en_us.json"));
            }
        }

        private void add(Block block, String name) {
            this.add(block.func_149739_a(), name);
        }

        private void add(String key, String value) {
            if (this.data.put(key, value) != null) {
                throw new IllegalStateException("Duplicate translation key " + key);
            }
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        public String func_200397_b() {
            return "LootTables";
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootParameterSets.field_216267_h));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker tracker) {
        }

        private class Blocks
        extends BlockLootTables {
            private Set<Block> knownBlocks = new HashSet<Block>();

            private Blocks() {
            }

            protected void addTables() {
                this.func_218492_c((Block)ChunkNoGoByeBye.LOADER_BLOCK.get());
            }

            public void func_218492_c(Block block) {
                this.knownBlocks.add(block);
                super.func_218492_c(block);
            }

            protected Iterable<Block> getKnownBlocks() {
                return this.knownBlocks;
            }
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)ChunkNoGoByeBye.LOADER_BLOCK.get()), (int)10).func_200462_a(Character.valueOf('O'), (IItemProvider)Items.field_151079_bi).func_200462_a(Character.valueOf('E'), (IItemProvider)Blocks.field_150381_bn).func_200472_a("OOO").func_200472_a("OEO").func_200472_a("OOO").func_200465_a("has_ender_pearl", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151079_bi)).func_200464_a(consumer);
        }
    }
}

