/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.cngbb;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.lex.cngbb.IChunkLoaderList;

public class ChunkLoaderList
implements IChunkLoaderList {
    private Long2IntMap refCount = new Long2IntOpenHashMap();
    private LongSet loaders = new LongOpenHashSet();
    private boolean loading = false;
    @Nullable
    private final ServerWorld world;

    public ChunkLoaderList(@Nullable ServerWorld world) {
        this.refCount.defaultReturnValue(Integer.MIN_VALUE);
        this.world = world;
    }

    @Override
    public void add(BlockPos pos) {
        long block = pos.func_218275_a();
        if (!this.loaders.contains(block)) {
            long chunk = this.toChunk(pos);
            int ref = this.refCount.get(chunk);
            if (ref == Integer.MIN_VALUE) {
                if (!this.loading) {
                    this.force(pos);
                }
                ref = 1;
            } else {
                ++ref;
            }
            this.refCount.put(chunk, ref);
            this.loaders.add(block);
        }
    }

    @Override
    public void remove(BlockPos pos) {
        if (this.loaders.remove(pos.func_218275_a())) {
            long chunk = this.toChunk(pos);
            int ref = this.refCount.get(chunk);
            if (ref == Integer.MIN_VALUE || --ref <= 0) {
                if (!this.loading) {
                    this.unforce(pos);
                }
                this.refCount.remove(chunk);
            } else {
                this.refCount.put(chunk, ref);
            }
        }
    }

    @Override
    public boolean contains(BlockPos pos) {
        return this.loaders.contains(pos.func_218275_a());
    }

    private final long toChunk(BlockPos pos) {
        return ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
    }

    private void force(BlockPos pos) {
        this.forceload(pos, "add");
    }

    private void unforce(BlockPos pos) {
        this.forceload(pos, "remove");
    }

    private void forceload(BlockPos pos, String action) {
        if (this.world == null || this.world.func_73046_m() == null) {
            return;
        }
        CommandSource source = this.world.func_73046_m().func_195573_aM().func_201003_a(this.world);
        int ret = this.world.func_73046_m().func_195571_aL().func_197059_a(source, "forceload " + action + " " + pos.func_177958_n() + " " + pos.func_177952_p());
    }

    public static class Storage
    implements Capability.IStorage<IChunkLoaderList> {
        public INBT writeNBT(Capability<IChunkLoaderList> capability, IChunkLoaderList instance, Direction side) {
            if (!(instance instanceof ChunkLoaderList)) {
                return null;
            }
            ChunkLoaderList list = (ChunkLoaderList)instance;
            long[] data = new long[list.loaders.size()];
            int idx = 0;
            LongIterator longIterator = list.loaders.iterator();
            while (longIterator.hasNext()) {
                long l = (Long)longIterator.next();
                data[idx++] = l;
            }
            return new LongArrayNBT(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readNBT(Capability<IChunkLoaderList> capability, IChunkLoaderList instance, Direction side, INBT nbt) {
            if (!(instance instanceof ChunkLoaderList) || !(nbt instanceof LongArrayNBT)) {
                return;
            }
            ChunkLoaderList list = (ChunkLoaderList)instance;
            list.loading = true;
            list.refCount.clear();
            list.loaders.clear();
            try {
                for (long l : ((LongArrayNBT)nbt).func_197652_h()) {
                    list.add(BlockPos.func_218283_e((long)l));
                }
                if (list.world != null) {
                    list.world.func_73046_m().func_212871_a_((Runnable)new TickDelayedTask(1, () -> {
                        LongIterator longIterator = list.refCount.keySet().iterator();
                        while (longIterator.hasNext()) {
                            long l = (Long)longIterator.next();
                            ChunkPos chunk = new ChunkPos(l);
                            list.force(new BlockPos(chunk.field_77276_a << 4, 0, chunk.field_77275_b << 4));
                        }
                    }));
                }
            }
            finally {
                list.loading = false;
            }
        }
    }
}

