/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.cngbb;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.lex.cngbb.ChunkLoaderList;
import net.minecraftforge.lex.cngbb.IChunkLoaderList;
import net.minecraftforge.lex.cngbb.LoaderBlock;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chunknogobyebye")
public class ChunkNoGoByeBye {
    public static final String MODID = "chunknogobyebye";
    public static final String LOADERID = "loader";
    private static final Logger LOGGER = LogManager.getLogger();
    private static List<Supplier<? extends Item>> ITEMS = new ArrayList<Supplier<? extends Item>>();
    private static List<Supplier<? extends Block>> BLOCKS = new ArrayList<Supplier<? extends Block>>();
    @CapabilityInject(value=IChunkLoaderList.class)
    public static Capability<IChunkLoaderList> CAPABILITY = null;
    @ObjectHolder(value="chunknogobyebye:loader")
    public static final Block LOADER_BLOCK = ChunkNoGoByeBye.registerBlock("loader", () -> new LoaderBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(3.5f)));
    @ObjectHolder(value="chunknogobyebye:loader")
    public static final Item LOADER_ITEM = ChunkNoGoByeBye.registerItem("loader", () -> new BlockItem(LOADER_BLOCK, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));

    public ChunkNoGoByeBye() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupClient);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setupClient(FMLClientSetupEvent event) {
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IChunkLoaderList.class, (Capability.IStorage)new ChunkLoaderList.Storage(), () -> new ChunkLoaderList(null));
    }

    @SubscribeEvent
    public void attachWorldCaps(AttachCapabilitiesEvent<World> event) {
        if (((World)event.getObject()).field_72995_K) {
            return;
        }
        final LazyOptional inst = LazyOptional.of(() -> new ChunkLoaderList((ServerWorld)event.getObject()));
        ICapabilitySerializable<INBT> provider = new ICapabilitySerializable<INBT>(){

            public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                return CAPABILITY.orEmpty(cap, inst);
            }

            public INBT serializeNBT() {
                return CAPABILITY.writeNBT(inst.orElse(null), null);
            }

            public void deserializeNBT(INBT nbt) {
                CAPABILITY.readNBT(inst.orElse(null), null, nbt);
            }
        };
        event.addCapability(new ResourceLocation(MODID, LOADERID), (ICapabilityProvider)provider);
        event.addListener(() -> inst.invalidate());
    }

    private static <T extends Item> T registerItem(String name, Supplier<T> sup) {
        ITEMS.add(() -> (Item)((Item)sup.get()).setRegistryName(MODID, name));
        return null;
    }

    private static <T extends Block> T registerBlock(String name, Supplier<T> sup) {
        BLOCKS.add(() -> (Block)((Block)sup.get()).setRegistryName(MODID, name));
        return null;
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        ITEMS.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        BLOCKS.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
    }
}

