/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraftforge.installertools.ConsoleTool;
import net.minecraftforge.installertools.ITask;

public class McpData
implements ITask {
    @Override
    public void process(String[] args) throws IOException {
        block83: {
            OptionParser parser = new OptionParser();
            ArgumentAcceptingOptionSpec inputO = parser.accepts("input").withRequiredArg().ofType(File.class).required();
            ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
            ArgumentAcceptingOptionSpec keyO = parser.accepts("key").withRequiredArg().ofType(String.class).required();
            try {
                OptionSet options = parser.parse(args);
                File input = (File)options.valueOf((OptionSpec)inputO);
                File output = (File)options.valueOf((OptionSpec)outputO);
                String key = (String)options.valueOf((OptionSpec)keyO);
                McpData.log("Input:  " + input);
                McpData.log("Output: " + output);
                McpData.log("Key:    " + key);
                if (output.exists() && !this.delete(output)) {
                    McpData.error("Could not delete output file: " + output);
                }
                if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
                    McpData.error("Could not make output folders: " + output.getParentFile());
                }
                if (!input.exists()) {
                    McpData.error("Input does not exist: " + input);
                }
                try (ZipFile zip = new ZipFile(input);){
                    ZipEntry config = zip.getEntry("config.json");
                    if (config == null) {
                        McpData.error("Input zip file invalid, missing 'config.json' entry");
                    }
                    try (InputStream cfgStream = zip.getInputStream(config);){
                        String name;
                        McpConfig cfg = (McpConfig)ConsoleTool.GSON.fromJson((Reader)new InputStreamReader(zip.getInputStream(config)), McpConfig.class);
                        if (cfg.data == null) {
                            McpData.error("Invalid mcp config, missing data map");
                        }
                        String[] pts = key.split("\\.");
                        Map level = cfg.data;
                        for (int x = 0; x < pts.length - 1; ++x) {
                            Object entry = level.get(pts[x]);
                            if (!(entry instanceof Map)) {
                                McpData.error("Config missing " + key + " data entry");
                            }
                            level = (Map)entry;
                        }
                        Object value = level.get(pts[pts.length - 1]);
                        if (!(value instanceof String)) {
                            McpData.error("Config missing " + key + " data entry");
                        }
                        if ((name = (String)value).endsWith("/")) {
                            if (!output.mkdirs()) {
                                McpData.error("Failed to create output directory: " + output);
                            }
                            Enumeration<? extends ZipEntry> entries = zip.entries();
                            while (entries.hasMoreElements()) {
                                ZipEntry entry = entries.nextElement();
                                if (!entry.getName().startsWith(name) || entry.isDirectory()) continue;
                                File target = new File(output, entry.getName().substring(name.length()));
                                if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                                    McpData.error("Failed to create output directory: " + output);
                                }
                                McpData.log("Extracting: " + entry.getName());
                                FileOutputStream _output = new FileOutputStream(target);
                                Throwable throwable = null;
                                try {
                                    InputStream _input = zip.getInputStream(entry);
                                    Throwable throwable2 = null;
                                    try {
                                        this.copy(_input, _output);
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    finally {
                                        if (_input == null) continue;
                                        if (throwable2 != null) {
                                            try {
                                                _input.close();
                                            }
                                            catch (Throwable throwable4) {
                                                throwable2.addSuppressed(throwable4);
                                            }
                                            continue;
                                        }
                                        _input.close();
                                    }
                                }
                                catch (Throwable throwable5) {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    if (_output == null) continue;
                                    if (throwable != null) {
                                        try {
                                            _output.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable.addSuppressed(throwable6);
                                        }
                                        continue;
                                    }
                                    _output.close();
                                }
                            }
                            break block83;
                        }
                        ZipEntry entry = zip.getEntry((String)value);
                        if (entry == null) {
                            McpData.error("Invalid zip, missing " + value + " entry");
                        }
                        McpData.log("Extracting: " + entry.getName());
                        try (FileOutputStream _output = new FileOutputStream(output);
                             InputStream _input = zip.getInputStream(entry);){
                            this.copy(_input, _output);
                        }
                    }
                }
            }
            catch (OptionException e) {
                parser.printHelpOn((OutputStream)System.out);
                e.printStackTrace();
            }
        }
    }

    private boolean delete(File path) throws IOException {
        if (path.isDirectory()) {
            return Files.walk(path.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).map(File::delete).anyMatch(v -> v == false);
        }
        return path.delete();
    }

    private void copy(InputStream source, OutputStream sink) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
        }
    }

    public static void error(String message) {
        McpData.log(message);
        throw new RuntimeException(message);
    }

    public static void log(String message) {
        System.out.println(message);
    }

    public static class McpConfig {
        public int spec;
        public Map<String, Object> data;
    }
}

