/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraftforge.installertools.Tasks;

public class ConsoleTool {
    public static final Gson GSON = new GsonBuilder().create();

    public static void main(String[] args) throws IOException {
        Enum task = null;
        String valid = Arrays.stream(Tasks.class.getEnumConstants()).map(Enum::name).collect(Collectors.joining(", "));
        ArrayList<String> extra = new ArrayList<String>();
        for (int x = 0; x < args.length; ++x) {
            if ("--task".equals(args[x])) {
                if (x == args.length - 1) {
                    ConsoleTool.error("--task must specify a value, known values: " + valid);
                }
                task = Tasks.valueOf(Tasks.class, args[x + 1].toUpperCase());
                ++x;
                continue;
            }
            if (args[x].startsWith("--task=")) {
                task = Tasks.valueOf(Tasks.class, args[x].substring(7));
                continue;
            }
            extra.add(args[x]);
        }
        if (task == null) {
            ConsoleTool.error("Must specify task using --task, known values: " + valid);
        }
        ConsoleTool.log("Task: " + task.name());
        ((Tasks)task).get().process(extra.toArray(new String[extra.size()]));
    }

    public static void error(String message) {
        ConsoleTool.log(message);
        throw new RuntimeException(message);
    }

    public static void log(String message) {
        System.out.println(message);
    }
}

