/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.Manifest;
import net.minecraftforge.installer.json.Mirror;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;

public class DownloadUtils {
    public static final String LIBRARIES_URL = "https://libraries.minecraft.net/";
    public static final String MANIFEST_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    public static boolean OFFLINE_MODE = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean downloadLibrary(ProgressCallback monitor, Mirror mirror, Version.Library library, File root, Predicate<String> optional, List<Artifact> grabbed) {
        Version.LibraryDownload download;
        Artifact artifact = library.getName();
        File target = artifact.getLocalPath(root);
        Version.LibraryDownload libraryDownload = download = library.getDownloads() == null ? null : library.getDownloads().getArtifact();
        if (download == null) {
            download = new Version.LibraryDownload();
            download.setPath(artifact.getPath());
        }
        if (!optional.test(library.getName().getDescriptor())) {
            monitor.message(String.format("Considering library %s: Not Downloading {Disabled}", artifact.getDescriptor()));
            return true;
        }
        monitor.message(String.format("Considering library %s", artifact.getDescriptor()));
        if (target.exists()) {
            if (download.getSha1() == null) {
                monitor.message("  File exists: No checksum, Assuming valid.");
                return true;
            }
            String sha1 = DownloadUtils.getSha1(target);
            if (download.getSha1().equals(sha1)) {
                monitor.message("  File exists: Checksum validated.");
                return true;
            }
            monitor.message("  File exists: Checksum invalid, deleting file:");
            monitor.message("    Expected: " + download.getSha1());
            monitor.message("    Actual:   " + sha1);
            if (!target.delete()) {
                monitor.stage("    Failed to delete file, aborting.");
                return false;
            }
        }
        target.getParentFile().mkdirs();
        try (InputStream input = DownloadUtils.class.getResourceAsStream("/maven/" + artifact.getPath());){
            if (input != null) {
                monitor.message("  Extracting library from /maven/" + artifact.getPath());
                Files.copy(() -> input, (File)target);
                if (download.getSha1() == null) {
                    monitor.message("    Extraction completed: No checksum, Assuming valid.");
                    grabbed.add(artifact);
                    boolean bl = true;
                    return bl;
                }
                String sha1 = DownloadUtils.getSha1(target);
                if (download.getSha1().equals(sha1)) {
                    monitor.message("    Extraction completed: Checksum validated.");
                    grabbed.add(artifact);
                    boolean bl = true;
                    return bl;
                }
                monitor.message("    Extraction failed: Checksum invalid, deleting file:");
                monitor.message("      Expected: " + download.getSha1());
                monitor.message("      Actual:   " + sha1);
                if (!target.delete()) {
                    monitor.stage("      Failed to delete file, aborting.");
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        String url = download.getUrl();
        if (url != null && !url.isEmpty()) {
            if (!DownloadUtils.download(monitor, mirror, download, target)) return false;
            grabbed.add(artifact);
            return true;
        }
        monitor.message("  Invalid library, missing url");
        return false;
    }

    public static boolean download(ProgressCallback monitor, Mirror mirror, Version.LibraryDownload download, File target) {
        String url = download.getUrl();
        if (!url.startsWith(LIBRARIES_URL) && mirror != null) {
            url = mirror.getUrl() + download.getPath();
        }
        return DownloadUtils.download(monitor, mirror, download, target, url);
    }

    public static boolean download(ProgressCallback monitor, Mirror mirror, Version.Download download, File target) {
        return DownloadUtils.download(monitor, mirror, download, target, download.getUrl());
    }

    private static boolean download(ProgressCallback monitor, Mirror mirror, Version.Download download, File target, String url) {
        monitor.message("  Downloading library from " + url);
        try {
            URLConnection connection = DownloadUtils.getConnection(url);
            if (connection != null) {
                Files.copy(() -> connection.getInputStream(), (File)target);
                if (download.getSha1() != null) {
                    String sha1 = DownloadUtils.getSha1(target);
                    if (download.getSha1().equals(sha1)) {
                        monitor.message("    Download completed: Checksum validated.");
                        return true;
                    }
                    monitor.message("    Download failed: Checksum invalid, deleting file:");
                    monitor.message("      Expected: " + download.getSha1());
                    monitor.message("      Actual:   " + sha1);
                    if (!target.delete()) {
                        monitor.stage("      Failed to delete file, aborting.");
                        return false;
                    }
                }
                monitor.message("    Download completed: No checksum, Assuming valid.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getSha1(File target) {
        try {
            return Hashing.sha1().hashBytes(Files.toByteArray((File)target)).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean checksumValid(File target, String checksum) {
        if (checksum == null || checksum.isEmpty()) {
            return true;
        }
        String sha1 = DownloadUtils.getSha1(target);
        return sha1 != null && sha1.equals(checksum);
    }

    private static URLConnection getConnection(String url) {
        if (OFFLINE_MODE) {
            System.out.println("Offline Mode: Not downloading: " + url);
            return null;
        }
        try {
            URLConnection connection = new URL(url).openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            return connection;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean downloadFileEtag(File target, String url) {
        try {
            URLConnection connection = DownloadUtils.getConnection(url);
            String etag = connection.getHeaderField("ETag");
            if (etag == null) {
                etag = "-";
            } else if (etag.startsWith("\"") && etag.endsWith("\"")) {
                etag = etag.substring(1, etag.length() - 1);
            }
            Files.copy(() -> connection.getInputStream(), (File)target);
            if (etag.indexOf(45) != -1) {
                return true;
            }
            byte[] fileData = Files.toByteArray((File)target);
            String md5 = Hashing.md5().hashBytes(fileData).toString();
            System.out.println("  ETag: " + etag);
            System.out.println("  MD5:  " + md5);
            return etag.equalsIgnoreCase(md5);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Mirror[] downloadMirrors(String url) {
        try {
            URLConnection connection = DownloadUtils.getConnection(url);
            if (connection == null) return null;
            try (InputStream stream = connection.getInputStream();){
                Mirror[] mirrorArray = Util.loadMirriorList(stream);
                return mirrorArray;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest downloadManifest() {
        try {
            URLConnection connection = DownloadUtils.getConnection(MANIFEST_URL);
            if (connection == null) return null;
            try (InputStream stream = connection.getInputStream();){
                Manifest manifest = Util.loadManifest(stream);
                return manifest;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean downloadFile(File target, String url) {
        try {
            URLConnection connection = DownloadUtils.getConnection(url);
            if (connection != null) {
                Files.copy(() -> connection.getInputStream(), (File)target);
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean extractFile(Artifact art, File target, String checksum) {
        InputStream input = DownloadUtils.class.getResourceAsStream("/maven/" + art.getPath());
        if (input == null) {
            System.out.println("File not found in installer archive: /maven/" + art.getPath());
            return false;
        }
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        try {
            Files.copy(() -> input, (File)target);
            return DownloadUtils.checksumValid(target, checksum);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean extractFile(String name, File target) {
        String path = name.charAt(0) == '/' ? name : '/' + name;
        InputStream input = DownloadUtils.class.getResourceAsStream(path);
        if (input == null) {
            System.out.println("File not found in installer archive: " + path);
            return false;
        }
        if (!target.getParentFile().exists()) {
            target.getParentFile().mkdirs();
        }
        try {
            Files.copy(() -> input, (File)target);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }
}

