/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.SimpleInstaller;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.PostProcessors;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.Install;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;

public abstract class Action {
    protected final Install profile;
    protected final ProgressCallback monitor;
    protected final PostProcessors processors;
    protected final Version version;
    private List<Artifact> grabbed = new ArrayList<Artifact>();

    protected Action(Install profile, ProgressCallback monitor, boolean isClient) {
        this.profile = profile;
        this.monitor = monitor;
        this.processors = new PostProcessors(profile, isClient, monitor);
        this.version = Util.loadVersion(profile);
    }

    protected void error(String message) {
        if (!SimpleInstaller.headless) {
            JOptionPane.showMessageDialog(null, message, "Error", 0);
        }
        this.monitor.stage(message);
    }

    public abstract boolean run(File var1, Predicate<String> var2) throws ActionCanceledException;

    public abstract boolean isPathValid(File var1);

    public abstract String getFileError(File var1);

    public abstract String getSuccessMessage();

    public String getSponsorMessage() {
        return this.profile.getMirror() != null ? String.format(SimpleInstaller.headless ? "Data kindly mirrored by %2$s at %1$s" : "<html><a href='%s'>Data kindly mirrored by %s</a></html>", this.profile.getMirror().getHomepage(), this.profile.getMirror().getName()) : null;
    }

    protected boolean downloadLibraries(File librariesDir, Predicate<String> optionals) throws ActionCanceledException {
        ArrayList<Version.Library> libraries = new ArrayList<Version.Library>();
        libraries.addAll(Arrays.asList(this.version.getLibraries()));
        libraries.addAll(Arrays.asList(this.processors.getLibraries()));
        StringBuilder output = new StringBuilder();
        double steps = libraries.size();
        int progress = 1;
        this.monitor.start("Downloading libraries");
        for (Version.Library lib : libraries) {
            Version.LibraryDownload download;
            this.checkCancel();
            this.monitor.progress((double)progress++ / steps);
            if (DownloadUtils.downloadLibrary(this.monitor, this.profile.getMirror(), lib, librariesDir, optionals, this.grabbed) || (download = lib.getDownloads() == null ? null : lib.getDownloads().getArtifact()) == null || download.getUrl().isEmpty()) continue;
            output.append('\n').append(lib.getName());
        }
        String bad = output.toString();
        if (!bad.isEmpty()) {
            this.error("These libraries failed to download. Try again.\n" + bad);
            return false;
        }
        return true;
    }

    protected int downlaodedCount() {
        return this.grabbed.size();
    }

    protected int getTaskCount() {
        return this.profile.getLibraries().length + this.processors.getTaskCount();
    }

    protected void checkCancel() throws ActionCanceledException {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            throw new ActionCanceledException(e);
        }
    }
}

