/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import java.io.File;
import java.util.function.Predicate;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.Artifact;
import net.minecraftforge.installer.json.Install;

public class ExtractAction
extends Action {
    public static boolean headless;

    public ExtractAction(Install profile, ProgressCallback monitor) {
        super(profile, monitor, true);
    }

    @Override
    public boolean run(File target, Predicate<String> optionals) {
        File file;
        boolean result = true;
        String failed = "An error occurred extracting the files:";
        Artifact contained = this.profile.getPath();
        if (!DownloadUtils.extractFile(contained, file = new File(target, contained.getFilename()), null)) {
            result = false;
            failed = failed + "\n" + contained.getFilename();
        }
        if (!result) {
            this.error(failed);
        }
        return result;
    }

    @Override
    public boolean isPathValid(File targetDir) {
        return targetDir.exists() && targetDir.isDirectory();
    }

    @Override
    public String getFileError(File targetDir) {
        return !targetDir.exists() ? "Target directory does not exist" : (!targetDir.isDirectory() ? "Target is not a directory" : "");
    }

    @Override
    public String getSuccessMessage() {
        return "Extracted successfully";
    }
}

