/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.transform;

import argo.jdom.JsonNode;
import com.google.common.base.Strings;
import java.util.Locale;
import net.minecraftforge.installer.Artifact;

public class TransformInfo {
    public final String side;
    public final String input;
    public final Artifact output;
    public final String map;
    public final boolean append;
    private Artifact inputArtifact;
    public final String maven;

    public TransformInfo(JsonNode node) {
        this.side = node.isStringValue(new Object[]{"side"}) ? node.getStringValue(new Object[]{"side"}).toUpperCase(Locale.ENGLISH) : null;
        this.input = node.getStringValue(new Object[]{"input"});
        this.output = new Artifact(node.getStringValue(new Object[]{"output"}));
        this.map = node.getStringValue(new Object[]{"map"});
        this.append = this.getBool(node, "append", false);
        this.maven = node.isStringValue(new Object[]{"maven"}) ? node.getStringValue(new Object[]{"maven"}) : null;
    }

    private boolean getBool(JsonNode node, String name, boolean _def) {
        if (!node.isBooleanValue(new Object[]{name})) {
            return _def;
        }
        return node.getBooleanValue(new Object[]{name});
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.input) && this.output != null && !Strings.isNullOrEmpty((String)this.map);
    }

    public Artifact getInputArtifact() {
        if (this.inputArtifact == null) {
            this.inputArtifact = new Artifact(this.input);
        }
        return this.inputArtifact;
    }

    public boolean validSide(String side) {
        return side == null || side.toUpperCase(Locale.ENGLISH).equals(this.side);
    }
}

