/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import argo.jdom.JdomParser;
import argo.jdom.JsonNode;
import argo.jdom.JsonRootNode;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.installer.LibraryInfo;
import net.minecraftforge.installer.OptionalLibrary;
import net.minecraftforge.installer.transform.LibraryTransformer;
import net.minecraftforge.installer.transform.TransformInfo;

public class VersionInfo {
    public static final VersionInfo INSTANCE = new VersionInfo();
    public final JsonRootNode versionData;
    private final List<OptionalLibrary> optionals = Lists.newArrayList();
    private final TransformInfo[] transforms;
    private final LibraryTransformer transformer;

    public VersionInfo() {
        InputStream installProfile = this.getClass().getResourceAsStream("/install_profile.json");
        JdomParser parser = new JdomParser();
        try {
            this.versionData = parser.parse((Reader)new InputStreamReader(installProfile, Charsets.UTF_8));
            if (this.versionData.isArrayNode(new Object[]{"optionals"})) {
                for (JsonNode opt : this.versionData.getArrayNode(new Object[]{"optionals"})) {
                    OptionalLibrary o = new OptionalLibrary(opt);
                    if (!o.isValid()) {
                        System.out.println("Optional Library is invalid, must specify a name, artifact and maven");
                        continue;
                    }
                    this.optionals.add(o);
                }
            }
            LibraryTransformer tmp = new LibraryTransformer();
            this.transforms = tmp.read(this.versionData);
            this.transformer = this.transforms.length > 0 ? tmp : null;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String getProfileName() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "profileName"});
    }

    public static String getVersionTarget() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "target"});
    }

    public static File getLibraryPath(File root) {
        String path = VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "path"});
        String[] split = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').omitEmptyStrings().split((CharSequence)path), String.class);
        File dest = root;
        Iterable subSplit = Splitter.on((char)'.').omitEmptyStrings().split((CharSequence)split[0]);
        for (String part : subSplit) {
            dest = new File(dest, part);
        }
        dest = new File(new File(dest, split[1]), split[2]);
        String fileName = split[1] + "-" + split[2] + ".jar";
        return new File(dest, fileName);
    }

    public static String getModListType() {
        return !VersionInfo.INSTANCE.versionData.isStringValue(new Object[]{"install", "modList"}) ? "" : VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "modList"});
    }

    public static String getVersion() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "version"});
    }

    public static String getWelcomeMessage() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "welcome"});
    }

    public static String getLogoFileName() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "logo"});
    }

    public static String getURLFileName() {
        if (!VersionInfo.INSTANCE.versionData.isStringValue(new Object[]{"install", "urlIcon"})) {
            return "/url.png";
        }
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "urlIcon"});
    }

    public static boolean getStripMetaInf() {
        try {
            return VersionInfo.INSTANCE.versionData.getBooleanValue(new Object[]{"install", "stripMeta"});
        }
        catch (Exception e) {
            return false;
        }
    }

    public static JsonNode getVersionInfo() {
        return VersionInfo.INSTANCE.versionData.getNode(new Object[]{"versionInfo"});
    }

    public static File getMinecraftFile(File path) {
        return new File(new File(path, VersionInfo.getMinecraftVersion()), VersionInfo.getMinecraftVersion() + ".jar");
    }

    public static String getContainedFile() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "filePath"});
    }

    public static void extractFile(File path) throws IOException {
        INSTANCE.doFileExtract(path);
    }

    private void doFileExtract(File path) throws IOException {
        if (Strings.isNullOrEmpty((String)VersionInfo.getContainedFile())) {
            return;
        }
        System.out.println("Extracting: /" + VersionInfo.getContainedFile());
        System.out.println("To:          " + path.getAbsolutePath());
        InputStream inputStream = this.getClass().getResourceAsStream("/" + VersionInfo.getContainedFile());
        OutputSupplier outputSupplier = Files.newOutputStreamSupplier((File)path);
        ByteStreams.copy((InputStream)inputStream, (OutputSupplier)outputSupplier);
    }

    public static String getMinecraftVersion() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "minecraft"});
    }

    public static String getMirrorListURL() {
        return VersionInfo.INSTANCE.versionData.getStringValue(new Object[]{"install", "mirrorList"});
    }

    public static boolean hasMirrors() {
        return VersionInfo.INSTANCE.versionData.isStringValue(new Object[]{"install", "mirrorList"});
    }

    public static boolean hideClient() {
        return VersionInfo.INSTANCE.versionData.isBooleanValue(new Object[]{"install", "hideClient"}) && VersionInfo.INSTANCE.versionData.getBooleanValue(new Object[]{"install", "hideClient"}) != false;
    }

    public static boolean hideServer() {
        return VersionInfo.INSTANCE.versionData.isBooleanValue(new Object[]{"install", "hideServer"}) && VersionInfo.INSTANCE.versionData.getBooleanValue(new Object[]{"install", "hideServer"}) != false;
    }

    public static boolean hideExtract() {
        return VersionInfo.INSTANCE.versionData.isBooleanValue(new Object[]{"install", "hideExtract"}) && VersionInfo.INSTANCE.versionData.getBooleanValue(new Object[]{"install", "hideExtract"}) != false;
    }

    public static boolean isInheritedJson() {
        return VersionInfo.INSTANCE.versionData.isStringValue(new Object[]{"versionInfo", "inheritsFrom"}) && VersionInfo.INSTANCE.versionData.isStringValue(new Object[]{"versionInfo", "jar"});
    }

    public static boolean hasOptionals() {
        return VersionInfo.getOptionals().size() > 0;
    }

    public static List<OptionalLibrary> getOptionals() {
        return VersionInfo.INSTANCE.optionals;
    }

    public static List<LibraryInfo> getLibraries(String marker, Predicate<String> filter) {
        ArrayList ret = Lists.newArrayList();
        for (JsonNode node : VersionInfo.INSTANCE.versionData.getArrayNode(new Object[]{"versionInfo", "libraries"})) {
            ret.add(new LibraryInfo(node, marker));
        }
        for (OptionalLibrary opt : VersionInfo.getOptionals()) {
            LibraryInfo info = new LibraryInfo(opt, marker);
            info.setEnabled(filter.apply((Object)opt.getArtifact()));
            ret.add(info);
        }
        return ret;
    }

    public static boolean needsMCDownload(String side) {
        for (TransformInfo ti : VersionInfo.INSTANCE.transforms) {
            if (!ti.validSide(side) || !"{minecraft_server_jar}".equals(ti.input) && !"{minecraft_jar}".equals(ti.input)) continue;
            return true;
        }
        return false;
    }

    public static List<TransformInfo> getTransforms(String side) {
        ArrayList<TransformInfo> ret = new ArrayList<TransformInfo>();
        for (TransformInfo ti : VersionInfo.INSTANCE.transforms) {
            if (!ti.validSide(side)) continue;
            ret.add(ti);
        }
        return ret;
    }

    public static LibraryTransformer getTransformer() {
        return VersionInfo.INSTANCE.transformer;
    }
}

