/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import com.google.common.base.Predicate;
import java.io.File;
import java.util.function.Supplier;
import javax.swing.Icon;
import net.minecraftforge.installer.ActionType;
import net.minecraftforge.installer.ClientInstall;
import net.minecraftforge.installer.ExtractAction;
import net.minecraftforge.installer.MirrorData;
import net.minecraftforge.installer.ServerInstall;

public enum InstallerAction {
    CLIENT("Install client", "Install a new profile to the Mojang client launcher", ClientInstall::new),
    SERVER("Install server", "Create a new modded server installation", ServerInstall::new),
    EXTRACT("Extract", "Extract the contained jar file", ExtractAction::new);

    private String label;
    private String tooltip;
    private ActionType action;

    private InstallerAction(String label, String tooltip, Supplier<? extends ActionType> action) {
        this.label = label;
        this.tooltip = tooltip;
        this.action = action.get();
    }

    public String getButtonLabel() {
        return this.label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean run(File path, Predicate<String> optionals) {
        return this.action.run(path, optionals);
    }

    public boolean isPathValid(File targetDir) {
        return this.action.isPathValid(targetDir);
    }

    public String getFileError(File targetDir) {
        return this.action.getFileError(targetDir);
    }

    public String getSuccessMessage() {
        return this.action.getSuccessMessage();
    }

    public String getSponsorMessage() {
        return this.action.getSponsorMessage();
    }

    public Icon getSponsorLogo() {
        return MirrorData.INSTANCE.getImageIcon();
    }

    public String getSponsorURL() {
        return MirrorData.INSTANCE.getSponsorURL();
    }
}

