/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import com.google.common.base.Predicate;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import net.minecraftforge.installer.ActionType;
import net.minecraftforge.installer.Artifact;
import net.minecraftforge.installer.OptionalLibrary;
import net.minecraftforge.installer.VersionInfo;

public class ExtractAction
implements ActionType {
    public static boolean headless;

    @Override
    public boolean run(File target, Predicate<String> optionals) {
        boolean result = true;
        String failed = "An error occurred extracting the files:";
        File file = new File(target, VersionInfo.getContainedFile());
        try {
            VersionInfo.extractFile(file);
        }
        catch (IOException e) {
            result = false;
            failed = failed + "\n" + VersionInfo.getContainedFile();
        }
        for (OptionalLibrary opt : VersionInfo.getOptionals()) {
            Artifact art = new Artifact(opt.getArtifact());
            InputStream input = ExtractAction.class.getResourceAsStream("/maven/" + art.getPath());
            if (input == null) continue;
            File path = art.getLocalPath(new File(target, "libraries"));
            File outFolder = art.getLocalPath(path).getParentFile();
            if (!outFolder.exists()) {
                outFolder.mkdirs();
            }
            OutputSupplier outputSupplier = Files.newOutputStreamSupplier((File)path);
            try {
                ByteStreams.copy((InputStream)input, (OutputSupplier)outputSupplier);
            }
            catch (IOException e) {
                result = false;
                failed = failed + "\n" + opt.getArtifact();
            }
        }
        if (!result) {
            if (!headless) {
                JOptionPane.showMessageDialog(null, failed, "Error", 0);
            }
            System.out.println(failed);
        }
        return result;
    }

    @Override
    public boolean isPathValid(File targetDir) {
        return targetDir.exists() && targetDir.isDirectory();
    }

    @Override
    public String getFileError(File targetDir) {
        return !targetDir.exists() ? "Target directory does not exist" : (!targetDir.isDirectory() ? "Target is not a directory" : "");
    }

    @Override
    public String getSuccessMessage() {
        return "Extracted successfully";
    }

    @Override
    public String getSponsorMessage() {
        return null;
    }
}

