/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import argo.format.PrettyJsonFormatter;
import argo.jdom.JdomParser;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import net.minecraftforge.installer.ActionType;
import net.minecraftforge.installer.Artifact;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.IMonitor;
import net.minecraftforge.installer.LibraryInfo;
import net.minecraftforge.installer.MirrorData;
import net.minecraftforge.installer.OptionalLibrary;
import net.minecraftforge.installer.VersionInfo;
import net.minecraftforge.installer.transform.TransformInfo;

public class ClientInstall
implements ActionType {
    private List<Artifact> grabbed;
    private static final String SIDE = "CLIENT";

    @Override
    public boolean run(File target, Predicate<String> optionals) {
        if (!target.exists()) {
            JOptionPane.showMessageDialog(null, "There is no minecraft installation at this location!", "Error", 0);
            return false;
        }
        File launcherProfiles = new File(target, "launcher_profiles.json");
        File launcherProfilesMS = new File(target, "launcher_profiles.json");
        if (!launcherProfiles.exists() && !launcherProfilesMS.exists()) {
            JOptionPane.showMessageDialog(null, "There is no minecraft launcher profile in \"" + target + "\", you need to run the launcher first!", "Error", 0);
            return false;
        }
        File versionRootDir = new File(target, "versions");
        File versionTarget = new File(versionRootDir, VersionInfo.getVersionTarget());
        if (!versionTarget.mkdirs() && !versionTarget.isDirectory()) {
            if (!versionTarget.delete()) {
                JOptionPane.showMessageDialog(null, "There was a problem with the launcher version data. You will need to clear " + versionTarget.getAbsolutePath() + " manually", "Error", 0);
            } else {
                versionTarget.mkdirs();
            }
        }
        File librariesDir = new File(target, "libraries");
        IMonitor monitor = DownloadUtils.buildMonitor();
        List<LibraryInfo> libraries = VersionInfo.getLibraries("clientreq", optionals);
        List<TransformInfo> transforms = VersionInfo.getTransforms(SIDE);
        monitor.setMaximum(libraries.size() + transforms.size() + 3);
        int progress = 3;
        File versionJsonFile = new File(versionTarget, VersionInfo.getVersionTarget() + ".json");
        boolean downloadMCJar = true;
        File minecraftJarFile = VersionInfo.getMinecraftFile(versionRootDir);
        if (downloadMCJar) {
            monitor.setNote("Considering minecraft client jar");
            monitor.setProgress(1);
            if (!minecraftJarFile.exists()) {
                monitor.setNote(String.format("Downloading minecraft client version %s", VersionInfo.getMinecraftVersion()));
                String clientUrl = String.format("https://s3.amazonaws.com/Minecraft.Download/versions/{MCVER}/{MCVER}.jar".replace("{MCVER}", VersionInfo.getMinecraftVersion()), new Object[0]);
                if (!DownloadUtils.downloadFileEtag("minecraft server", minecraftJarFile, clientUrl)) {
                    minecraftJarFile.delete();
                    JOptionPane.showMessageDialog(null, "Downloading minecraft failed, invalid e-tag checksum.\nTry again, or use the official launcher to run Minecraft " + VersionInfo.getMinecraftVersion() + " first.", "Error downloading", 0);
                    return false;
                }
                monitor.setProgress(2);
            }
        }
        if (!VersionInfo.isInheritedJson()) {
            File clientJarFile = new File(versionTarget, VersionInfo.getVersionTarget() + ".jar");
            try {
                if (VersionInfo.getStripMetaInf()) {
                    monitor.setNote("Copying and filtering minecraft client jar");
                    this.copyAndStrip(minecraftJarFile, clientJarFile);
                    monitor.setProgress(3);
                } else {
                    monitor.setNote("Copying minecraft client jar");
                    Files.copy((File)minecraftJarFile, (File)clientJarFile);
                    monitor.setProgress(3);
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, "You need to run the version " + VersionInfo.getMinecraftVersion() + " manually at least once", "Error", 0);
                return false;
            }
        }
        File targetLibraryFile = VersionInfo.getLibraryPath(librariesDir);
        this.grabbed = Lists.newArrayList();
        ArrayList bad = Lists.newArrayList();
        progress = DownloadUtils.downloadInstalledLibraries(true, librariesDir, monitor, libraries, progress, this.grabbed, bad);
        if (bad.size() > 0) {
            String list = Joiner.on((String)"\n").join((Iterable)bad);
            JOptionPane.showMessageDialog(null, "These libraries failed to download. Try again.\n" + list, "Error downloading", 0);
            return false;
        }
        if (!targetLibraryFile.getParentFile().mkdirs() && !targetLibraryFile.getParentFile().isDirectory()) {
            if (!targetLibraryFile.getParentFile().delete()) {
                JOptionPane.showMessageDialog(null, "There was a problem with the launcher version data. You will need to clear " + targetLibraryFile.getAbsolutePath() + " manually", "Error", 0);
                return false;
            }
            targetLibraryFile.getParentFile().mkdirs();
        }
        String modListType = VersionInfo.getModListType();
        File modListFile = new File(target, "mods/mod_list.json");
        JsonRootNode versionJson = JsonNodeFactories.object((Map)VersionInfo.getVersionInfo().getFields());
        if ("absolute".equals(modListType)) {
            modListFile = new File(versionTarget, "mod_list.json");
            JsonStringNode node = (JsonStringNode)versionJson.getNode(new Object[]{"minecraftArguments"});
            try {
                Field value = JsonStringNode.class.getDeclaredField("value");
                value.setAccessible(true);
                String args = (String)value.get(node);
                value.set(node, args + " --modListFile \"absolute:" + modListFile.getAbsolutePath() + "\"");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!"none".equals(modListType) && !OptionalLibrary.saveModListJson(librariesDir, modListFile, VersionInfo.getOptionals(), optionals)) {
            JOptionPane.showMessageDialog(null, "Failed to write mod_list.json, optional mods may not be loaded.", "Error", 0);
        }
        for (TransformInfo info : transforms) {
            monitor.setNote("Transforming " + info.input);
            monitor.setProgress(progress++);
            if (VersionInfo.getTransformer().transform(info, SIDE, target, VersionInfo.getMinecraftVersion())) continue;
            JOptionPane.showMessageDialog(null, "There was a problem transforming " + info.input + ". You will need to clear " + info.output.getLocalPath(librariesDir).getAbsolutePath() + " manually and try again", "Error", 0);
            return false;
        }
        monitor.close();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, Charsets.UTF_8);
            PrettyJsonFormatter.fieldOrderPreservingPrettyJsonFormatter().format(versionJson, (Writer)writer);
            ((Writer)writer).close();
            byte[] output = bos.toByteArray();
            ArrayList lst = Lists.newArrayList();
            for (OptionalLibrary opt : VersionInfo.getOptionals()) {
                if (!optionals.apply((Object)opt.getArtifact()) || !opt.isInjected()) continue;
                lst.add(new AppendInfo(opt.getArtifact(), opt.getMaven()));
            }
            for (TransformInfo info : transforms) {
                if (!info.append) continue;
                lst.add(new AppendInfo(info.output.getDescriptor(), info.maven));
            }
            if (lst.size() > 0) {
                BufferedReader reader = new BufferedReader(new StringReader(new String(output, Charsets.UTF_8)));
                bos = new ByteArrayOutputStream();
                PrintWriter printer = new PrintWriter(new OutputStreamWriter((OutputStream)bos, Charsets.UTF_8));
                String line = null;
                String prefix = null;
                boolean added = false;
                while ((line = reader.readLine()) != null) {
                    if (added) {
                        printer.println(line);
                        continue;
                    }
                    if (line.contains("\"libraries\": [")) {
                        prefix = line.substring(0, line.indexOf(34));
                    } else if (prefix != null && line.startsWith(prefix + "]")) {
                        printer.println(prefix + "\t,");
                        for (int x = 0; x < lst.size(); ++x) {
                            AppendInfo info = (AppendInfo)lst.get(x);
                            printer.println(prefix + "\t{");
                            printer.println(prefix + "\t\t\"name\": \"" + info.artifact + "\"" + info.maven == null ? "" : ",");
                            if (info.maven != null) {
                                printer.println(prefix + "\t\t\"url\": \"" + info.maven + "\"");
                            }
                            if (x < lst.size() - 1) {
                                printer.println(prefix + "\t},");
                                continue;
                            }
                            printer.println(prefix + "\t}");
                        }
                        added = true;
                    }
                    printer.println(line);
                }
                printer.close();
                output = bos.toByteArray();
            }
            Files.write((byte[])output, (File)versionJsonFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "There was a problem writing the launcher version data,  is it write protected?", "Error", 0);
            return false;
        }
        try {
            VersionInfo.extractFile(targetLibraryFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "There was a problem writing the system library file", "Error", 0);
            return false;
        }
        if (launcherProfiles.exists() && !this.injectProfile(launcherProfiles)) {
            return false;
        }
        return !launcherProfilesMS.exists() || this.injectProfile(launcherProfilesMS);
    }

    private boolean injectProfile(File path) {
        JsonRootNode jsonProfileData;
        JdomParser parser = new JdomParser();
        try {
            jsonProfileData = parser.parse((Reader)Files.newReader((File)path, (Charset)Charsets.UTF_8));
        }
        catch (InvalidSyntaxException e) {
            JOptionPane.showMessageDialog(null, "The launcher profile file is corrupted. Re-run the minecraft launcher to fix it!", "Error", 0);
            return false;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        HashMap profileCopy = Maps.newHashMap((Map)jsonProfileData.getNode(new Object[]{"profiles"}).getFields());
        HashMap rootCopy = Maps.newHashMap((Map)jsonProfileData.getFields());
        if (profileCopy.containsKey(JsonNodeFactories.string((String)VersionInfo.getProfileName()))) {
            HashMap forgeProfileCopy = Maps.newHashMap((Map)((JsonNode)profileCopy.get(JsonNodeFactories.string((String)VersionInfo.getProfileName()))).getFields());
            forgeProfileCopy.put(JsonNodeFactories.string((String)"name"), JsonNodeFactories.string((String)VersionInfo.getProfileName()));
            forgeProfileCopy.put(JsonNodeFactories.string((String)"lastVersionId"), JsonNodeFactories.string((String)VersionInfo.getVersionTarget()));
        } else {
            JsonField[] fields = new JsonField[]{JsonNodeFactories.field((String)"name", (JsonNode)JsonNodeFactories.string((String)VersionInfo.getProfileName())), JsonNodeFactories.field((String)"lastVersionId", (JsonNode)JsonNodeFactories.string((String)VersionInfo.getVersionTarget()))};
            profileCopy.put(JsonNodeFactories.string((String)VersionInfo.getProfileName()), JsonNodeFactories.object((JsonField[])fields));
        }
        JsonRootNode profileJsonCopy = JsonNodeFactories.object((Map)profileCopy);
        rootCopy.put(JsonNodeFactories.string((String)"profiles"), profileJsonCopy);
        jsonProfileData = JsonNodeFactories.object((Map)rootCopy);
        try {
            BufferedWriter newWriter = Files.newWriter((File)path, (Charset)Charsets.UTF_8);
            PrettyJsonFormatter.fieldOrderPreservingPrettyJsonFormatter().format(jsonProfileData, (Writer)newWriter);
            newWriter.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "There was a problem writing the launch profile,  is it write protected?", "Error", 0);
            return false;
        }
        return true;
    }

    private void copyAndStrip(File sourceJar, File targetJar) throws IOException {
        ZipFile in = new ZipFile(sourceJar);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetJar)));
        for (ZipEntry zipEntry : Collections.list(in.entries())) {
            if (zipEntry.isDirectory()) {
                out.putNextEntry(zipEntry);
                continue;
            }
            if (zipEntry.getName().startsWith("META-INF")) continue;
            ZipEntry n = new ZipEntry(zipEntry.getName());
            n.setTime(zipEntry.getTime());
            out.putNextEntry(n);
            out.write(ClientInstall.readEntry(in, zipEntry));
        }
        in.close();
        out.close();
    }

    private static byte[] readEntry(ZipFile inFile, ZipEntry entry) throws IOException {
        return ClientInstall.readFully(inFile.getInputStream(entry));
    }

    private static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }

    @Override
    public boolean isPathValid(File targetDir) {
        if (targetDir.exists()) {
            return new File(targetDir, "launcher_profiles.json").exists() || new File(targetDir, "launcher_profiles_microsoft_store.json").exists();
        }
        return false;
    }

    @Override
    public String getFileError(File targetDir) {
        if (targetDir.exists()) {
            return "The directory is missing a launcher profile. Please run the minecraft launcher first";
        }
        return "There is no minecraft directory set up. Either choose an alternative, or run the minecraft launcher to create one";
    }

    @Override
    public String getSuccessMessage() {
        if (this.grabbed.size() > 0) {
            return String.format("Successfully installed client profile %s for version %s into launcher and grabbed %d required libraries", VersionInfo.getProfileName(), VersionInfo.getVersion(), this.grabbed.size());
        }
        return String.format("Successfully installed client profile %s for version %s into launcher", VersionInfo.getProfileName(), VersionInfo.getVersion());
    }

    @Override
    public String getSponsorMessage() {
        return MirrorData.INSTANCE.hasMirrors() ? String.format("<html><a href='%s'>Data kindly mirrored by %s</a></html>", MirrorData.INSTANCE.getSponsorURL(), MirrorData.INSTANCE.getSponsorName()) : null;
    }

    private static class AppendInfo {
        private String artifact;
        private String maven;

        private AppendInfo(String artifact, String maven) {
            this.artifact = artifact;
            this.maven = maven;
        }
    }
}

