/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.InstallerAction;
import net.minecraftforge.installer.InstallerPanel;
import net.minecraftforge.installer.ServerInstall;
import net.minecraftforge.installer.VersionInfo;

public class SimpleInstaller {
    public static void main(String[] args) throws IOException {
        SimpleInstaller.setupLogger();
        if (System.getProperty("java.net.preferIPv4Stack") == null) {
            System.setProperty("java.net.preferIPv4Stack", "true");
        }
        System.out.println("java.net.preferIPv4Stack=" + System.getProperty("java.net.preferIPv4Stack"));
        OptionParser parser = new OptionParser();
        OptionSpecBuilder serverInstallOption = parser.accepts("installServer", "Install a server to the current directory");
        OptionSpecBuilder extractOption = parser.accepts("extract", "Extract the contained jar file");
        OptionSpecBuilder helpOption = parser.acceptsAll(Arrays.asList("h", "help"), "Help with this installer");
        OptionSpecBuilder offlineOption = parser.accepts("offline", "Don't attempt any network calls");
        OptionSet optionSet = parser.parse(args);
        int cnt = 0;
        if (optionSet.has((OptionSpec)offlineOption)) {
            DownloadUtils.OFFLINE_MODE = true;
            System.out.println("ENABELING OFFLINE MODE");
            cnt = 1;
        }
        if (optionSet.specs().size() > cnt) {
            SimpleInstaller.handleOptions(parser, optionSet, serverInstallOption, extractOption, helpOption);
        } else {
            SimpleInstaller.launchGui();
        }
    }

    private static void handleOptions(OptionParser parser, OptionSet optionSet, OptionSpecBuilder serverInstallOption, OptionSpecBuilder extractOption, OptionSpecBuilder helpOption) throws IOException {
        String path = VersionInfo.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (path.contains("!/")) {
            System.out.println("Due to java limitation, please do not run this jar in a folder ending with !");
            System.out.println(path);
            return;
        }
        if (optionSet.has((OptionSpec)serverInstallOption)) {
            try {
                VersionInfo.getVersionTarget();
                ServerInstall.headless = true;
                System.out.println("Installing server to current directory");
                if (!InstallerAction.SERVER.run(new File("."), (Predicate<String>)Predicates.alwaysTrue())) {
                    System.err.println("There was an error during server installation");
                    System.exit(1);
                } else {
                    System.out.println("The server installed successfully, you should now be able to run the file " + VersionInfo.getContainedFile());
                    System.out.println("You can delete this installer file now if you wish");
                }
                System.exit(0);
            }
            catch (Throwable e) {
                System.err.println("A problem installing the server was detected, server install cannot continue");
                System.exit(1);
            }
        } else if (optionSet.has((OptionSpec)extractOption)) {
            try {
                VersionInfo.getVersionTarget();
                if (!InstallerAction.EXTRACT.run(new File("."), (Predicate<String>)Predicates.alwaysTrue())) {
                    System.err.println("A problem occurred extracting the file to " + VersionInfo.getContainedFile());
                    System.exit(1);
                } else {
                    System.out.println("File extracted successfully to " + VersionInfo.getContainedFile());
                    System.out.println("You can delete this installer file now if you wish");
                }
                System.exit(0);
            }
            catch (Throwable e) {
                System.err.println("A problem extracting the file was detected, extraction failed");
                System.exit(1);
            }
        } else {
            parser.printHelpOn((OutputStream)System.err);
        }
    }

    private static void launchGui() {
        String userHomeDir = System.getProperty("user.home", ".");
        String osType = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        File targetDir = null;
        String mcDir = ".minecraft";
        targetDir = osType.contains("win") && System.getenv("APPDATA") != null ? new File(System.getenv("APPDATA"), mcDir) : (osType.contains("mac") ? new File(new File(new File(userHomeDir, "Library"), "Application Support"), "minecraft") : new File(userHomeDir, mcDir));
        String path = VersionInfo.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (path.contains("!/")) {
            JOptionPane.showMessageDialog(null, "Due to java limitation, please do not run this jar in a folder ending with ! : \n" + path, "Error", 0);
            return;
        }
        try {
            VersionInfo.getVersionTarget();
        }
        catch (Throwable e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Corrupt download detected, cannot install", "Error", 0);
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        InstallerPanel panel = new InstallerPanel(targetDir);
        panel.run();
    }

    private static void setupLogger() {
        File f = new File(VersionInfo.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        File output = f.isFile() ? new File(f.getName() + ".log") : new File("installer.log");
        try {
            System.out.println("Setting up logger: " + output.getAbsolutePath());
            BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(output));
            System.setOut(new PrintStream(new MultiOutputStream(System.out, fout), true));
            System.setErr(new PrintStream(new MultiOutputStream(System.err, fout), true));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static class MultiOutputStream
    extends OutputStream {
        OutputStream[] outs;

        MultiOutputStream(OutputStream ... outs) {
            this.outs = outs;
        }

        @Override
        public void write(int b) throws IOException {
            for (OutputStream out : this.outs) {
                out.write(b);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            for (OutputStream out : this.outs) {
                out.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            for (OutputStream out : this.outs) {
                out.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            for (OutputStream out : this.outs) {
                out.flush();
            }
        }

        @Override
        public void close() throws IOException {
            for (OutputStream out : this.outs) {
                out.close();
            }
        }
    }
}

