/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import net.minecraftforge.installer.ActionType;
import net.minecraftforge.installer.Artifact;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.IMonitor;
import net.minecraftforge.installer.LibraryInfo;
import net.minecraftforge.installer.MirrorData;
import net.minecraftforge.installer.OptionalLibrary;
import net.minecraftforge.installer.VersionInfo;

public class ServerInstall
implements ActionType {
    public static boolean headless;
    private List<Artifact> grabbed;

    @Override
    public boolean run(File target, Predicate<String> optionals) {
        if (target.exists() && !target.isDirectory()) {
            if (!headless) {
                JOptionPane.showMessageDialog(null, "There is a file at this location, the server cannot be installed here!", "Error", 0);
            }
            return false;
        }
        File librariesDir = new File(target, "libraries");
        if (!target.exists()) {
            target.mkdirs();
        }
        librariesDir.mkdir();
        IMonitor monitor = DownloadUtils.buildMonitor();
        if (headless && MirrorData.INSTANCE.hasMirrors()) {
            monitor.setNote(this.getSponsorMessage());
        }
        List<LibraryInfo> libraries = VersionInfo.getLibraries("serverreq", optionals);
        monitor.setMaximum(libraries.size() + 2);
        int progress = 2;
        this.grabbed = Lists.newArrayList();
        ArrayList bad = Lists.newArrayList();
        String mcServerURL = String.format("https://s3.amazonaws.com/Minecraft.Download/versions/{MCVER}/minecraft_server.{MCVER}.jar".replace("{MCVER}", VersionInfo.getMinecraftVersion()), new Object[0]);
        File mcServerFile = new File(target, "minecraft_server." + VersionInfo.getMinecraftVersion() + ".jar");
        if (!mcServerFile.exists()) {
            monitor.setNote("Considering minecraft server jar");
            monitor.setProgress(1);
            monitor.setNote(String.format("Downloading minecraft server version %s", VersionInfo.getMinecraftVersion()));
            if (!DownloadUtils.downloadFileEtag("minecraft server", mcServerFile, mcServerURL)) {
                mcServerFile.delete();
                if (!headless) {
                    JOptionPane.showMessageDialog(null, "Downloading minecraft server failed, invalid e-tag checksum.\nTry again, or manually place server jar to skip download.", "Error downloading", 0);
                } else {
                    System.err.println("Downloading minecraft server failed, invalid e-tag checksum.");
                    System.err.println("Try again, or manually place server jar to skip download.");
                }
                return false;
            }
            monitor.setProgress(2);
        }
        progress = DownloadUtils.downloadInstalledLibraries(false, librariesDir, monitor, libraries, progress, this.grabbed, bad);
        monitor.close();
        if (bad.size() > 0) {
            String list = Joiner.on((String)"\n").join((Iterable)bad);
            if (!headless) {
                JOptionPane.showMessageDialog(null, "These libraries failed to download. Try again.\n" + list, "Error downloading", 0);
            } else {
                System.err.println("These libraries failed to download, try again. \n" + list);
            }
            return false;
        }
        try {
            File targetRun = new File(target, VersionInfo.getContainedFile());
            VersionInfo.extractFile(targetRun);
        }
        catch (IOException e) {
            if (!headless) {
                JOptionPane.showMessageDialog(null, "An error occurred installing the library", "Error", 0);
            } else {
                System.err.println("An error occurred installing the distributable");
            }
            return false;
        }
        return OptionalLibrary.saveModListJson(librariesDir, new File(target, "mods/mod_list.json"), VersionInfo.getOptionals(), optionals);
    }

    @Override
    public boolean isPathValid(File targetDir) {
        return targetDir.exists() && targetDir.isDirectory() && targetDir.list().length == 0;
    }

    @Override
    public String getFileError(File targetDir) {
        if (!targetDir.exists()) {
            return "The specified directory does not exist<br/>It will be created";
        }
        if (!targetDir.isDirectory()) {
            return "The specified path needs to be a directory";
        }
        return "There are already files at the target directory";
    }

    @Override
    public String getSuccessMessage() {
        if (this.grabbed.size() > 0) {
            return String.format("Successfully downloaded minecraft server, downloaded %d libraries and installed %s", this.grabbed.size(), VersionInfo.getProfileName());
        }
        return String.format("Successfully downloaded minecraft server and installed %s", VersionInfo.getProfileName());
    }

    @Override
    public String getSponsorMessage() {
        return MirrorData.INSTANCE.hasMirrors() ? String.format(headless ? "Data kindly mirrored by %2$s at %1$s" : "<html><a href='%s'>Data kindly mirrored by %s</a></html>", MirrorData.INSTANCE.getSponsorURL(), MirrorData.INSTANCE.getSponsorName()) : null;
    }
}

