/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import argo.jdom.JsonNode;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class OptionalLibrary {
    private JsonNode node;
    private String name;
    private String artifact;
    private String maven;
    private boolean client = false;
    private boolean server = false;
    private boolean _default = true;
    private boolean inject = true;
    private String desc;
    private String url;

    public OptionalLibrary(JsonNode node) {
        this.node = node;
        this.name = node.getStringValue(new Object[]{"name"});
        this.artifact = node.getStringValue(new Object[]{"artifact"});
        this.maven = node.getStringValue(new Object[]{"maven"});
        this.client = this.getBool(node, "client", true);
        this.server = this.getBool(node, "server", true);
        this._default = this.getBool(node, "default", true);
        this.inject = this.getBool(node, "inject", true);
        if (node.isStringValue(new Object[]{"desc"})) {
            this.desc = node.getStringValue(new Object[]{"desc"});
        }
        if (node.isStringValue(new Object[]{"url"})) {
            this.url = node.getStringValue(new Object[]{"url"});
        }
    }

    private boolean getBool(JsonNode node, String name, boolean _def) {
        if (!node.isBooleanValue(new Object[]{name})) {
            return _def;
        }
        return node.getBooleanValue(new Object[]{name});
    }

    public boolean isValid() {
        return this.name != null && this.artifact != null && this.maven != null;
    }

    public String getName() {
        return this.name;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getMaven() {
        return this.maven;
    }

    public boolean isClient() {
        return this.client;
    }

    public boolean isServer() {
        return this.server;
    }

    public boolean getDefault() {
        return this._default;
    }

    public boolean isInjected() {
        return this.inject;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getURL() {
        return this.url;
    }

    public static boolean saveModListJson(File root, File json, List<OptionalLibrary> libs, Predicate<String> filter) {
        ArrayList artifacts = Lists.newArrayList();
        for (OptionalLibrary lib : libs) {
            if (!filter.apply((Object)lib.getArtifact())) continue;
            artifacts.add(lib.getArtifact());
        }
        if (artifacts.size() == 0) {
            return true;
        }
        File parent = json.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        System.out.println("Saving optional modlist to: " + json);
        StringBuilder buf = new StringBuilder();
        buf.append("{\n");
        buf.append("    \"repositoryRoot\": \"").append(root.getAbsolutePath().replace('\\', '/')).append("\",\n");
        buf.append("    \"modRef\": [\n");
        for (int x = 0; x < artifacts.size(); ++x) {
            buf.append("        \"").append((String)artifacts.get(x)).append('\"');
            if (x < artifacts.size() - 1) {
                buf.append(',');
            }
            buf.append('\n');
        }
        buf.append("    ]\n");
        buf.append("}\n");
        try {
            Files.write((CharSequence)buf.toString(), (File)json, (Charset)Charsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

