/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.File;

public class Artifact {
    private String domain;
    private String name;
    private String version;
    private String classifier = null;
    private String ext = "jar";
    private String path;
    private String file;
    private String descriptor;
    private String memo;

    public Artifact(String descriptor) {
        this.descriptor = descriptor;
        String[] pts = Iterables.toArray(Splitter.on(':').split(descriptor), String.class);
        this.domain = pts[0];
        this.name = pts[1];
        int last = pts.length - 1;
        int idx = pts[last].indexOf(64);
        if (idx != -1) {
            this.ext = pts[last].substring(idx + 1);
            pts[last] = pts[last].substring(0, idx);
        }
        this.version = pts[2];
        if (pts.length > 3) {
            this.classifier = pts[3];
        }
        this.file = this.name + '-' + this.version;
        if (this.classifier != null) {
            this.file = this.file + '-' + this.classifier;
        }
        this.file = this.file + '.' + this.ext;
        this.path = this.domain.replace('.', '/') + '/' + this.name + '/' + this.version + '/' + this.file;
    }

    public File getLocalPath(File base) {
        return new File(base, this.path.replace('/', File.separatorChar));
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getPath() {
        return this.path;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExt() {
        return this.ext;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String v) {
        this.memo = v;
    }

    public String toString() {
        if (this.getMemo() != null) {
            return this.getDescriptor() + "\n    " + this.getMemo();
        }
        return this.getDescriptor();
    }
}

