/*
 * Decompiled with CFR 0.152.
 */
package argo.jdom;

import argo.jdom.AbstractJsonArray;
import argo.jdom.AbstractJsonObject;
import argo.jdom.JsonArray;
import argo.jdom.JsonConstants;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonNumberNode;
import argo.jdom.JsonObject;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonNodeFactories {
    private JsonNodeFactories() {
    }

    public static JsonNode nullNode() {
        return JsonConstants.NULL;
    }

    public static JsonNode trueNode() {
        return JsonConstants.TRUE;
    }

    public static JsonNode falseNode() {
        return JsonConstants.FALSE;
    }

    public static JsonStringNode string(String value) {
        return new JsonStringNode(value);
    }

    public static JsonNode number(String value) {
        return new JsonNumberNode(value);
    }

    public static JsonNode number(BigDecimal value) {
        return new JsonNumberNode(value.toString());
    }

    public static JsonNode number(BigInteger value) {
        return new JsonNumberNode(value.toString());
    }

    public static JsonNode number(long value) {
        return new JsonNumberNode(Long.toString(value));
    }

    public static JsonRootNode array(Iterable<? extends JsonNode> elements) {
        return new JsonArray(elements);
    }

    public static JsonRootNode array(JsonNode ... elements) {
        return JsonNodeFactories.array(Arrays.asList(elements));
    }

    public static JsonRootNode lazyArray(final List<? extends JsonNode> elements) {
        return new AbstractJsonArray(){

            @Override
            public List<JsonNode> getElements() {
                return new AbstractList<JsonNode>(){

                    @Override
                    public JsonNode get(int i) {
                        return (JsonNode)elements.get(i);
                    }

                    @Override
                    public int size() {
                        return elements.size();
                    }
                };
            }
        };
    }

    public static JsonRootNode object(final Map<JsonStringNode, ? extends JsonNode> fields) {
        return new JsonObject((Iterable<JsonField>)new ArrayList<JsonField>(){
            {
                for (Map.Entry entry : fields.entrySet()) {
                    this.add(JsonNodeFactories.field((JsonStringNode)entry.getKey(), (JsonNode)entry.getValue()));
                }
            }
        });
    }

    public static JsonRootNode object(JsonField ... fields) {
        return JsonNodeFactories.object(Arrays.asList(fields));
    }

    public static JsonRootNode object(Iterable<JsonField> fields) {
        return new JsonObject(fields);
    }

    public static JsonRootNode lazyObject(final List<JsonField> fields) {
        return new AbstractJsonObject(){

            @Override
            public Map<JsonStringNode, JsonNode> getFields() {
                final Iterator fieldIterator = fields.iterator();
                return new AbstractMap<JsonStringNode, JsonNode>(){

                    @Override
                    public Set<Map.Entry<JsonStringNode, JsonNode>> entrySet() {
                        return new AbstractSet<Map.Entry<JsonStringNode, JsonNode>>(){

                            @Override
                            public Iterator<Map.Entry<JsonStringNode, JsonNode>> iterator() {
                                return new Iterator<Map.Entry<JsonStringNode, JsonNode>>(){

                                    @Override
                                    public boolean hasNext() {
                                        return fieldIterator.hasNext();
                                    }

                                    @Override
                                    public Map.Entry<JsonStringNode, JsonNode> next() {
                                        JsonField jsonField = (JsonField)fieldIterator.next();
                                        return new AbstractMap.SimpleEntry<JsonStringNode, JsonNode>(jsonField.getName(), jsonField.getValue());
                                    }

                                    @Override
                                    public void remove() {
                                        throw new UnsupportedOperationException("Removal not supported");
                                    }
                                };
                            }

                            @Override
                            public int size() {
                                return fields.size();
                            }
                        };
                    }
                };
            }

            @Override
            public List<JsonField> getFieldList() {
                return Collections.unmodifiableList(fields);
            }
        };
    }

    public static JsonField field(String name, JsonNode value) {
        return new JsonField(JsonNodeFactories.string(name), value);
    }

    public static JsonField field(JsonStringNode name, JsonNode value) {
        return new JsonField(name, value);
    }

    public static JsonNode booleanNode(boolean value) {
        return value ? JsonNodeFactories.trueNode() : JsonNodeFactories.falseNode();
    }
}

