/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class ExtractTeamCityProjectConfigurationTask
extends DefaultTask {
    public ExtractTeamCityProjectConfigurationTask() {
        this.getDestination().convention(this.getProject().getRootProject().getLayout().getProjectDirectory().dir(this.getProject().provider(() -> "./")));
        this.getRequiresCleanWorkspace().convention((Object)true);
        this.setGroup("publishing");
        this.setDescription("Creates (or recreates) a default TeamCity project configuration directory for use with the MinecraftForge TeamCity server.");
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getDestination();

    @Input
    public abstract Property<Boolean> getRequiresCleanWorkspace();

    @TaskAction
    public void run() throws Exception {
        File destDir = (File)this.getDestination().getAsFile().get();
        File teamcityDir = new File(destDir, ".teamcity");
        if (((Boolean)this.getRequiresCleanWorkspace().get()).booleanValue()) {
            ExtractTeamCityProjectConfigurationTask.checkForCleanWorkspace(destDir);
        }
        String fileZip = ExtractTeamCityProjectConfigurationTask.exportResource();
        if (teamcityDir.exists() && !teamcityDir.delete()) {
            throw new IllegalStateException("Could not delete the existing .teamcity project directory!");
        }
        ExtractTeamCityProjectConfigurationTask.extractTeamCityZip(fileZip, destDir);
        this.replaceTeamCityTestProjectIds(destDir);
    }

    private static void extractTeamCityZip(String fileZip, File destDir) throws Exception {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(new FileInputStream(fileZip));
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = ExtractTeamCityProjectConfigurationTask.newFile(destDir, zipEntry);
            if (zipEntry.isDirectory()) {
                if (!newFile.isDirectory() && !newFile.mkdirs()) {
                    throw new IOException("Failed to create directory " + newFile);
                }
            } else {
                int len;
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + parent);
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String exportResource() throws Exception {
        String jarFolder;
        InputStream stream = null;
        OutputStream resStreamOut = null;
        try {
            int readBytes;
            stream = ExtractTeamCityProjectConfigurationTask.class.getResourceAsStream("/.teamcity.zip");
            if (stream == null) {
                throw new Exception("Cannot get resource \".teamcity.zip\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            jarFolder = new File(ExtractTeamCityProjectConfigurationTask.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getPath().replace('\\', '/');
            resStreamOut = new FileOutputStream(jarFolder + ".teamcity.zip");
            while ((readBytes = stream.read(buffer)) > 0) {
                resStreamOut.write(buffer, 0, readBytes);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
            if (resStreamOut != null) {
                resStreamOut.close();
            }
        }
        return jarFolder + ".teamcity.zip";
    }

    private static File newFile(File destinationDir, ZipEntry zipEntry) throws Exception {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    private void replaceTeamCityTestProjectIds(File projectDir) throws Exception {
        String projectId = ExtractTeamCityProjectConfigurationTask.determineGitHubProjectName(projectDir);
        File teamcityDir = new File(projectDir, ".teamcity");
        if (!teamcityDir.exists()) {
            return;
        }
        for (File file : Objects.requireNonNull(teamcityDir.listFiles())) {
            String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            content = content.replaceAll("TeamCityTest", projectId);
            content = content.replaceAll("tctArtifactId", this.determineArtifactId(projectId));
            content = content.replaceAll("tctGroup", this.determineGroup(this.getProject().getGroup().toString()));
            Files.write(file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    private String determineArtifactId(String projectId) {
        return ((PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class)).getPublications().stream().filter(MavenPublication.class::isInstance).map(MavenPublication.class::cast).filter(publication -> !publication.getName().contains("PluginMarker")).findFirst().map(MavenPublication::getArtifactId).orElseGet(() -> {
            this.getProject().getLogger().warn("Could not find the Maven artifact Id from normal publication falling back to the lower cased project name.");
            return projectId.toLowerCase();
        });
    }

    private String determineGroup(String fallback) {
        return ((PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class)).getPublications().stream().filter(MavenPublication.class::isInstance).map(MavenPublication.class::cast).filter(publication -> !publication.getName().contains("PluginMarker")).findFirst().map(MavenPublication::getGroupId).orElseGet(() -> {
            this.getProject().getLogger().warn("Could not find the Maven artifact Id from normal publication falling back to the lower cased project group.");
            return fallback.toLowerCase();
        });
    }

    private static String determineGitHubProjectName(File projectDir) throws Exception {
        Git git = Git.open((File)projectDir);
        String repositoryPath = ((URIish)((RemoteConfig)git.remoteList().call().get(0)).getURIs().get(0)).getPath();
        return repositoryPath.substring(repositoryPath.lastIndexOf("/") + 1).replace(".git", "");
    }

    private static void checkForCleanWorkspace(File projectDir) throws Exception {
        Git git = Git.open((File)projectDir);
        Status status = git.status().call();
        if (!status.isClean()) {
            throw new Exception("Workspace is not clean. Please commit your changes and try again.");
        }
    }
}

