/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.base.Splitter;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.specs.Spec;

public class Artifact
implements ArtifactIdentifier,
Comparable<Artifact>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String group;
    private final String name;
    private final String version;
    @Nullable
    private final String classifier;
    @Nullable
    private final String ext;
    private final transient String path;
    private final transient String file;
    private final transient String fullDescriptor;
    private final transient ComparableVersion comparableVersion;
    private final transient boolean isSnapshot;

    public static Artifact from(String descriptor) {
        String ext = null;
        String classifier = null;
        String[] pts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)descriptor), String.class);
        String group = pts[0];
        String name = pts[1];
        int last = pts.length - 1;
        int idx = pts[last].indexOf(64);
        if (idx != -1) {
            ext = pts[last].substring(idx + 1);
            pts[last] = pts[last].substring(0, idx);
        }
        String version = pts[2];
        if (pts.length > 3) {
            classifier = pts[3];
        }
        return new Artifact(group, name, version, classifier, ext);
    }

    public static Artifact from(ArtifactIdentifier identifier) {
        return new Artifact(identifier.getGroup(), identifier.getName(), identifier.getVersion(), identifier.getClassifier(), identifier.getExtension());
    }

    public static Artifact from(String group, String name, String version, @Nullable String classifier, @Nullable String ext) {
        return new Artifact(group, name, version, classifier, ext);
    }

    Artifact(String group, String name, String version, @Nullable String classifier, @Nullable String ext) {
        this.group = group;
        this.name = name;
        this.version = version;
        this.comparableVersion = new ComparableVersion(this.version);
        this.isSnapshot = this.version.toLowerCase(Locale.ROOT).endsWith("-snapshot");
        this.classifier = classifier;
        this.ext = ext != null ? ext : "jar";
        StringBuilder buf = new StringBuilder();
        buf.append(this.group).append(':').append(this.name).append(':').append(this.version);
        if (this.classifier != null) {
            buf.append(':').append(this.classifier);
        }
        if (ext != null && !"jar".equals(this.ext)) {
            buf.append('@').append(this.ext);
        }
        this.fullDescriptor = buf.toString();
        String file = this.name + '-' + this.version;
        if (this.classifier != null) {
            file = file + '-' + this.classifier;
        }
        this.file = file = file + '.' + this.ext;
        this.path = String.join((CharSequence)"/", this.group.replace('.', '/'), this.name, this.version, this.file);
    }

    public String getLocalPath() {
        return this.path.replace('/', File.separatorChar);
    }

    public String getDescriptor() {
        return this.fullDescriptor;
    }

    public String getPath() {
        return this.path;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Nullable
    public String getExtension() {
        return this.ext;
    }

    public String getFilename() {
        return this.file;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public Artifact withVersion(String version) {
        return Artifact.from(this.group, this.name, version, this.classifier, this.ext);
    }

    public String toString() {
        return this.getDescriptor();
    }

    public Spec<Dependency> asDependencySpec() {
        return dep -> this.group.equals(dep.getGroup()) && this.name.equals(dep.getName()) && this.version.equals(dep.getVersion());
    }

    public Predicate<ResolvedArtifact> asArtifactMatcher() {
        return art -> {
            String theirClassifier = art.getClassifier() == null ? "" : art.getClassifier();
            String theirExt = art.getExtension().isEmpty() ? "jar" : art.getExtension();
            return !(this.classifier != null && !this.classifier.equals(theirClassifier) || this.ext != null && !this.ext.equals(theirExt));
        };
    }

    @Override
    public int compareTo(Artifact o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.group), (Comparable)((Object)o.group)).compare((Comparable)((Object)this.name), (Comparable)((Object)o.name)).compare((Comparable)this.comparableVersion, (Comparable)o.comparableVersion).compare((Object)this.classifier, (Object)o.classifier, Comparator.nullsFirst(Comparator.naturalOrder())).compare((Object)this.ext, (Object)o.ext, Comparator.nullsFirst(Comparator.naturalOrder())).result();
    }
}

