/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.TaskAction;

public abstract class ExtractExistingFiles
extends DefaultTask {
    @TaskAction
    public void run() throws IOException {
        try (ZipFile zip = new ZipFile(((RegularFile)this.getArchive().get()).getAsFile());){
            Enumeration<? extends ZipEntry> enu = zip.entries();
            while (enu.hasMoreElements()) {
                ZipEntry e = enu.nextElement();
                if (e.isDirectory()) continue;
                for (File target : this.getTargets()) {
                    File out = new File(target, e.getName());
                    if (!out.exists()) continue;
                    FileOutputStream fos = new FileOutputStream(out);
                    Throwable throwable = null;
                    try {
                        IOUtils.copy((InputStream)zip.getInputStream(e), (OutputStream)fos);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
            }
        }
    }

    @InputFile
    public abstract RegularFileProperty getArchive();

    @OutputDirectories
    public abstract ConfigurableFileCollection getTargets();
}

