/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraftforge.gradle.common.config.Config;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.io.IOUtils;

public class MCPConfigV2
extends MCPConfigV1 {
    private boolean official = false;
    private int java_target = 8;
    @Nullable
    private String encoding = "UTF-8";

    public static MCPConfigV2 get(InputStream stream) {
        return Utils.fromJson(stream, MCPConfigV2.class);
    }

    public static MCPConfigV2 get(byte[] data) {
        return MCPConfigV2.get(new ByteArrayInputStream(data));
    }

    public static MCPConfigV2 getFromArchive(File path) throws IOException {
        Throwable throwable = null;
        try (ZipFile zip = new ZipFile(path);){
            ZipEntry entry = zip.getEntry("config.json");
            if (entry == null) {
                throw new IllegalStateException("Could not find 'config.json' in " + path.getAbsolutePath());
            }
            byte[] data = IOUtils.toByteArray((InputStream)zip.getInputStream(entry));
            int spec = Config.getSpec(data);
            if (spec == 2) {
                MCPConfigV2 mCPConfigV2 = MCPConfigV2.get(data);
                return mCPConfigV2;
            }
            if (spec == 1) {
                MCPConfigV2 mCPConfigV2 = new MCPConfigV2(MCPConfigV1.get(data));
                return mCPConfigV2;
            }
            try {
                throw new IllegalStateException("Invalid MCP Config: " + path.getAbsolutePath() + " Unknown spec: " + spec);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public boolean isOfficial() {
        return this.official;
    }

    public int getJavaTarget() {
        return this.java_target;
    }

    public String getEncoding() {
        return this.encoding == null ? "UTF-8" : this.encoding;
    }

    public MCPConfigV2(MCPConfigV1 old) {
        this.version = old.version;
        this.data = old.data;
        this.steps = old.steps;
        this.functions = old.functions;
        this.libraries = old.libraries;
    }
}

