/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.jarjar;

import groovy.lang.GroovyObjectSupport;
import groovy.util.Node;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.gradle.userdev.DependencyManagementExtension;
import net.minecraftforge.gradle.userdev.dependency.DependencyFilter;
import net.minecraftforge.gradle.userdev.dependency.DependencyVersionInformationHandler;
import net.minecraftforge.gradle.userdev.tasks.JarJar;
import net.minecraftforge.gradle.userdev.util.MavenPomUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.publish.maven.MavenPublication;

public class JarJarProjectExtension
extends GroovyObjectSupport {
    public static final String EXTENSION_NAME = "jarJar";
    private final Attribute<String> fixedJarJarVersionAttribute = Attribute.of((String)"fixedJarJarVersion", String.class);
    private final Attribute<String> jarJarRangeAttribute = Attribute.of((String)"jarJarRange", String.class);
    private final Project project;
    private boolean disabled;
    private boolean disableDefaultSources;

    public JarJarProjectExtension(Project project) {
        this.project = project;
    }

    public void enable() {
        if (!this.disabled) {
            this.enable(true);
        }
    }

    private void enable(boolean enabled) {
        Task task = this.project.getTasks().findByPath(EXTENSION_NAME);
        if (task != null) {
            task.setEnabled(enabled);
        }
    }

    public void disable() {
        this.disable(true);
    }

    public void disable(boolean disable) {
        this.disabled = disable;
        if (disable) {
            this.enable(false);
        }
    }

    public boolean getDefaultSourcesDisabled() {
        return this.disableDefaultSources;
    }

    public void disableDefaultSources() {
        this.disableDefaultSources(true);
    }

    public void disableDefaultSources(boolean value) {
        this.disableDefaultSources = value;
    }

    public void fromRuntimeConfiguration() {
        this.enable();
        this.project.getTasks().withType(JarJar.class).configureEach(JarJar::fromRuntimeConfiguration);
    }

    public void pin(Dependency dependency, String version) {
        this.enable();
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            moduleDependency.attributes(attributeContainer -> attributeContainer.attribute(this.fixedJarJarVersionAttribute, (Object)version));
        }
    }

    public Optional<String> getPin(Dependency dependency) {
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            return Optional.ofNullable(moduleDependency.getAttributes().getAttribute(this.fixedJarJarVersionAttribute));
        }
        return Optional.empty();
    }

    public void ranged(Dependency dependency, String range) {
        this.enable();
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            moduleDependency.attributes(attributeContainer -> attributeContainer.attribute(this.jarJarRangeAttribute, (Object)range));
        }
    }

    public Optional<String> getRange(Dependency dependency) {
        if (dependency instanceof ModuleDependency) {
            ModuleDependency moduleDependency = (ModuleDependency)dependency;
            return Optional.ofNullable(moduleDependency.getAttributes().getAttribute(this.jarJarRangeAttribute));
        }
        return Optional.empty();
    }

    public JarJarProjectExtension dependencies(Action<DependencyFilter> c) {
        this.enable();
        this.project.getTasks().withType(JarJar.class).configureEach(jarJar -> jarJar.dependencies(c));
        return this;
    }

    public JarJarProjectExtension versionInformation(Action<DependencyVersionInformationHandler> c) {
        this.enable();
        this.project.getTasks().withType(JarJar.class).configureEach(jarJar -> jarJar.versionInformation(c));
        return this;
    }

    public MavenPublication component(MavenPublication mavenPublication) {
        this.enable();
        ((DependencyManagementExtension)((Object)this.project.getExtensions().getByType(DependencyManagementExtension.class))).component(mavenPublication);
        this.project.getTasks().withType(JarJar.class).configureEach(task -> this.component(mavenPublication, (JarJar)((Object)task), false));
        return mavenPublication;
    }

    public MavenPublication component(MavenPublication mavenPublication, boolean handleDependencies) {
        this.enable();
        ((DependencyManagementExtension)((Object)this.project.getExtensions().getByType(DependencyManagementExtension.class))).component(mavenPublication);
        this.project.getTasks().withType(JarJar.class).configureEach(task -> this.component(mavenPublication, (JarJar)((Object)task), false));
        return mavenPublication;
    }

    public MavenPublication component(MavenPublication mavenPublication, JarJar task) {
        this.enable();
        return this.component(mavenPublication, task, true, true);
    }

    public MavenPublication cleanedComponent(MavenPublication mavenPublication, JarJar task, boolean handleDependencies) {
        this.enable();
        return this.component(mavenPublication, task, true, handleDependencies);
    }

    private MavenPublication component(MavenPublication mavenPublication, JarJar task, boolean handleCleaning) {
        return this.component(mavenPublication, task, handleCleaning, true);
    }

    private MavenPublication component(MavenPublication mavenPublication, JarJar task, boolean handleCleaning, boolean handleDependencies) {
        if (!task.isEnabled()) {
            return mavenPublication;
        }
        if (handleCleaning) {
            ((DependencyManagementExtension)((Object)this.project.getExtensions().getByType(DependencyManagementExtension.class))).component(mavenPublication);
        }
        mavenPublication.artifact((Object)task, mavenArtifact -> {
            mavenArtifact.setClassifier((String)task.getArchiveClassifier().get());
            mavenArtifact.setExtension((String)task.getArchiveExtension().get());
        });
        if (handleDependencies) {
            Set<ResolvedDependency> dependencies = task.getResolvedDependencies();
            mavenPublication.pom(pom -> pom.withXml(xml -> {
                Node dependenciesNode = MavenPomUtils.getDependenciesNode(xml);
                List<Node> dependenciesNodeList = MavenPomUtils.getDependencyNodes(xml);
                dependencies.forEach(dependency -> dependenciesNodeList.stream().filter(el -> MavenPomUtils.hasChildWithText(el, "{http://maven.apache.org/POM/4.0.0}artifactId", dependency.getModuleName()) && MavenPomUtils.hasChildWithText(el, "{http://maven.apache.org/POM/4.0.0}groupId", dependency.getModuleGroup())).forEach(el -> MavenPomUtils.setChildText(el, "{http://maven.apache.org/POM/4.0.0}version", dependency.getModuleVersion())));
                dependencies.stream().filter(dependency -> dependenciesNodeList.stream().noneMatch(el -> MavenPomUtils.hasChildWithText(el, "{http://maven.apache.org/POM/4.0.0}artifactId", dependency.getModuleName()) && MavenPomUtils.hasChildWithText(el, "{http://maven.apache.org/POM/4.0.0}groupId", dependency.getModuleGroup()))).forEach(it -> {
                    Node dependencyNode = dependenciesNode.appendNode((Object)"dependency");
                    dependencyNode.appendNode((Object)"groupId", (Object)it.getModuleGroup());
                    dependencyNode.appendNode((Object)"artifactId", (Object)it.getModuleName());
                    dependencyNode.appendNode((Object)"version", (Object)it.getModuleVersion());
                    dependencyNode.appendNode((Object)"scope", (Object)"runtime");
                });
            }));
        }
        return mavenPublication;
    }
}

