/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import net.minecraftforge.artifactural.api.repository.ArtifactProvider;
import net.minecraftforge.artifactural.api.repository.Repository;
import net.minecraftforge.artifactural.base.repository.ArtifactProviderBuilder;
import net.minecraftforge.artifactural.base.repository.SimpleRepository;
import net.minecraftforge.gradle.common.config.Config;
import net.minecraftforge.gradle.common.config.MCPConfigV2;
import net.minecraftforge.gradle.common.config.UserdevConfigV1;
import net.minecraftforge.gradle.common.config.UserdevConfigV2;
import net.minecraftforge.gradle.common.tasks.ApplyBinPatches;
import net.minecraftforge.gradle.common.tasks.DownloadAssets;
import net.minecraftforge.gradle.common.tasks.DynamicJarExec;
import net.minecraftforge.gradle.common.tasks.ExtractMCPData;
import net.minecraftforge.gradle.common.tasks.ExtractNatives;
import net.minecraftforge.gradle.common.tasks.JarExec;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.common.util.POMBuilder;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.function.MCPFunctionFactory;
import net.minecraftforge.gradle.mcp.tasks.GenerateSRG;
import net.minecraftforge.gradle.mcp.util.MCPRuntime;
import net.minecraftforge.gradle.mcp.util.MCPWrapper;
import net.minecraftforge.gradle.userdev.tasks.AccessTransformJar;
import net.minecraftforge.gradle.userdev.tasks.ApplyMCPFunction;
import net.minecraftforge.gradle.userdev.tasks.HackyJavaCompile;
import net.minecraftforge.gradle.userdev.tasks.RenameJar;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import net.minecraftforge.srgutils.MinecraftVersion;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public class MinecraftUserRepo
extends BaseRepo {
    public static final boolean CHANGING_USERDEV = false;
    private static final MinecraftVersion v1_13 = MinecraftVersion.from((String)"1.13");
    private final Project project;
    private final String GROUP;
    private final String NAME;
    private final String VERSION;
    private final List<File> ATS;
    @Nullable
    private final String AT_HASH;
    private final String MAPPING;
    private final boolean isPatcher;
    private final Map<String, McpNames> mapCache = new HashMap<String, McpNames>();
    private boolean loadedParents = false;
    private Patcher parent;
    @Nullable
    private MCP mcp;
    private Repository repo;
    private Set<File> extraDataFiles;
    private int compileTaskCount = 1;

    public MinecraftUserRepo(Project project, String group, String name, String version, List<File> ats, String mapping) {
        super(Utils.getCache(project, "minecraft_user_repo"), project.getLogger());
        this.project = project;
        this.GROUP = group;
        this.NAME = name;
        this.VERSION = version;
        this.ATS = ats.stream().filter(File::exists).collect(Collectors.toList());
        try {
            this.AT_HASH = this.ATS.isEmpty() ? null : HashFunction.SHA1.hash(this.ATS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.MAPPING = mapping;
        this.isPatcher = !"net.minecraft".equals(this.GROUP);
        this.repo = SimpleRepository.of((ArtifactProvider)ArtifactProviderBuilder.begin(ArtifactIdentifier.class).filter(ArtifactIdentifier.groupEquals((String)this.GROUP)).filter(ArtifactIdentifier.nameEquals((String)this.NAME)).provide((ArtifactProvider)this));
    }

    @Override
    protected File getCacheRoot() {
        if (this.AT_HASH == null) {
            return super.getCacheRoot();
        }
        return this.project.file((Object)"build/fg_cache/");
    }

    public void validate(Configuration cfg, Map<String, RunConfig> runs, ExtractNatives extractNatives, DownloadAssets downloadAssets, GenerateSRG createSrgToMcp) {
        this.getParents();
        if (this.mcp == null) {
            throw new IllegalStateException("Invalid minecraft dependency: " + this.GROUP + ":" + this.NAME + ":" + this.VERSION);
        }
        ExtraPropertiesExtension ext = this.project.getExtensions().getExtraProperties();
        ext.set("MC_VERSION", (Object)this.mcp.getMCVersion());
        ext.set("MCP_VERSION", (Object)this.mcp.getArtifact().getVersion());
        Property languageVersion = ((JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion();
        int setVersion = (Integer)languageVersion.map(JavaLanguageVersion::asInt).getOrElse((Object)0);
        int javaTarget = this.mcp.wrapper.getConfig().getJavaTarget();
        if (setVersion != 0 && setVersion < javaTarget) {
            throw new IllegalArgumentException("The java toolchain language version of " + setVersion + " is below the required minimum of " + javaTarget + ".\nYou must have a line which looks like this in your buildscript:\n    java.toolchain.languageVersion = JavaLanguageVersion.of(" + javaTarget + ")");
        }
        for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
            patcher.getLibraries().stream().map(Artifact::from).filter(e -> this.GROUP.equals(e.getGroup()) && this.NAME.equals(e.getName())).forEach(e -> {
                String dep = this.getDependencyString();
                if (e.getClassifier() != null) {
                    dep = dep + ":" + e.getClassifier();
                    if (e.getClassifier().indexOf(46) != -1) {
                        throw new IllegalArgumentException("Can not set Minecraft dependency with classifier containing '.'");
                    }
                }
                if (e.getExtension() != null && !"jar".equals(e.getExtension())) {
                    dep = dep + "@" + e.getExtension();
                }
                this.debug("    New Self Dep: " + dep);
                ExternalModuleDependency _dep = (ExternalModuleDependency)this.project.getDependencies().create((Object)dep);
                cfg.getDependencies().add((Object)_dep);
            });
        }
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("assets_root", downloadAssets.getOutput().getAbsolutePath());
        tokens.put("natives", ((Directory)extractNatives.getOutput().get()).getAsFile().getAbsolutePath());
        tokens.put("mc_version", this.mcp.getMCVersion());
        tokens.put("mcp_version", this.mcp.getArtifact().getVersion());
        tokens.put("mcp_mappings", this.MAPPING);
        tokens.put("mcp_to_srg", ((RegularFile)createSrgToMcp.getOutput().get()).getAsFile().getAbsolutePath());
        if (this.parent != null && !this.parent.getModules().isEmpty()) {
            Configuration modulesCfg = (Configuration)this.project.getConfigurations().create("modules_userdev_resolver");
            modulesCfg.setCanBeResolved(true);
            this.parent.getModules().forEach(m -> modulesCfg.getDependencies().add((Object)this.project.getDependencies().create(m)));
            tokens.put("modules", modulesCfg.resolve().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        }
        if (this.parent != null && this.parent.getConfig().runs != null) {
            this.parent.getConfig().runs.forEach((name, dev) -> {
                RunConfig run = (RunConfig)runs.get(name);
                if (run != null) {
                    run.parent(0, (RunConfig)dev);
                }
            });
        }
        runs.forEach((name, run) -> run.tokens(tokens));
        this.extraDataFiles = this.buildExtraDataFiles();
    }

    private Set<File> buildExtraDataFiles() {
        Configuration cfg = (Configuration)this.project.getConfigurations().create(this.getNextTaskName("compileJava"));
        ArrayList<String> deps = new ArrayList<String>();
        deps.add("net.minecraft:client:" + this.mcp.getMCVersion() + ":extra");
        deps.addAll(this.mcp.getLibraries());
        for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
            deps.addAll(patcher.getLibraries());
        }
        deps.forEach(dep -> cfg.getDependencies().add((Object)this.project.getDependencies().create(dep)));
        return cfg.resolve();
    }

    private File cacheRaw(String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.VERSION, this.NAME + '-' + this.VERSION + '.' + ext);
    }

    private File cacheRaw(String classifier, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.VERSION, this.NAME + '-' + this.VERSION + '-' + classifier + '.' + ext);
    }

    private File cacheMapped(@Nullable String mapping, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.getVersion(mapping), this.NAME + '-' + this.getVersion(mapping) + '.' + ext);
    }

    private File cacheMapped(@Nullable String mapping, String classifier, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.getVersion(mapping), this.NAME + '-' + this.getVersion(mapping) + '-' + classifier + '.' + ext);
    }

    private File cacheAT(String classifier, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.getVersionAT(), this.NAME + '-' + this.getVersionAT() + '-' + classifier + '.' + ext);
    }

    public String getDependencyString() {
        String ret = this.GROUP + ':' + this.NAME + ':' + this.VERSION;
        if (this.MAPPING != null) {
            ret = ret + "_mapped_" + this.MAPPING;
        }
        if (this.AT_HASH != null) {
            ret = ret + "_at_" + this.AT_HASH;
        }
        return ret;
    }

    @Nullable
    private String getATHash(String version) {
        if (!version.contains("_at_")) {
            return null;
        }
        return version.split("_at_")[1];
    }

    @Nullable
    private String getMappings(String version) {
        if (!version.contains("_mapped_")) {
            return null;
        }
        return version.split("_mapped_")[1];
    }

    private String getVersion(@Nullable String mappings) {
        return mappings == null ? this.VERSION : this.VERSION + "_mapped_" + mappings;
    }

    private String getVersionWithAT(@Nullable String mappings) {
        if (this.AT_HASH == null) {
            return this.getVersion(mappings);
        }
        return this.getVersion(mappings) + "_at_" + this.AT_HASH;
    }

    private String getVersionAT() {
        if (this.AT_HASH == null) {
            return this.VERSION;
        }
        return this.VERSION + "_at_" + this.AT_HASH;
    }

    private Patcher getParents() {
        if (!this.loadedParents) {
            MinecraftVersion mcver;
            String classifier = "userdev";
            if ("net.minecraftforge".equals(this.GROUP) && "forge".equals(this.NAME) && (mcver = MinecraftVersion.from((String)this.VERSION.split("-")[0])).compareTo(v1_13) < 0) {
                classifier = "userdev3";
            }
            String artifact = this.isPatcher ? this.GROUP + ":" + this.NAME + ":" + this.VERSION + ':' + classifier : "de.oceanlabs.mcp:mcp_config:" + this.VERSION + "@zip";
            boolean patcher = this.isPatcher;
            Patcher last = null;
            while (artifact != null) {
                this.debug("    Parent: " + artifact);
                File dep = MavenArtifactDownloader.manual(this.project, artifact, false);
                if (dep == null) {
                    throw new IllegalStateException("Could not resolve dependency: " + artifact);
                }
                if (patcher) {
                    Patcher _new = new Patcher(this.project, dep, artifact);
                    if (this.parent == null) {
                        this.parent = _new;
                    }
                    if (last != null) {
                        last.setParent(_new);
                    }
                    last = _new;
                    patcher = !_new.parentIsMcp();
                    artifact = _new.getParentDesc();
                    continue;
                }
                this.mcp = new MCP(dep, artifact);
                break;
            }
            this.loadedParents = this.mcp != null;
        }
        return this.parent;
    }

    @Override
    public File findFile(ArtifactIdentifier artifact) throws IOException {
        String mappings;
        String version;
        String athash;
        String group = artifact.getGroup();
        String rand = "";
        if (group.startsWith("rnd.")) {
            rand = group.substring(0, group.indexOf(46, 4));
            group = group.substring(group.indexOf(46, 4) + 1);
        }
        if ((athash = this.getATHash(version = artifact.getVersion())) != null) {
            version = version.substring(0, version.length() - (athash.length() + "_at_".length()));
        }
        if ((mappings = this.getMappings(version)) != null) {
            version = version.substring(0, version.length() - (mappings.length() + "_mapped_".length()));
        }
        if (!(group.equals(this.GROUP) && artifact.getName().equals(this.NAME) && version.equals(this.VERSION))) {
            return null;
        }
        if (this.AT_HASH == null && athash != null || this.AT_HASH != null && !this.AT_HASH.equals(athash)) {
            return null;
        }
        if (!this.isPatcher && mappings == null) {
            return null;
        }
        String classifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
        String ext = artifact.getExtension();
        this.debug("  " + this.REPO_NAME + " Request: " + artifact.getGroup() + ":" + artifact.getName() + ":" + version + ":" + classifier + "@" + ext + " Mapping: " + mappings);
        if ("pom".equals(ext)) {
            return this.findPom(mappings, rand);
        }
        switch (classifier) {
            case "": {
                return this.findRaw(mappings);
            }
            case "sources": {
                return this.findSource(mappings, true);
            }
        }
        return this.findExtraClassifier(mappings, classifier, ext);
    }

    private HashStore commonHash(@Nullable File mapping) {
        this.getParents();
        HashStore ret = new HashStore(this.getCacheRoot());
        ret.add(this.mcp.artifact.getDescriptor(), this.mcp.getZip());
        for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
            ret.add(this.parent.artifact.getDescriptor(), this.parent.data);
        }
        if (mapping != null) {
            ret.add("mapping", mapping);
        }
        if (this.AT_HASH != null) {
            ret.add("ats", this.AT_HASH);
        }
        return ret;
    }

    @Nullable
    private File findMapping(@Nullable String mapping) {
        if (mapping == null) {
            this.debug("  FindMappings: Null mappings");
            return null;
        }
        int idx = mapping.lastIndexOf(95);
        String channel = mapping.substring(0, idx);
        String version = mapping.substring(idx + 1);
        String desc = MCPRepo.getMappingDep(channel, version);
        this.debug("    Mapping: " + desc);
        File ret = MavenArtifactDownloader.generate(this.project, desc, false);
        if (ret == null) {
            String message = "Could not download MCP Mappings: " + desc;
            this.debug("    " + message);
            this.project.getLogger().error(message);
            throw new IllegalStateException(message);
        }
        return ret;
    }

    @Nullable
    private File findPom(@Nullable String mapping, String rand) throws IOException {
        HashStore cache;
        this.getParents();
        if (this.mcp == null || mapping == null) {
            this.debug("  Finding Pom: MCP or Mappings were null");
            return null;
        }
        File pom = this.cacheMapped(mapping, "pom");
        if (!rand.isEmpty()) {
            rand = rand + '.';
            pom = this.cacheMapped(mapping, rand + "pom");
        }
        if ((cache = this.commonHash(null).load(new File(pom.getAbsolutePath() + ".input"))).isSame() && pom.exists()) {
            this.debug("  Finding Pom: Cache Hit");
        } else {
            this.debug("  Finding Pom: " + pom);
            POMBuilder builder = new POMBuilder(rand + this.GROUP, this.NAME, this.getVersionWithAT(mapping));
            builder.dependencies().add("net.minecraft:client:" + this.mcp.getMCVersion() + ":extra", "compile");
            this.mcp.getLibraries().forEach(e -> builder.dependencies().add((String)e, "compile"));
            if (mapping != null) {
                int idx = mapping.lastIndexOf(95);
                String channel = mapping.substring(0, idx);
                String version = mapping.substring(idx + 1);
                builder.dependencies().add(MCPRepo.getMappingDep(channel, version), "runtime");
            }
            for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                for (String lib : patcher.getLibraries()) {
                    Artifact af = Artifact.from(lib);
                    if (this.GROUP.equals(af.getGroup()) && this.NAME.equals(af.getName()) && this.VERSION.equals(af.getVersion())) {
                        builder.dependencies().add(rand + this.GROUP, this.NAME, this.getVersionWithAT(mapping), af.getClassifier(), af.getExtension(), "compile");
                        continue;
                    }
                    builder.dependencies().add(lib, "compile");
                }
            }
            String ret = builder.tryBuild();
            if (ret == null) {
                return null;
            }
            FileUtils.writeByteArrayToFile((File)pom, (byte[])ret.getBytes(StandardCharsets.UTF_8));
            cache.save();
            Utils.updateHash(pom, HashFunction.SHA1);
        }
        return pom;
    }

    private File findBinPatches() throws IOException {
        File ret = this.cacheRaw("binpatches", "lzma");
        HashStore cache = new HashStore().load(this.cacheRaw("binpatches", "lzma.input")).add("parent", this.parent.getZip());
        if (cache.isSame() && ret.exists()) {
            this.debug("  FindBinPatches: Cache Hit");
        } else {
            this.debug("  FindBinPatches: Extracting to " + ret);
            try (ZipFile zip = new ZipFile(this.parent.getZip());){
                Utils.extractFile(zip, this.parent.getConfig().binpatches, ret);
                cache.save();
            }
        }
        return ret;
    }

    @Nullable
    private File findRaw(@Nullable String mapping) throws IOException {
        File names = this.findMapping(mapping);
        HashStore cache = this.commonHash(names).add("codever", "3");
        if (mapping != null && names == null) {
            this.debug("  Finding Raw: Could not find names, exiting");
            return null;
        }
        File recomp = this.findRecomp(mapping, false);
        if (recomp != null) {
            this.debug("  Finding Raw: Returning Recomp: " + recomp);
            return recomp;
        }
        if (mapping == null && this.parent == null) {
            this.debug("  Finding Raw: Userdev does not provide SRG Minecraft");
            return null;
        }
        File bin = this.cacheMapped(mapping, "jar");
        cache.load(this.cacheMapped(mapping, "jar.input"));
        if (cache.isSame() && bin.exists()) {
            this.debug("  Finding Raw: Cache Hit: " + bin);
        } else {
            ZipEntry entry;
            Throwable throwable;
            File mcinject;
            this.debug("  Finding Raw: Cache Miss");
            StringBuilder baseAT = new StringBuilder();
            Patcher patcher = this.parent;
            while (patcher != null) {
                if (patcher.getATData() != null && !patcher.getATData().isEmpty()) {
                    if (baseAT.length() != 0) {
                        baseAT.append("\n===========================================================\n");
                    }
                    baseAT.append(patcher.getATData());
                }
                patcher = patcher.parent;
            }
            boolean hasAts = baseAT.length() != 0 || !this.ATS.isEmpty();
            this.debug("    HasAts: " + hasAts);
            HashSet<String> packages = new HashSet<String>();
            File srged = this.findBinpatched(packages);
            if (this.mcp.wrapper.getConfig().isOfficial()) {
                mcinject = srged;
            } else {
                mcinject = this.cacheRaw("mci", "jar");
                this.debug("    Applying MCInjector");
                ApplyMCPFunction mci = this.createTask("mciJar", ApplyMCPFunction.class);
                mci.getFunctionName().set((Object)"mcinject");
                mci.setHasLog(false);
                mci.getInput().set(srged);
                mci.getMCP().set(this.mcp.getZip());
                mci.getOutput().set(mcinject);
                mci.apply();
            }
            this.debug("    Creating MCP Inject Sources");
            File inject_src = this.cacheRaw("inject_src", "jar");
            if (!inject_src.getParentFile().exists() && !inject_src.getParentFile().mkdirs()) {
                throw new RuntimeException("Could not create directory: " + inject_src.getParentFile().getAbsolutePath());
            }
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(this.mcp.getZip()));){
                throwable = null;
                try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(inject_src));){
                    String prefix = this.mcp.wrapper.getConfig().getData("inject");
                    String template = null;
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().startsWith(prefix) || entry.isDirectory() || "server".equals(this.NAME) && entry.getName().contains("/client/") || "client".equals(this.NAME) && entry.getName().contains("/server/")) continue;
                        String name = entry.getName().substring(prefix.length());
                        if ("package-info-template.java".equals(name)) {
                            template = new String(IOUtils.toByteArray((InputStream)zin), StandardCharsets.UTF_8);
                            continue;
                        }
                        zos.putNextEntry(Utils.getStableEntry(name));
                        IOUtils.copy((InputStream)zin, (OutputStream)zos);
                        zos.closeEntry();
                    }
                    if (template != null) {
                        for (String pkg : packages) {
                            zos.putNextEntry(Utils.getStableEntry(pkg + "/package-info.java"));
                            zos.write(template.replace("{PACKAGE}", pkg.replace("/", ".")).getBytes(StandardCharsets.UTF_8));
                            zos.closeEntry();
                        }
                    }
                }
                catch (Throwable prefix) {
                    throwable = prefix;
                    throw prefix;
                }
            }
            this.debug("    Compiling MCP Inject sources");
            final File compiled = this.compileJava(inject_src, mcinject);
            if (compiled == null) {
                return null;
            }
            this.debug("    Injecting MCP Inject binairies");
            File injected = this.cacheRaw("injected", "jar");
            throwable = null;
            try (ZipInputStream zmci = new ZipInputStream(new FileInputStream(mcinject));
                 final ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(injected));){
                entry = null;
                while ((entry = zmci.getNextEntry()) != null) {
                    zout.putNextEntry(Utils.getStableEntry(entry.getName()));
                    IOUtils.copy((InputStream)zmci, (OutputStream)zout);
                    zout.closeEntry();
                }
                Files.walkFileTree(compiled.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        try (InputStream fin = Files.newInputStream(file, new OpenOption[0]);){
                            zout.putNextEntry(Utils.getStableEntry(compiled.toPath().relativize(file).toString().replace('\\', '/')));
                            IOUtils.copy((InputStream)fin, (OutputStream)zout);
                            zout.closeEntry();
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            if (hasAts) {
                if (bin.exists()) {
                    bin.delete();
                }
                this.debug("    Applying Access Transformer");
                AccessTransformJar at = this.createTask("atJar", AccessTransformJar.class);
                at.getInput().set(injected);
                at.getOutput().set(bin);
                at.getAccessTransformers().from(new Object[]{this.ATS});
                if (baseAT.length() != 0) {
                    File parentAT = this.project.file((Object)("build/" + at.getName() + "/parent_at.cfg"));
                    if (!parentAT.getParentFile().exists()) {
                        parentAT.getParentFile().mkdirs();
                    }
                    Files.write(parentAT.toPath(), baseAT.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    at.getAccessTransformers().from(new Object[]{parentAT});
                }
                at.apply();
            }
            this.debug("    Renaming/Fixing " + (hasAts ? "ATed" : "injected") + " jar");
            JarExec rename = this.createTask("renameJar", JarExec.class);
            rename.setHasLog(false);
            rename.getTool().set((Object)"net.minecraftforge:ForgeAutoRenamingTool:0.1.+:all");
            rename.getArgs().empty();
            rename.getArgs().addAll((Object[])new String[]{"--input", (hasAts ? bin : injected).getAbsolutePath()});
            if (!hasAts) {
                rename.getArgs().addAll((Object[])new String[]{"--output", bin.getAbsolutePath()});
            }
            if (mapping != null) {
                rename.getArgs().addAll((Object[])new String[]{"--map", this.findSrgToMcp(mapping, names).getAbsolutePath()});
            }
            rename.getArgs().add((Object)"--src-fix");
            rename.apply();
            this.debug("    Finished: " + bin);
            Utils.updateHash(bin, HashFunction.SHA1);
            cache.save();
        }
        return bin;
    }

    @Nullable
    private File findBinpatched(Set<String> packages) throws IOException {
        boolean notch = this.parent != null && this.parent.getConfigV2() != null && this.parent.getConfigV2().getNotchObf();
        String desc = "net.minecraft:" + (this.isPatcher ? "joined" : this.NAME) + ":" + (notch ? this.mcp.getMCVersion() : this.mcp.getVersion() + ":srg");
        File clean = MavenArtifactDownloader.generate(this.project, desc, true);
        if (clean == null || !clean.exists()) {
            this.debug("  Failed to find MC Vanilla Base: " + desc);
            this.project.getLogger().error("MinecraftUserRepo: Failed to get Minecraft Vanilla Base. Should not be possible. " + desc);
            return null;
        }
        this.debug("    Vanilla Base: " + clean);
        File obf2Srg = null;
        try (ZipFile tmp = new ZipFile(clean);){
            if (notch) {
                obf2Srg = this.findObfToSrg(IMappingFile.Format.TSRG);
                if (obf2Srg == null) {
                    this.debug("  Failed to find obf to mcp mapping file. " + this.mcp.getVersion());
                    this.project.getLogger().error("MinecraftUserRepo: Failed to find obf to mcp mapping file. Should not be possible. " + this.mcp.getVersion());
                    File file = null;
                    return file;
                }
                Set vanillaClasses = tmp.stream().map(ZipEntry::getName).filter(e -> e.endsWith(".class")).map(e -> e.substring(0, e.length() - 6)).collect(Collectors.toSet());
                IMappingFile o2s = IMappingFile.load((File)obf2Srg);
                o2s.getClasses().stream().filter(e -> vanillaClasses.contains(e.getOriginal())).map(IMappingFile.INode::getMapped).map(e -> e.indexOf(47) == -1 ? "" : e.substring(0, e.lastIndexOf(47))).forEach(packages::add);
            } else {
                tmp.stream().map(ZipEntry::getName).filter(e -> e.endsWith(".class")).map(e -> e.indexOf(47) == -1 ? "" : e.substring(0, e.lastIndexOf(47))).forEach(packages::add);
            }
        }
        if (this.parent == null) {
            return clean;
        }
        File binpatched = this.cacheRaw("binpatched", "jar");
        this.debug("    Creating Binpatches");
        ApplyBinPatches apply = this.createTask("applyBinpatches", ApplyBinPatches.class);
        apply.setHasLog(true);
        apply.getTool().set((Object)this.parent.getConfig().binpatcher.getVersion());
        apply.getArgs().set(this.parent.getConfig().binpatcher.getArgs());
        apply.getClean().set(clean);
        apply.getPatch().set(this.findBinPatches());
        apply.getOutput().set(binpatched);
        apply.apply();
        this.debug("    Injecting binpatch extras");
        File merged = this.cacheRaw(notch ? "obf" : "srg", "jar");
        HashSet<String> added = new HashSet<String>();
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(merged));){
            for (File file : new File[]{binpatched, clean}) {
                try (ZipInputStream zin = new ZipInputStream(new FileInputStream(file));){
                    ZipEntry entry;
                    while ((entry = zin.getNextEntry()) != null) {
                        String name = entry.getName();
                        if (added.contains(name)) continue;
                        ZipEntry _new = new ZipEntry(name);
                        _new.setTime(entry.getTime());
                        zip.putNextEntry(_new);
                        IOUtils.copy((InputStream)zin, (OutputStream)zip);
                        added.add(name);
                    }
                }
            }
            this.copyResources(zip, added, true);
        }
        if (notch) {
            File srged = this.cacheRaw("srg", "jar");
            this.debug("    Renaming injected jar");
            RenameJar rename = this.createTask("renameJar", RenameJar.class);
            rename.setHasLog(false);
            rename.getInput().set(merged);
            rename.getOutput().set(srged);
            rename.getMappings().set(obf2Srg);
            rename.apply();
            return srged;
        }
        return merged;
    }

    private void copyResources(ZipOutputStream zip, Set<String> added, boolean includeClasses) throws IOException {
        HashMap<String, List> servicesLists = new HashMap<String, List>();
        Predicate<String> filter = name -> added.contains(name) || !includeClasses && name.endsWith(".class") || name.startsWith("META-INF") && (name.endsWith(".DSA") || name.endsWith(".SF"));
        for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
            ZipEntry _new;
            List existing;
            String name2;
            ZipEntry entry2;
            Throwable throwable;
            ZipInputStream zin;
            if (patcher.getUniversal() != null) {
                zin = new ZipInputStream(new FileInputStream(patcher.getUniversal()));
                throwable = null;
                try {
                    while ((entry2 = zin.getNextEntry()) != null) {
                        name2 = entry2.getName();
                        if (filter.test(name2) || this.parent.getUniversalFilters().stream().anyMatch(f -> !f.matcher(name2).matches())) continue;
                        if (name2.startsWith("META-INF/services/") && !entry2.isDirectory()) {
                            existing = servicesLists.computeIfAbsent(name2, k -> new ArrayList());
                            if (existing.size() > 0) {
                                existing.add("");
                            }
                            existing.add(String.format("# %s - %s", patcher.artifact, patcher.getUniversal().getCanonicalFile().getName()));
                            existing.addAll(IOUtils.readLines((InputStream)zin, (Charset)StandardCharsets.UTF_8));
                            continue;
                        }
                        _new = new ZipEntry(name2);
                        _new.setTime(0L);
                        zip.putNextEntry(_new);
                        IOUtils.copy((InputStream)zin, (OutputStream)zip);
                        added.add(name2);
                    }
                }
                catch (Throwable entry2) {
                    throwable = entry2;
                    throw entry2;
                }
                finally {
                    if (zin != null) {
                        if (throwable != null) {
                            try {
                                zin.close();
                            }
                            catch (Throwable entry2) {
                                throwable.addSuppressed(entry2);
                            }
                        } else {
                            zin.close();
                        }
                    }
                }
            }
            if (patcher.getInject() == null) continue;
            zin = new ZipInputStream(new FileInputStream(patcher.getZip()));
            throwable = null;
            try {
                while ((entry2 = zin.getNextEntry()) != null) {
                    if (!entry2.getName().startsWith(patcher.getInject()) || entry2.getName().length() <= patcher.getInject().length() || filter.test(name2 = entry2.getName().substring(patcher.getInject().length()))) continue;
                    if (name2.startsWith("META-INF/services/") && !entry2.isDirectory()) {
                        existing = servicesLists.computeIfAbsent(name2, k -> new ArrayList());
                        if (existing.size() > 0) {
                            existing.add("");
                        }
                        existing.add(String.format("# %s - %s", patcher.artifact, patcher.getZip().getCanonicalFile().getName()));
                        existing.addAll(IOUtils.readLines((InputStream)zin, (Charset)StandardCharsets.UTF_8));
                        continue;
                    }
                    _new = new ZipEntry(name2);
                    _new.setTime(0L);
                    zip.putNextEntry(_new);
                    IOUtils.copy((InputStream)zin, (OutputStream)zip);
                    added.add(name2);
                }
                continue;
            }
            catch (Throwable entry3) {
                throwable = entry3;
                throw entry3;
            }
            finally {
                if (zin != null) {
                    if (throwable != null) {
                        try {
                            zin.close();
                        }
                        catch (Throwable entry3) {
                            throwable.addSuppressed(entry3);
                        }
                    } else {
                        zin.close();
                    }
                }
            }
        }
        for (Map.Entry kv : servicesLists.entrySet()) {
            String name3 = (String)kv.getKey();
            ZipEntry _new = new ZipEntry(name3);
            _new.setTime(0L);
            zip.putNextEntry(_new);
            IOUtils.writeLines((Collection)((Collection)kv.getValue()), (String)"\n", (OutputStream)zip, (Charset)StandardCharsets.UTF_8);
            added.add(name3);
        }
    }

    private McpNames loadMCPNames(String name, File data) throws IOException {
        McpNames map = this.mapCache.get(name);
        String hash = HashFunction.SHA1.hash(data);
        if (map == null || !hash.equals(map.hash)) {
            map = McpNames.load(data);
            this.mapCache.put(name, map);
        }
        return map;
    }

    private File findObfToSrg(IMappingFile.Format format) throws IOException {
        String ext = format.name().toLowerCase();
        File root = this.cache(this.mcp.getArtifact().getGroup().replace('.', '/'), this.mcp.getArtifact().getName(), this.mcp.getArtifact().getVersion());
        File file = new File(root, "obf_to_srg." + ext);
        HashStore cache = new HashStore().add("mcp", this.mcp.getZip()).load(new File(root, "obf_to_srg." + ext + ".input"));
        if (!cache.isSame() || !file.exists()) {
            byte[] data = this.mcp.getData("mappings");
            IMappingFile obf_to_srg = this.loadObfToSrg(data);
            obf_to_srg.write(file.toPath(), format, false);
            cache.save();
        }
        return file;
    }

    private File findSrgToMcp(String mapping, @Nullable File names) throws IOException {
        if (names == null) {
            this.debug("Attempted to create SRG to MCP with null MCP mappings: " + mapping);
            throw new IllegalArgumentException("Attempted to create SRG to MCP with null MCP mappings: " + mapping);
        }
        File root = this.cache(this.mcp.getArtifact().getGroup().replace('.', '/'), this.mcp.getArtifact().getName(), this.mcp.getArtifact().getVersion());
        String srg_name = "srg_to_" + mapping + ".tsrg";
        File srg = new File(root, srg_name);
        HashStore cache = new HashStore().add("mcp", this.mcp.getZip()).add("mapping", names).load(new File(root, srg_name + ".input"));
        if (!cache.isSame() || !srg.exists()) {
            this.info("Creating SRG -> MCP TSRG");
            byte[] data = this.mcp.getData("mappings");
            final McpNames mcp_names = this.loadMCPNames(mapping, names);
            IMappingFile obf_to_srg = this.loadObfToSrg(data);
            IMappingFile srg_to_named = obf_to_srg.reverse().chain(obf_to_srg).rename(new IRenamer(){

                public String rename(IMappingFile.IField value) {
                    return mcp_names.rename(value.getMapped());
                }

                public String rename(IMappingFile.IMethod value) {
                    return mcp_names.rename(value.getMapped());
                }

                public String rename(IMappingFile.IParameter value) {
                    return mcp_names.rename(value.getMapped());
                }
            });
            srg_to_named.write(srg.toPath(), IMappingFile.Format.TSRG2, false);
            cache.save();
        }
        return srg;
    }

    private IMappingFile loadObfToSrg(byte[] data) throws IOException {
        MCPConfigV2 config = this.mcp.wrapper.getConfig();
        IMappingFile obf_to_srg = IMappingFile.load((InputStream)new ByteArrayInputStream(data));
        if (config.isOfficial()) {
            return ExtractMCPData.remapSrgClasses(this.project, config, obf_to_srg);
        }
        return obf_to_srg;
    }

    @Nullable
    private File findDecomp(boolean generate) throws IOException {
        HashStore cache = this.commonHash(null);
        File decomp = this.cacheAT("decomp", "jar");
        this.debug("  Finding Decomp: " + decomp);
        cache.load(this.cacheAT("decomp", "jar.input"));
        if (cache.isSame() && decomp.exists()) {
            this.debug("  Cache Hit");
        } else if (decomp.exists() || generate) {
            this.debug("  Decompiling");
            File output = this.mcp.getStepOutput(this.isPatcher ? "joined" : this.NAME, null);
            if (this.parent != null && this.parent.getConfigV2() != null && this.parent.getConfigV2().processor != null) {
                UserdevConfigV2.DataFunction data = this.parent.getConfigV2().processor;
                DynamicJarExec proc = this.createTask("postProcess", DynamicJarExec.class);
                proc.getInput().set(output);
                proc.getOutput().set(decomp);
                proc.getTool().set((Object)data.getVersion());
                proc.getArgs().set(data.getArgs());
                if (data.getData() != null) {
                    File root = this.project.file((Object)("build/" + proc.getName()));
                    if (!root.exists()) {
                        root.mkdirs();
                    }
                    try (ZipFile zip = new ZipFile(this.parent.getZip());){
                        for (Map.Entry<String, String> ent : data.getData().entrySet()) {
                            File target = new File(root, ent.getValue());
                            Utils.extractFile(zip, ent.getValue(), target);
                            proc.getData().put((Object)ent.getKey(), (Object)target);
                        }
                    }
                }
                proc.apply();
            } else {
                FileUtils.copyFile((File)output, (File)decomp);
            }
            cache.save();
            Utils.updateHash(decomp, HashFunction.SHA1);
        }
        return decomp.exists() ? decomp : null;
    }

    @Nullable
    private File findPatched(boolean generate) throws IOException {
        File decomp = this.findDecomp(generate);
        if (decomp == null || !decomp.exists()) {
            this.debug("  Finding Patched: Decomp not found");
            return null;
        }
        if (this.parent == null) {
            this.debug("  Finding Patched: No parent");
            return decomp;
        }
        HashStore cache = this.commonHash(null).add("decomp", decomp);
        File patched = this.cacheAT("patched", "jar");
        this.debug("  Finding patched: " + decomp);
        cache.load(this.cacheAT("patched", "jar.input"));
        if (cache.isSame() && patched.exists()) {
            this.debug("    Cache Hit");
        } else if (patched.exists() || generate) {
            Patcher patcher;
            this.debug("    Generating");
            LinkedList<Patcher> parents = new LinkedList<Patcher>();
            for (patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                parents.addFirst(patcher);
            }
            boolean failed = false;
            byte[] lastPatched = FileUtils.readFileToByteArray((File)decomp);
            for (Patcher p : parents) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                PatchOperation.Builder opBuilder = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.project.getLogger(), LogLevel.LIFECYCLE)).basePath(lastPatched, ArchiveFormat.ZIP).patchesPath(p.getZip().toPath()).patchesPrefix(p.getPatches()).outputPath((OutputStream)bout, ArchiveFormat.ZIP).mode(PatchMode.ACCESS).verbose(DEBUG).summary(DEBUG);
                UserdevConfigV2 cfg = p.getConfigV2();
                if (cfg != null) {
                    if (cfg.patchesOriginalPrefix != null) {
                        opBuilder = opBuilder.aPrefix(cfg.patchesOriginalPrefix);
                    }
                    if (cfg.patchesModifiedPrefix != null) {
                        opBuilder = opBuilder.bPrefix(cfg.patchesModifiedPrefix);
                    }
                }
                CliOperation.Result result = opBuilder.build().operate();
                boolean bl = failed = result.exit != 0;
                if (failed) break;
                lastPatched = bout.toByteArray();
            }
            if (failed) {
                throw new RuntimeException("Failed to apply patches to source file, see log for details: " + decomp);
            }
            try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(patched));){
                Throwable throwable;
                ZipInputStream zin;
                HashSet<String> added = new HashSet<String>();
                if (lastPatched != null) {
                    zin = new ZipInputStream(new ByteArrayInputStream(lastPatched));
                    throwable = null;
                    try {
                        added.addAll(Utils.copyZipEntries(zout, zin, e -> true));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (zin != null) {
                            if (throwable != null) {
                                try {
                                    zin.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                zin.close();
                            }
                        }
                    }
                }
                this.debug("    Injecting patcher extras");
                for (patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                    if (patcher.getSources() == null) continue;
                    zin = new ZipInputStream(new FileInputStream(patcher.getSources()));
                    throwable = null;
                    try {
                        added.addAll(Utils.copyZipEntries(zout, zin, e -> !added.contains(e) && !e.startsWith("patches/")));
                        continue;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (zin != null) {
                            if (throwable != null) {
                                try {
                                    zin.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                zin.close();
                            }
                        }
                    }
                }
                cache.save();
                Utils.updateHash(patched, HashFunction.SHA1);
            }
        }
        return patched.exists() ? patched : null;
    }

    @Nullable
    private File findSource(@Nullable String mapping, boolean generate) throws IOException {
        File patched = this.findPatched(generate);
        if (patched == null || !patched.exists()) {
            this.debug("  Finding Source: Patched not found");
            return null;
        }
        if (mapping == null) {
            this.debug("  Finding Source: No Renames");
            return patched;
        }
        File names = this.findMapping(mapping);
        if (mapping != null && names == null) {
            this.debug("  Finding Sources: Mapping not found");
            return null;
        }
        File obf2srg = this.findObfToSrg(IMappingFile.Format.TSRG2);
        if (obf2srg == null) {
            this.debug("  Finding Source: No obf2srg");
            return patched;
        }
        HashStore cache = this.commonHash(names);
        File sources = this.cacheMapped(mapping, "sources", "jar");
        this.debug("  Finding Source: " + sources);
        cache.load(this.cacheMapped(mapping, "sources", "jar.input"));
        if (cache.isSame() && sources.exists()) {
            this.debug("    Cache hit");
        } else if (sources.exists() || generate) {
            IMappingFile obf_to_srg = IMappingFile.load((File)obf2srg);
            Set vanilla = obf_to_srg.getClasses().stream().map(IMappingFile.INode::getMapped).collect(Collectors.toSet());
            McpNames map = McpNames.load(names);
            if (!sources.getParentFile().exists()) {
                sources.getParentFile().mkdirs();
            }
            boolean addJavadocs = this.parent == null || this.parent.getConfigV2() == null || this.parent.getConfigV2().processor == null;
            Charset sourceFileCharset = this.parent == null || this.parent.getConfigV2() == null ? StandardCharsets.UTF_8 : Charset.forName(this.parent.getConfigV2().getSourceFileCharset());
            this.debug("    Renaming Sources, Javadocs: " + addJavadocs);
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(patched));
                 ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(sources));){
                ZipEntry _old;
                while ((_old = zin.getNextEntry()) != null) {
                    String name = _old.getName();
                    zout.putNextEntry(Utils.getStableEntry(name));
                    if (name.endsWith(".java")) {
                        String mapped = map.rename(zin, addJavadocs && vanilla.contains(name.substring(0, name.length() - 5)), true, sourceFileCharset);
                        IOUtils.write((String)mapped, (OutputStream)zout, (Charset)sourceFileCharset);
                        continue;
                    }
                    IOUtils.copy((InputStream)zin, (OutputStream)zout);
                }
            }
            Utils.updateHash(sources, HashFunction.SHA1);
            cache.save();
        }
        return sources.exists() ? sources : null;
    }

    @Nullable
    private File findRecomp(@Nullable String mapping, boolean generate) throws IOException {
        File source = this.findSource(mapping, generate);
        if (source == null || !source.exists()) {
            this.debug("  Finding Recomp: Sources not found");
            return null;
        }
        File names = this.findMapping(mapping);
        if (names == null && mapping != null) {
            this.debug("  Finding Recomp: Could not find names");
            return null;
        }
        HashStore cache = this.commonHash(names);
        cache.add("source", source);
        cache.load(this.cacheMapped(mapping, "recomp", "jar.input"));
        File recomp = this.cacheMapped(mapping, "recomp", "jar");
        if (cache.isSame() && recomp.exists()) {
            this.debug("  Finding Recomp: Cache Hit");
        } else {
            Throwable throwable;
            this.debug("  Finding recomp: " + cache.isSame() + " " + recomp);
            this.debug("    Compiling");
            File compiled = this.compileJava(source, new File[0]);
            if (compiled == null) {
                this.debug("    Compiling failed");
                throw new IllegalStateException("Compile failed in findRecomp. See log for more details");
            }
            this.debug("    Injecting resources");
            HashSet<String> added = new HashSet<String>();
            File recompTemp = this.cacheMapped(mapping, "recomp", "temp.jar");
            try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(recompTemp));){
                throwable = null;
                try (Stream<Path> walk = Files.walk(compiled.toPath(), new FileVisitOption[0]);){
                    for (Path path : walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList())) {
                        InputStream fin = Files.newInputStream(path, new OpenOption[0]);
                        Throwable throwable2 = null;
                        try {
                            String name = compiled.toPath().relativize(path).toString().replace('\\', '/');
                            zout.putNextEntry(Utils.getStableEntry(name));
                            IOUtils.copy((InputStream)fin, (OutputStream)zout);
                            zout.closeEntry();
                            added.add(name);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (fin == null) continue;
                            if (throwable2 != null) {
                                try {
                                    fin.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            fin.close();
                        }
                    }
                    this.copyResources(zout, added, false);
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            var11_11 = null;
            try (FileSystem zipFs = FileSystems.newFileSystem(URI.create("jar:" + recompTemp.toURI()), Maps.newHashMap());){
                throwable = null;
                try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(recomp));
                     Stream<Path> walk = Files.walk(zipFs.getPath("/", new String[0]), new FileVisitOption[0]);){
                    ImmutableList special = ImmutableList.of((Object)"/META-INF/MANIFEST.MF");
                    List paths = walk.sorted(Comparator.comparing(Path::toString, (arg_0, arg_1) -> MinecraftUserRepo.lambda$findRecomp$20((List)special, arg_0, arg_1))).collect(Collectors.toList());
                    paths.remove(zipFs.getPath("/", new String[0]));
                    for (Path path : paths) {
                        String pathString = path.toString().substring(1).replace('\\', '/');
                        boolean directory = Files.isDirectory(path, new LinkOption[0]);
                        if (directory && !pathString.endsWith("/")) {
                            pathString = pathString + "/";
                        }
                        ZipEntry zipEntry = new ZipEntry(pathString);
                        zipEntry.setTime(628041600000L);
                        zos.putNextEntry(zipEntry);
                        if (Files.isRegularFile(path, new LinkOption[0])) {
                            Files.copy(path, zos);
                        }
                        zos.closeEntry();
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (Throwable throwable7) {
                var11_11 = throwable7;
                throw throwable7;
            }
            recompTemp.delete();
            Utils.updateHash(recomp, HashFunction.SHA1);
            cache.save();
        }
        return recomp;
    }

    @Nullable
    private File findExtraClassifier(@Nullable String mapping, String classifier, String extension) throws IOException {
        File target = this.cacheMapped(mapping, classifier, extension);
        this.debug("  Finding Classified: " + target);
        File original = MavenArtifactDownloader.manual(this.project, Artifact.from(this.GROUP, this.NAME, this.VERSION, classifier, extension).getDescriptor(), false);
        HashStore cache = this.commonHash(null);
        if (original != null) {
            cache.add("original", original);
        }
        cache.load(this.cacheMapped(mapping, classifier, extension + ".input"));
        if (cache.isSame() && target.exists()) {
            this.debug("    Cache hit");
        } else {
            block6: {
                if (original == null) {
                    this.debug("    Failed to download original artifact.");
                    return null;
                }
                this.debug("    Copying file");
                try {
                    FileUtils.copyFile((File)original, (File)target);
                }
                catch (IOException e) {
                    if (!target.exists()) break block6;
                    target.delete();
                }
            }
            cache.save();
            Utils.updateHash(target, HashFunction.SHA1);
        }
        return target;
    }

    private String getNextTaskName(String prefix) {
        return '_' + prefix + "_" + this.compileTaskCount++;
    }

    private <T extends Task> T createTask(String prefix, Class<T> cls) {
        return (T)this.project.getTasks().create(this.getNextTaskName(prefix), cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private File compileJava(File source, File ... extraDeps) {
        HackyJavaCompile compile = this.createTask("compileJava", HackyJavaCompile.class);
        try {
            File output = this.project.file((Object)("build/" + compile.getName() + "/"));
            if (output.exists()) {
                FileUtils.cleanDirectory((File)output);
            } else {
                output.mkdirs();
            }
            HashSet files = Sets.newHashSet(this.extraDataFiles);
            Collections.addAll(files, extraDeps);
            compile.setClasspath((FileCollection)this.project.files(new Object[]{files}));
            String target = String.valueOf(this.mcp.wrapper.getConfig().getJavaTarget());
            compile.setSourceCompatibility(target);
            compile.setTargetCompatibility(target);
            compile.getDestinationDirectory().set(output);
            compile.setSource((FileTree)(source.isDirectory() ? this.project.fileTree((Object)source) : this.project.zipTree((Object)source)));
            compile.doHackyCompile();
            File file = output;
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file = null;
            return file;
        }
        finally {
            compile.setEnabled(false);
        }
    }

    private static /* synthetic */ int lambda$findRecomp$20(List special, String left, String right) {
        boolean containsLeft = special.contains(left);
        boolean containsRight = special.contains(right);
        if (containsLeft && containsRight) {
            return Integer.compare(special.indexOf(left), special.indexOf(right));
        }
        if (containsLeft) {
            return -1;
        }
        if (containsRight) {
            return 1;
        }
        return left.compareTo(right);
    }

    private class MCP {
        private final MCPWrapper wrapper;
        private final Artifact artifact;

        private MCP(final File data, String artifact) {
            this.artifact = Artifact.from(artifact);
            try {
                File mcp_dir = MinecraftUserRepo.this.cache(new String[]{"mcp", this.artifact.getVersion()});
                this.wrapper = new MCPWrapper(data, mcp_dir){

                    @Override
                    public MCPRuntime getRuntime(Project project, String side) {
                        MCPRuntime ret = (MCPRuntime)this.runtimes.get(side);
                        if (ret == null) {
                            MCPFunction function;
                            File dir = new File(MCP.this.wrapper.getRoot(), side);
                            ArrayList<String> ats = new ArrayList<String>();
                            ArrayList<String> sas = new ArrayList<String>();
                            if (MinecraftUserRepo.this.AT_HASH != null) {
                                dir = new File(dir, MinecraftUserRepo.this.AT_HASH);
                            }
                            for (Patcher patcher = MinecraftUserRepo.this.parent; patcher != null; patcher = patcher.getParent()) {
                                String data2 = patcher.getATData();
                                if (data2 != null && !data2.isEmpty()) {
                                    ats.add(data2);
                                }
                                if ((data2 = patcher.getSASData()) == null || data2.isEmpty()) continue;
                                sas.add(data2);
                            }
                            LinkedHashMap preDecomps = Maps.newLinkedHashMap();
                            if (!ats.isEmpty() || MinecraftUserRepo.this.AT_HASH != null) {
                                function = MCPFunctionFactory.createAT(project, MinecraftUserRepo.this.ATS, ats);
                                preDecomps.put("AccessTransformer", function);
                            }
                            if (!sas.isEmpty()) {
                                function = MCPFunctionFactory.createSAS(project, Collections.emptyList(), sas);
                                preDecomps.put("SideStripper", function);
                            }
                            ret = new MCPRuntime(project, data, this.getConfig(), side, dir, preDecomps);
                            this.runtimes.put(side, ret);
                        }
                        return ret;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid patcher dependency: " + artifact, e);
            }
        }

        public byte[] getData(String ... path) throws IOException {
            return this.wrapper.getData(path);
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public File getZip() {
            return this.wrapper.getZip();
        }

        public String getVersion() {
            return this.artifact.getVersion();
        }

        public String getMCVersion() {
            return this.wrapper.getConfig().getVersion();
        }

        public List<String> getLibraries() {
            return this.wrapper.getConfig().getLibraries("joined");
        }

        public File getStepOutput(String side, @Nullable String step) throws IOException {
            MCPRuntime runtime = this.wrapper.getRuntime(MinecraftUserRepo.this.project, side);
            try {
                return runtime.execute(MinecraftUserRepo.this.log, step);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                MinecraftUserRepo.this.log.lifecycle(e.getMessage());
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static class Patcher {
        private final File data;
        @Nullable
        private final File universal;
        @Nullable
        private final File sources;
        private final Artifact artifact;
        private final UserdevConfigV1 config;
        @Nullable
        private final UserdevConfigV2 configv2;
        private Patcher parent;
        private String ATs = null;
        private String SASs = null;
        private List<Pattern> universalFilters;

        private Patcher(Project project, File data, String artifact) {
            this.data = data;
            this.artifact = Artifact.from(artifact);
            try {
                byte[] cfg_data = Utils.getZipData(data, "config.json");
                int spec = Config.getSpec(cfg_data);
                if (spec == 1) {
                    this.config = UserdevConfigV1.get(cfg_data);
                    this.configv2 = null;
                } else if (spec == 2) {
                    this.configv2 = UserdevConfigV2.get(cfg_data);
                    this.config = this.configv2;
                } else {
                    throw new IllegalStateException("Could not load Patcher config, Unknown Spec: " + spec + " Dep: " + artifact);
                }
                if (this.getParentDesc() == null) {
                    throw new IllegalStateException("Invalid patcher dependency, missing MCP or parent: " + artifact);
                }
                if (this.config.universal != null) {
                    this.universal = MavenArtifactDownloader.manual(project, this.config.universal, false);
                    if (this.universal == null) {
                        throw new IllegalStateException("Invalid patcher dependency, could not resolve universal: " + this.universal);
                    }
                } else {
                    this.universal = null;
                }
                if (this.config.sources != null) {
                    this.sources = MavenArtifactDownloader.manual(project, this.config.sources, false);
                    if (this.sources == null) {
                        throw new IllegalStateException("Invalid patcher dependency, could not resolve sources: " + this.sources);
                    }
                } else {
                    this.sources = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid patcher dependency: " + artifact, e);
            }
        }

        public UserdevConfigV1 getConfig() {
            return this.config;
        }

        @Nullable
        public UserdevConfigV2 getConfigV2() {
            return this.configv2;
        }

        public boolean parentIsMcp() {
            return this.config.mcp != null;
        }

        public void setParent(Patcher value) {
            this.parent = value;
        }

        public Patcher getParent() {
            return this.parent;
        }

        @Nullable
        public String getParentDesc() {
            return this.config.mcp != null ? this.config.mcp : this.config.parent;
        }

        public List<String> getLibraries() {
            return this.config.libraries == null ? Collections.emptyList() : this.config.libraries;
        }

        public List<String> getModules() {
            return this.configv2 == null || this.configv2.modules == null ? Collections.emptyList() : this.configv2.modules;
        }

        @Nullable
        public String getATData() {
            if (this.config.getATs().isEmpty()) {
                return null;
            }
            if (this.ATs == null) {
                StringBuilder buf = new StringBuilder();
                try (ZipFile zip = new ZipFile(this.data);){
                    for (String at : this.config.getATs()) {
                        ZipEntry entry = zip.getEntry(at);
                        if (entry == null) {
                            throw new IllegalStateException("Invalid Patcher config, Missing Access Transformer: " + at + " Zip: " + this.data);
                        }
                        buf.append("# ").append(this.artifact).append(" - ").append(at).append('\n');
                        buf.append(IOUtils.toString((InputStream)zip.getInputStream(entry), (Charset)StandardCharsets.UTF_8));
                        buf.append('\n');
                    }
                    this.ATs = buf.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException("Invalid patcher config: " + this.artifact, e);
                }
            }
            return this.ATs;
        }

        @Nullable
        public String getSASData() {
            if (this.config.getSASs().isEmpty()) {
                return null;
            }
            if (this.SASs == null) {
                StringBuilder buf = new StringBuilder();
                try (ZipFile zip = new ZipFile(this.data);){
                    for (String sas : this.config.getSASs()) {
                        ZipEntry entry = zip.getEntry(sas);
                        if (entry == null) {
                            throw new IllegalStateException("Invalid Patcher config, Missing Side Annotation Stripper: " + sas + " Zip: " + this.data);
                        }
                        buf.append("# ").append(this.artifact).append(" - ").append(sas).append('\n');
                        buf.append(IOUtils.toString((InputStream)zip.getInputStream(entry), (Charset)StandardCharsets.UTF_8));
                        buf.append('\n');
                    }
                    this.SASs = buf.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException("Invalid patcher config: " + this.artifact, e);
                }
            }
            return this.SASs;
        }

        public File getZip() {
            return this.data;
        }

        @Nullable
        public File getUniversal() {
            return this.universal;
        }

        @Nullable
        public File getSources() {
            return this.sources;
        }

        @Nullable
        public String getInject() {
            return this.config.inject;
        }

        public String getPatches() {
            return this.config.patches;
        }

        public List<Pattern> getUniversalFilters() {
            if (this.universalFilters == null) {
                this.universalFilters = new ArrayList<Pattern>();
                if (this.getConfigV2() != null) {
                    for (String filter : this.getConfigV2().getUniversalFilters()) {
                        this.universalFilters.add(Pattern.compile(filter));
                    }
                }
            }
            return this.universalFilters;
        }
    }
}

