/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.gradle.mcp.function.AccessTransformerFunction;
import net.minecraftforge.gradle.mcp.function.DownloadCoreFunction;
import net.minecraftforge.gradle.mcp.function.DownloadFileFunction;
import net.minecraftforge.gradle.mcp.function.DownloadVersionJSONFunction;
import net.minecraftforge.gradle.mcp.function.ExecuteFunction;
import net.minecraftforge.gradle.mcp.function.InjectFunction;
import net.minecraftforge.gradle.mcp.function.ListLibrariesFunction;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.function.PatchFunction;
import net.minecraftforge.gradle.mcp.function.SideAnnotationStripperFunction;
import net.minecraftforge.gradle.mcp.function.StripJarFunction;
import org.gradle.api.Project;

public class MCPFunctionFactory {
    @Deprecated
    @Nullable
    public static MCPFunction createBuiltIn(String type, int spec) {
        switch (type) {
            case "downloadManifest": {
                return new DownloadFileFunction("manifest.json", "https://piston-meta.mojang.com/mc/game/version_manifest.json");
            }
            case "downloadJson": {
                return new DownloadVersionJSONFunction();
            }
            case "downloadClient": {
                return new DownloadCoreFunction("client", "jar");
            }
            case "downloadServer": {
                return new DownloadCoreFunction("server", "jar");
            }
            case "strip": {
                return new StripJarFunction();
            }
            case "listLibraries": {
                return new ListLibrariesFunction();
            }
            case "inject": {
                return new InjectFunction();
            }
            case "patch": {
                return new PatchFunction();
            }
        }
        if (spec >= 2) {
            switch (type) {
                case "downloadClientMappings": {
                    return new DownloadCoreFunction("client_mappings", "txt");
                }
                case "downloadServerMappings": {
                    return new DownloadCoreFunction("server_mappings", "txt");
                }
            }
        }
        return null;
    }

    @Deprecated
    public static MCPFunction createAT(Project project, List<File> files, Collection<String> data) {
        AccessTransformerFunction ret = new AccessTransformerFunction(project, files);
        data.forEach(ret::addTransformer);
        return ret;
    }

    @Deprecated
    public static MCPFunction createSAS(Project project, List<File> files, Collection<String> data) {
        SideAnnotationStripperFunction ret = new SideAnnotationStripperFunction(project, files);
        data.forEach(ret::addData);
        return ret;
    }

    @Deprecated
    public static MCPFunction createExecute(File jar, List<String> jvmArgs, List<String> runArgs) {
        return new ExecuteFunction(jar, jvmArgs.toArray(new String[jvmArgs.size()]), runArgs.toArray(new String[runArgs.size()]), Collections.emptyMap());
    }
}

