/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import java.io.IOException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import net.minecraftforge.gradle.common.util.JavaVersionParser;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.util.GradleVersion;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class EnvironmentChecks {
    public static final String ENABLE_CERTIFICATE_CHECK_VARIABLE = "net.minecraftforge.gradle.check.certs";
    public static final String ENABLE_GRADLE_CHECK_VARIABLE = "net.minecraftforge.gradle.check.gradle";
    public static final String ENABLE_JAVA_CHECK_VARIABLE = "net.minecraftforge.gradle.check.java";
    private static final boolean ENABLE_CERTIFICATE_CHECK = Boolean.parseBoolean(System.getProperty("net.minecraftforge.gradle.check.certs", "true"));
    private static final boolean ENABLE_GRADLE_CHECK = Boolean.parseBoolean(System.getProperty("net.minecraftforge.gradle.check.gradle", "true"));
    private static final boolean ENABLE_JAVA_CHECK = Boolean.parseBoolean(System.getProperty("net.minecraftforge.gradle.check.java", "true"));
    private static final Marker ENV_CHECK = MarkerFactory.getMarker((String)"forgegradle.env_check");

    public static void checkJavaRange(@Nullable JavaVersionParser.JavaVersion minVersionInclusive, @Nullable JavaVersionParser.JavaVersion maxVersionExclusive) {
        EnvironmentChecks.checkRange("java", JavaVersionParser.getCurrentJavaVersion(), minVersionInclusive, maxVersionExclusive, "", "");
    }

    public static void checkGradleRange(@Nullable GradleVersion minVersionInclusive, @Nullable GradleVersion maxVersionExclusive) {
        EnvironmentChecks.checkRange("Gradle", GradleVersion.current(), minVersionInclusive, maxVersionExclusive, "\nNote: Upgrade your gradle version first before trying to switch to FG5.", "");
    }

    private static <T> void checkRange(String name, Comparable<T> current, @Nullable T minVersionInclusive, @Nullable T maxVersionExclusive, String additionalMin, String additionalMax) {
        if (minVersionInclusive != null && current.compareTo(minVersionInclusive) < 0) {
            throw new EnvironmentCheckFailedException(String.format("Found %s version %s. Minimum required is %s.%s", name, current, minVersionInclusive, additionalMin));
        }
        if (maxVersionExclusive != null && current.compareTo(maxVersionExclusive) >= 0) {
            throw new EnvironmentCheckFailedException(String.format("Found %s version %s. Versions %s and newer are not supported yet.%s", name, current, maxVersionExclusive, additionalMax));
        }
    }

    public static void checkEnvironment(Project project) {
        Logger logger = project.getLogger();
        if (ENABLE_JAVA_CHECK) {
            logger.debug(ENV_CHECK, "Checking Java version");
            EnvironmentChecks.checkJavaRange(JavaVersionParser.parseJavaVersion("1.8.0_101"), null);
        } else {
            logger.debug(ENV_CHECK, "Java version check disabled by system property");
        }
        if (ENABLE_GRADLE_CHECK) {
            logger.debug(ENV_CHECK, "Checking Gradle version");
            EnvironmentChecks.checkGradleRange(GradleVersion.version((String)"7.1"), GradleVersion.version((String)"8.0"));
        } else {
            logger.debug(ENV_CHECK, "Gradle version check disabled by system property");
        }
        if (ENABLE_CERTIFICATE_CHECK) {
            logger.debug(ENV_CHECK, "Checking server connections");
            EnvironmentChecks.testServerConnection("https://maven.minecraftforge.net/");
            EnvironmentChecks.testServerConnection("https://libraries.minecraft.net/");
        } else {
            logger.debug(ENV_CHECK, "Server connection check disabled by system property");
        }
    }

    private static void testServerConnection(String url) {
        try {
            HttpsURLConnection conn = (HttpsURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("HEAD");
            conn.connect();
            conn.getResponseCode();
        }
        catch (SSLException e) {
            throw new EnvironmentCheckFailedException(String.format("Failed to validate certificate for host '%s'. To disable this check, re-run with '-D%s=false'.", url, ENABLE_CERTIFICATE_CHECK_VARIABLE), e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class EnvironmentCheckFailedException
    extends RuntimeException {
        EnvironmentCheckFailedException(String message) {
            super(message);
        }

        EnvironmentCheckFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

