/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.tasks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.minecraftforge.gradle.common.util.ManifestJson;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class DownloadMCMeta
extends DefaultTask {
    private static final String MANIFEST_URL = "https://piston-meta.mojang.com/mc/game/version_manifest.json";
    private static final Gson GSON = new GsonBuilder().create();

    public DownloadMCMeta() {
        this.getManifest().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(s -> s.file("manifest.json")));
        this.getOutput().convention(this.getProject().getLayout().getBuildDirectory().dir(this.getName()).map(s -> s.file("version.json")));
    }

    @TaskAction
    public void downloadMCMeta() throws IOException {
        block13: {
            try (InputStream manin = new URL(MANIFEST_URL).openStream();){
                URL url = ((ManifestJson)GSON.fromJson((Reader)new InputStreamReader(manin), ManifestJson.class)).getUrl((String)this.getMCVersion().get());
                if (url != null) {
                    FileUtils.copyURLToFile((URL)url, (File)((RegularFile)this.getOutput().get()).getAsFile());
                    break block13;
                }
                throw new RuntimeException("Missing version from manifest: " + (String)this.getMCVersion().get());
            }
        }
    }

    @Input
    public abstract Property<String> getMCVersion();

    @Internal
    public abstract RegularFileProperty getManifest();

    @OutputFile
    public abstract RegularFileProperty getOutput();
}

