/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.dependency;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraftforge.gradle.userdev.dependency.DependencyFilter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

public class DefaultDependencyFilter
implements DependencyFilter {
    private final Project project;
    protected final List<Spec<? super DependencyFilter.ArtifactIdentifier>> includeSpecs = new ArrayList<Spec<? super DependencyFilter.ArtifactIdentifier>>();
    protected final List<Spec<? super DependencyFilter.ArtifactIdentifier>> excludeSpecs = new ArrayList<Spec<? super DependencyFilter.ArtifactIdentifier>>();

    public DefaultDependencyFilter(Project project) {
        this.project = project;
    }

    @Override
    public DependencyFilter exclude(Spec<? super DependencyFilter.ArtifactIdentifier> spec) {
        this.excludeSpecs.add(spec);
        return this;
    }

    @Override
    public DependencyFilter include(Spec<? super DependencyFilter.ArtifactIdentifier> spec) {
        this.includeSpecs.add(spec);
        return this;
    }

    @Override
    public Spec<? super DependencyFilter.ArtifactIdentifier> dependency(Object notation) {
        return this.dependency(this.project.getDependencies().create(notation));
    }

    @Override
    public Spec<? super DependencyFilter.ArtifactIdentifier> dependency(final Dependency dependency) {
        return this.dependency(new Closure<Boolean>(null){

            public Boolean call(Object it) {
                if (it instanceof DependencyFilter.ArtifactIdentifier) {
                    DependencyFilter.ArtifactIdentifier identifier = (DependencyFilter.ArtifactIdentifier)it;
                    return !(dependency.getGroup() != null && !Pattern.matches(dependency.getGroup(), identifier.getGroup()) || dependency.getName() != null && !Pattern.matches(dependency.getName(), identifier.getName()) || dependency.getVersion() != null && !Pattern.matches(dependency.getVersion(), identifier.getVersion()));
                }
                return false;
            }
        });
    }

    @Override
    public Spec<? super DependencyFilter.ArtifactIdentifier> dependency(Closure<Boolean> spec) {
        return Specs.convertClosureToSpec(spec);
    }

    @Override
    public boolean isIncluded(ResolvedDependency dependency) {
        return this.isIncluded(new DependencyFilter.ArtifactIdentifier(dependency.getModuleGroup(), dependency.getModuleName(), dependency.getModuleVersion()));
    }

    @Override
    public boolean isIncluded(ModuleDependency dependency) {
        return this.isIncluded(new DependencyFilter.ArtifactIdentifier(dependency.getGroup(), dependency.getName(), dependency.getVersion()));
    }

    @Override
    public boolean isIncluded(DependencyFilter.ArtifactIdentifier dependency) {
        boolean include = this.includeSpecs.isEmpty() || this.includeSpecs.stream().anyMatch(spec -> spec.isSatisfiedBy((Object)dependency));
        boolean exclude = !this.excludeSpecs.isEmpty() && this.excludeSpecs.stream().anyMatch(spec -> spec.isSatisfiedBy((Object)dependency));
        return include && !exclude;
    }
}

