/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraftforge.gradle.common.tasks.JarExec;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class RenameJarInPlace
extends JarExec {
    private final Provider<Directory> workDir = this.getProject().getLayout().getBuildDirectory().dir(this.getName());
    private final Provider<RegularFile> temp = this.workDir.map(s -> s.file("output.jar"));

    public RenameJarInPlace() {
        this.getTool().set((Object)"net.md-5:SpecialSource:1.10.0:shaded");
        this.getArgs().addAll((Object[])new String[]{"--in-jar", "{input}", "--out-jar", "{output}", "--srg-in", "{mappings}", "--live"});
        this.getOutputs().upToDateWhen(task -> false);
    }

    @Override
    protected List<String> filterArgs(List<String> args) {
        return this.replaceArgsMulti(args, (Map<String, ?>)ImmutableMap.of((Object)"{input}", (Object)((RegularFile)this.getInput().get()).getAsFile(), (Object)"{output}", (Object)((RegularFile)this.temp.get()).getAsFile()), (Multimap<String, ?>)ImmutableMultimap.builder().put((Object)"{mappings}", (Object)((RegularFile)this.getMappings().get()).getAsFile()).putAll((Object)"{mappings}", (Iterable)this.getExtraMappings().getFiles()).build());
    }

    @Override
    @TaskAction
    public void apply() throws IOException {
        File temp = ((RegularFile)this.temp.get()).getAsFile();
        if (temp.getParentFile() != null && !temp.getParentFile().exists() && !temp.getParentFile().mkdirs()) {
            this.getProject().getLogger().warn("Could not create parent directories for temp dir '{}'", (Object)temp.getAbsolutePath());
        }
        super.apply();
        FileUtils.copyFile((File)temp, (File)((RegularFile)this.getInput().get()).getAsFile());
    }

    @InputFile
    public abstract RegularFileProperty getMappings();

    @Optional
    @InputFiles
    public abstract ConfigurableFileCollection getExtraMappings();

    @InputFile
    public abstract RegularFileProperty getInput();
}

