/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.tasks;

import codechicken.diffpatch.cli.CliOperation;
import codechicken.diffpatch.cli.PatchOperation;
import codechicken.diffpatch.util.LoggingOutputStream;
import codechicken.diffpatch.util.PatchMode;
import codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class ApplyPatches
extends DefaultTask {
    private float minFuzzQuality = -1.0f;
    private int maxFuzzOffset = -1;
    private boolean verbose = false;
    private boolean printSummary = false;
    private boolean failOnError = true;

    public ApplyPatches() {
        this.getPatchMode().convention((Object)PatchMode.EXACT);
        this.getPatchesPrefix().convention((Object)"");
        this.getOriginalPrefix().convention((Object)"a/");
        this.getModifiedPrefix().convention((Object)"b/");
    }

    @TaskAction
    public void doTask() throws Exception {
        if (!this.getPatches().isPresent()) {
            FileUtils.copyFile((File)((File)this.getBase().get()), (File)((RegularFile)this.getOutput().get()).getAsFile());
            return;
        }
        Path outputPath = ((RegularFile)this.getOutput().get()).getAsFile().toPath();
        ArchiveFormat outputFormat = (ArchiveFormat)this.getOutputFormat().getOrNull();
        if (outputFormat == null) {
            outputFormat = ArchiveFormat.findFormat((Path)outputPath.getFileName());
        }
        Path rejectsPath = (Path)this.getRejects().map(File::toPath).getOrNull();
        ArchiveFormat rejectsFormat = (ArchiveFormat)this.getOutputFormat().getOrNull();
        if (rejectsFormat == null && rejectsPath != null) {
            rejectsFormat = ArchiveFormat.findFormat((Path)rejectsPath.getFileName());
        }
        PatchOperation.Builder builder = PatchOperation.builder().logTo((OutputStream)new LoggingOutputStream(this.getLogger(), LogLevel.LIFECYCLE)).basePath(((File)this.getBase().get()).toPath()).patchesPath(((Directory)this.getPatches().get()).getAsFile().toPath()).outputPath(outputPath, outputFormat).rejectsPath(rejectsPath, rejectsFormat).verbose(this.verbose).summary(this.printSummary).mode((PatchMode)this.getPatchMode().get()).aPrefix((String)this.getOriginalPrefix().get()).bPrefix((String)this.getModifiedPrefix().get()).patchesPrefix((String)this.getPatchesPrefix().get());
        if (this.minFuzzQuality != -1.0f) {
            builder.minFuzz(this.minFuzzQuality);
        }
        if (this.maxFuzzOffset != -1) {
            builder.maxOffset(this.maxFuzzOffset);
        }
        CliOperation.Result result = builder.build().operate();
        int exit = result.exit;
        if (exit != 0 && exit != 1) {
            throw new RuntimeException("DiffPatch failed with exit code: " + exit);
        }
        if (exit != 0 && this.isFailOnError()) {
            throw new RuntimeException("Patches failed to apply.");
        }
    }

    @InputFile
    public abstract Property<File> getBase();

    @InputDirectory
    @Optional
    public abstract DirectoryProperty getPatches();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Internal
    public abstract Property<File> getRejects();

    @Input
    @Optional
    public abstract Property<ArchiveFormat> getOutputFormat();

    @Input
    @Optional
    public abstract Property<ArchiveFormat> getRejectsFormat();

    @Input
    @Optional
    public abstract Property<PatchMode> getPatchMode();

    @Input
    @Optional
    public abstract Property<String> getPatchesPrefix();

    @Input
    @Optional
    public abstract Property<String> getOriginalPrefix();

    @Input
    @Optional
    public abstract Property<String> getModifiedPrefix();

    @Input
    public float getMinFuzzQuality() {
        return this.minFuzzQuality;
    }

    public void setMinFuzzQuality(float minFuzzQuality) {
        this.minFuzzQuality = minFuzzQuality;
    }

    @Input
    public int getMaxFuzzOffset() {
        return this.maxFuzzOffset;
    }

    public void setMaxFuzzOffset(int maxFuzzOffset) {
        this.maxFuzzOffset = maxFuzzOffset;
    }

    @Console
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Console
    public boolean isPrintSummary() {
        return this.printSummary;
    }

    public void setPrintSummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    @Input
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

