/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.artifactural.gradle.GradleRepositoryAdapter;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.tasks.ExtractNatives;
import net.minecraftforge.gradle.common.util.EclipseHacks;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.gradle.common.util.runs.RunConfigGenerator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.TaskProvider;

public class Utils {
    private static final boolean ENABLE_FILTER_REPOS = Boolean.parseBoolean(System.getProperty("net.minecraftforge.gradle.filter_repos", "true"));
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(MCPConfigV1.Step.class, (Object)new MCPConfigV1.Step.Deserializer()).registerTypeAdapter(VersionJson.Argument.class, (Object)new VersionJson.Argument.Deserializer()).setPrettyPrinting().create();
    static final int CACHE_TIMEOUT = 3600000;
    public static final String FORGE_MAVEN = "https://maven.minecraftforge.net/";
    public static final String MOJANG_MAVEN = "https://libraries.minecraft.net/";
    public static final String BINPATCHER = "net.minecraftforge:binarypatcher:1.+:fatjar";
    public static final String ACCESSTRANSFORMER = "net.minecraftforge:accesstransformers:8.0.+:fatjar";
    public static final String SPECIALSOURCE = "net.md-5:SpecialSource:1.10.0:shaded";
    public static final String FART = "net.minecraftforge:ForgeAutoRenamingTool:0.1.+:all";
    public static final String SRG2SOURCE = "net.minecraftforge:Srg2Source:8.+:fatjar";
    public static final String SIDESTRIPPER = "net.minecraftforge:mergetool:1.1.3:fatjar";
    public static final String INSTALLERTOOLS = "net.minecraftforge:installertools:1.2.8:fatjar";
    public static final long ZIPTIME = 628041600000L;
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public static void extractFile(ZipFile zip, String name, File output) throws IOException {
        Utils.extractFile(zip, zip.getEntry(name), output);
    }

    public static void extractFile(ZipFile zip, ZipEntry entry, File output) throws IOException {
        File parent = output.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (InputStream stream = zip.getInputStream(entry);){
            Files.copy(stream, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void extractDirectory(Function<String, File> fileLocator, ZipFile zip, String directory) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry e = entries.nextElement();
            if (e.isDirectory() || !e.getName().startsWith(directory)) continue;
            Utils.extractFile(zip, e, fileLocator.apply(e.getName()));
        }
    }

    public static Set<String> copyZipEntries(ZipOutputStream zout, ZipInputStream zin, Predicate<String> filter) throws IOException {
        ZipEntry entry;
        HashSet<String> added = new HashSet<String>();
        while ((entry = zin.getNextEntry()) != null) {
            if (!filter.test(entry.getName())) continue;
            ZipEntry _new = new ZipEntry(entry.getName());
            _new.setTime(0L);
            zout.putNextEntry(_new);
            IOUtils.copy((InputStream)zin, (OutputStream)zout);
            added.add(entry.getName());
        }
        return added;
    }

    public static byte[] base64DecodeStringList(List<String> strings) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (String string : strings) {
            bos.write(Base64.getDecoder().decode(string));
        }
        return bos.toByteArray();
    }

    public static File delete(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        return file;
    }

    public static File createEmpty(File file) throws IOException {
        Utils.delete(file);
        file.createNewFile();
        return file;
    }

    public static Path getCacheBase(Project project) {
        File gradleUserHomeDir = project.getGradle().getGradleUserHomeDir();
        return Paths.get(gradleUserHomeDir.getPath(), "caches", "forge_gradle");
    }

    public static File getCache(Project project, String ... tail) {
        return Paths.get(Utils.getCacheBase(project).toString(), tail).toFile();
    }

    public static void extractZip(File source, File target, boolean overwrite) throws IOException {
        Utils.extractZip(source, target, overwrite, false);
    }

    public static void extractZip(File source, File target, boolean overwrite, boolean deleteExtras) throws IOException {
        HashSet extra = deleteExtras ? Files.walk(target.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).collect(Collectors.toSet()) : new HashSet();
        try (ZipFile zip = new ZipFile(source);){
            Enumeration<? extends ZipEntry> enu = zip.entries();
            while (enu.hasMoreElements()) {
                Throwable throwable;
                ZipEntry e = enu.nextElement();
                if (e.isDirectory()) continue;
                File out = new File(target, e.getName());
                File parent = out.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                extra.remove(out);
                if (out.exists()) {
                    if (!overwrite) continue;
                    FileInputStream fis = new FileInputStream(out);
                    throwable = null;
                    try {
                        if (IOUtils.contentEquals((InputStream)zip.getInputStream(e), (InputStream)fis)) {
                            continue;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fis.close();
                        continue;
                    }
                }
                FileOutputStream fos = new FileOutputStream(out);
                throwable = null;
                try {
                    IOUtils.copy((InputStream)zip.getInputStream(e), (OutputStream)fos);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
        }
        if (deleteExtras) {
            extra.forEach(File::delete);
            Files.walk(target.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted(Comparator.reverseOrder()).map(Path::toFile).filter(f -> f.list().length == 0).forEach(File::delete);
        }
    }

    public static File updateDownload(Project project, File target, VersionJson.Download dl) throws IOException {
        if (!target.exists() || !HashFunction.SHA1.hash(target).equals(dl.sha1)) {
            project.getLogger().lifecycle("Downloading: " + dl.url);
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            FileUtils.copyURLToFile((URL)dl.url, (File)target);
        }
        return target;
    }

    public static <T> T loadJson(File target, Class<T> clz) throws IOException {
        try (FileInputStream in = new FileInputStream(target);){
            Object object = GSON.fromJson((Reader)new InputStreamReader(in), clz);
            return (T)object;
        }
    }

    public static <T> T loadJson(InputStream in, Class<T> clz) {
        return (T)GSON.fromJson((Reader)new InputStreamReader(in), clz);
    }

    public static void updateHash(File target) throws IOException {
        Utils.updateHash(target, HashFunction.values());
    }

    public static void updateHash(File target, HashFunction ... functions) throws IOException {
        for (HashFunction function : functions) {
            File cache = new File(target.getAbsolutePath() + "." + function.getExtension());
            if (target.exists()) {
                String hash = function.hash(target);
                Files.write(cache.toPath(), hash.getBytes(), new OpenOption[0]);
                continue;
            }
            if (!cache.exists()) continue;
            cache.delete();
        }
    }

    public static void forZip(ZipFile zip, IOConsumer<ZipEntry> consumer) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            consumer.accept(entries.nextElement());
        }
    }

    @Nullable
    public static String resolveString(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Closure) {
            return Utils.resolveString(((Closure)obj).call());
        }
        if (obj instanceof Callable) {
            try {
                return Utils.resolveString(((Callable)obj).call());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (obj instanceof File) {
            return ((File)obj).getAbsolutePath();
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Arrays.toString((Object[])obj);
            }
            if (obj instanceof byte[]) {
                return Arrays.toString((byte[])obj);
            }
            if (obj instanceof char[]) {
                return Arrays.toString((char[])obj);
            }
            if (obj instanceof int[]) {
                return Arrays.toString((int[])obj);
            }
            if (obj instanceof float[]) {
                return Arrays.toString((float[])obj);
            }
            if (obj instanceof double[]) {
                return Arrays.toString((double[])obj);
            }
            if (obj instanceof long[]) {
                return Arrays.toString((long[])obj);
            }
            return obj.getClass().getSimpleName();
        }
        return obj.toString();
    }

    public static <T> T[] toArray(JsonArray array, Function<JsonElement, T> adapter, IntFunction<T[]> arrayFactory) {
        return StreamSupport.stream(array.spliterator(), false).map(adapter).toArray(arrayFactory);
    }

    public static byte[] getZipData(File file, String name) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            ZipEntry entry = zip.getEntry(name);
            if (entry == null) {
                throw new IOException("Zip Missing Entry: " + name + " File: " + file);
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)zip.getInputStream(entry));
            return byArray;
        }
    }

    public static <T> T fromJson(InputStream stream, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)GSON.fromJson((Reader)new InputStreamReader(stream), classOfT);
    }

    public static <T> T fromJson(byte[] data, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)GSON.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(data)), classOfT);
    }

    @Nonnull
    public static String capitalize(@Nonnull String toCapitalize) {
        return toCapitalize.length() > 1 ? toCapitalize.substring(0, 1).toUpperCase() + toCapitalize.substring(1) : toCapitalize;
    }

    public static Stream<String> lines(InputStream input) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        return (Stream)reader.lines().onClose(() -> {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static ZipEntry getStableEntry(String name) {
        return Utils.getStableEntry(name, 628041600000L);
    }

    public static ZipEntry getStableEntry(String name, long time) {
        TimeZone _default = TimeZone.getDefault();
        TimeZone.setDefault(GMT);
        ZipEntry ret = new ZipEntry(name);
        ret.setTime(time);
        TimeZone.setDefault(_default);
        return ret;
    }

    public static void createRunConfigTasks(MinecraftExtension extension, TaskProvider<ExtractNatives> extractNatives, TaskProvider<?> ... setupTasks) {
        ArrayList setupTasksLst = new ArrayList(Arrays.asList(setupTasks));
        TaskProvider prepareRuns = extension.getProject().getTasks().register("prepareRuns", Task.class, task -> {
            task.setGroup("ForgeGradle runs");
            task.dependsOn(new Object[]{extractNatives, setupTasksLst});
        });
        TaskProvider makeSrcDirs = extension.getProject().getTasks().register("makeSrcDirs", Task.class, task -> task.doFirst(t -> {
            JavaPluginExtension java = (JavaPluginExtension)task.getProject().getExtensions().getByType(JavaPluginExtension.class);
            java.getSourceSets().forEach(s -> s.getAllSource().getSrcDirs().stream().filter(f -> !f.exists()).forEach(File::mkdirs));
        }));
        setupTasksLst.add(makeSrcDirs);
        extension.getRuns().forEach(RunConfig::mergeParents);
        extension.getProject().getGradle().projectsEvaluated(gradle -> {
            VersionJson json = null;
            try {
                json = Utils.loadJson(((RegularFile)((ExtractNatives)((Object)((Object)extractNatives.get()))).getMeta().get()).getAsFile(), VersionJson.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            List<String> additionalClientArgs = json != null ? json.getPlatformJvmArgs() : Collections.emptyList();
            extension.getRuns().forEach(RunConfig::mergeChildren);
            extension.getRuns().forEach(run -> RunConfigGenerator.createRunTask(run, extension.getProject(), (TaskProvider<Task>)prepareRuns, additionalClientArgs));
            EclipseHacks.doEclipseFixes(extension, extractNatives, setupTasksLst);
            RunConfigGenerator.createIDEGenRunsTasks(extension, (TaskProvider<Task>)prepareRuns, (TaskProvider<Task>)makeSrcDirs, additionalClientArgs);
        });
    }

    public static void addRepoFilters(Project project) {
        if (!ENABLE_FILTER_REPOS) {
            return;
        }
        if (project.getGradle().getStartParameter().getTaskNames().stream().anyMatch(t -> t.endsWith("DownloadSources"))) {
            project.getRepositories().forEach(Utils::addMappedFilter);
        } else {
            project.getRepositories().all(Utils::addMappedFilter);
        }
    }

    private static void addMappedFilter(ArtifactRepository repository) {
        if (repository instanceof GradleRepositoryAdapter) {
            return;
        }
        repository.content(rcd -> rcd.excludeVersionByRegex(".*", ".*", ".*_mapped_.*"));
    }

    public static File getMCDir() {
        switch (VersionJson.OS.getCurrent()) {
            case OSX: {
                return new File(System.getProperty("user.home") + "/Library/Application Support/minecraft");
            }
            case WINDOWS: {
                return new File(System.getenv("APPDATA") + "\\.minecraft");
            }
        }
        return new File(System.getProperty("user.home") + "/.minecraft");
    }

    public static String replaceTokens(Map<String, ?> tokens, String value) {
        StringBuilder buf = new StringBuilder();
        for (int x = 0; x < value.length(); ++x) {
            char c = value.charAt(x);
            if (c == '\\') {
                if (x == value.length() - 1) {
                    throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                }
                buf.append(value.charAt(++x));
                continue;
            }
            if (c == '{' || c == '\'') {
                StringBuilder key = new StringBuilder();
                for (int y = x + 1; y <= value.length(); ++y) {
                    if (y == value.length()) {
                        throw new IllegalArgumentException("Illegal pattern (Unclosed " + c + "): " + value);
                    }
                    char d = value.charAt(y);
                    if (d == '\\') {
                        if (y == value.length() - 1) {
                            throw new IllegalArgumentException("Illegal pattern (Bad escape): " + value);
                        }
                        key.append(value.charAt(++y));
                        continue;
                    }
                    if (c == '{' && d == '}') {
                        x = y;
                        break;
                    }
                    if (c == '\'' && d == '\'') {
                        x = y;
                        break;
                    }
                    key.append(d);
                }
                if (c == '\'') {
                    buf.append((CharSequence)key);
                    continue;
                }
                Object v = tokens.get(key.toString());
                if (v instanceof Supplier) {
                    v = ((Supplier)v).get();
                }
                buf.append((Object)(v == null ? "{" + key + "}" : v));
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

