/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.Utils;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class MojangLicenseHelper {
    public static final String HIDE_LICENSE = "hideOfficialWarningUntilChanged";
    public static final String SHOW_LICENSE = "reshowOfficialWarning";

    public static void displayWarning(Project project, String channel, @Nullable String version, @Nullable String updateChannel, @Nullable String updateVersion) {
        MojangLicenseHelper.displayWarning(project, channel, version);
        if (updateChannel == null || Objects.equals(channel, updateChannel)) {
            return;
        }
        MojangLicenseHelper.displayWarning(project, updateChannel, updateVersion);
    }

    public static void displayWarning(Project project, String channel, @Nullable String version) {
        if ("official".equals(channel)) {
            Optional<String> license = version != null ? MojangLicenseHelper.getOfficialLicense(project, version) : Optional.empty();
            Optional<String> licenseHash = license.map(HashFunction.SHA1::hash);
            if (license.isPresent() && MojangLicenseHelper.isHidden(project, licenseHash.get())) {
                return;
            }
            String warning = MojangLicenseHelper.getWarning(license.orElse(null));
            project.getLogger().warn(warning);
            license.map(s -> "WARNING: " + s).ifPresent(arg_0 -> ((Logger)project.getLogger()).warn(arg_0));
        }
    }

    public static void hide(Project project, String channel, String version) {
        if (!"official".equals(channel)) {
            return;
        }
        String hash = MojangLicenseHelper.getOfficialLicense(project, version).map(HashFunction.SHA1::hash).orElseThrow(() -> new IllegalStateException("Could not get Mojang license text for " + version));
        Path accepted = MojangLicenseHelper.getLicensePath(project, hash);
        if (Files.exists(accepted, new LinkOption[0])) {
            return;
        }
        try {
            Utils.createEmpty(accepted.toFile());
            String warning = "WARNING: These warnings will not be shown again until the license changes or the task `{TASK}` is run.";
            project.getLogger().warn(warning.replace("{TASK}", SHOW_LICENSE));
        }
        catch (IOException exception) {
            project.getLogger().error("Could not accept Mojang license", (Throwable)exception);
        }
    }

    public static void show(Project project, String channel, String version) {
        if (!"official".equals(channel)) {
            return;
        }
        String hash = MojangLicenseHelper.getOfficialLicense(project, version).map(HashFunction.SHA1::hash).orElseThrow(() -> new IllegalStateException("Could not get Mojang license text for " + version));
        Path accepted = MojangLicenseHelper.getLicensePath(project, hash);
        Utils.delete(accepted.toFile());
    }

    private static String getWarning(@Nullable String license) {
        String warning = "WARNING: This project is configured to use the official obfuscation mappings provided by Mojang. These mapping fall under their associated license, you should be fully aware of this license. For the latest license text, refer {REFER}, or the reference copy here: https://github.com/MinecraftForge/MCPConfig/blob/master/Mojang.md, You can hide this warning by running the `{TASK}` task";
        return warning.replace("{REFER}", license != null ? "below" : "to the mapping file itself").replace("{TASK}", HIDE_LICENSE);
    }

    private static boolean isHidden(Project project, String hash) {
        return Files.exists(MojangLicenseHelper.getLicensePath(project, hash), new LinkOption[0]);
    }

    private static Optional<String> getOfficialLicense(Project project, String version) {
        String minecraftVersion = MinecraftRepo.getMCVersion(version);
        String artifact = "net.minecraft:client:" + minecraftVersion + ":mappings@txt";
        File client = MavenArtifactDownloader.generate(project, artifact, true);
        if (client == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Files.lines(client.toPath()).filter(line -> line.startsWith("#")).map(l -> l.substring(1).trim()).collect(Collectors.joining("\n")));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    private static Path getLicensePath(Project project, String hash) {
        return new File(Utils.getCache(project, "licenses"), hash + ".marker").toPath();
    }
}

